
#include "init_race.h"

/*******
 *  Initialize the list
 *******/
void initList(struct list *listStruct){
  memset(listStruct->filename, '\0', sizeof(listStruct->filename));
  listStruct->next = NULL;
}

/*******
 *  Add element to list
 *******/
void addToList(struct list *listStruct, char *name){
  struct list *ptr, *tmp;

  ptr = listStruct;

  /* handle first case scenario */
  if (ptr->filename[0] == '\0'){
    strncpy(ptr->filename, name, sizeof(ptr->filename));
    return;
  }
    
  while (ptr->next != NULL)
    ptr = ptr->next;

  tmp = (struct list *)malloc(sizeof(struct list));
  if (!tmp){
    perror("malloc: ");
    exit(1);
  }

  ptr->next = tmp;
  strncpy(tmp->filename, name, sizeof(tmp->filename));
#ifdef DEBUG
  printf("loaded file: %s\n", tmp->filename);
#endif
  tmp->next = NULL;
}


/*******
 *  unlink all of the files in the list and free the structures
 *******/
void removeFromList(struct list *listStruct){
  struct list *ptr, *tmp;
  int i=0;

  ptr = listStruct;

  /* check if only first element */
  if (ptr->next == NULL){
    unlink(ptr->filename);
#ifdef DEBUG
    printf("unlinked %s\n", ptr->filename);
#endif
    memset(ptr->filename, '\0', sizeof(ptr->filename));
    return;
  }

  /* handle middle elements */
  while (ptr->next){
    tmp = ptr->next;
    unlink(ptr->filename);
#ifdef DEBUG
    printf("unlinked %s\n", ptr->filename);
#endif
    ptr->next = NULL;
    i++;
    if (i == 1)
      memset(ptr->filename, '\0', sizeof(ptr->filename));
    else
      free(ptr);
    ptr = tmp;
  }
  
  /* handle last one */
  unlink(ptr->filename);
#ifdef DEBUG
  printf("unlinked %s\n", ptr->filename);
#endif
  free(ptr);

}

/********
 *  Walk the list and print the filenames as we go
 ********/
void walkList(struct list *listStruct){
  struct list *ptr;

  ptr = listStruct;

  while (ptr) {
    printf("filename: %s\n", ptr->filename);
    ptr = ptr->next;
  }
}




