#!/usr/bin/perl -w
# $Header: /var/lib/cvsd/var/lib/cvsd/SSHatter/src/SSHatter.pl,v 1.9 2007-10-06 15:01:57 timb Exp $
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
# list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
# * Neither the name of the Nth Dimension nor the names of its contributors may
# be used to endorse or promote products derived from this software without
# specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# (c) Tim Brown, 2007
# <mailto:timb@nth-dimension.org.uk>
# <http://www.nth-dimension.org.uk/> / <http://www.machine.org.uk/>

use strict;
use Parallel::ForkManager;
use Net::SSH::Perl;
use Time::HiRes qw(gettimeofday);

my $maximumprocess;
my $targetserverfilename;
my $usernamefilename;
my $passwordfilename;
my $sleeptime;
my $timingflag;
my $forkmanager;
my $usernamefilehandle;
my $username;
my $passwordfilehandle;
my $password;
my $targetserverfilehandle;
my $targetserver;
my $processid;
my $hostname;
my $portnumber;
my $sshhandle;
my $testedflag;
my $starttime;

sub usage {
	die "usage: " . $0 . " <maximumprocess> <targetserverfilename> <usernamefilename> <passwordfilename> <sleeptime> <timingflag>\n\tsleeptime: 0 - disable retries";
}

if (@ARGV != 6) {
	die "usage: " . $0 . " <maximumprocess> <targetserverfilename> <usernamefilename> <passwordfilename> <sleeptime> <timingflag>\n\tsleeptime: 0 - disable retries";
}
$maximumprocess = shift;
$targetserverfilename = shift;
$usernamefilename = shift;
$passwordfilename = shift;
$sleeptime = shift;
$timingflag = shift;
if ($maximumprocess =~ /([0-9]+)/) {
	$maximumprocess = $1;
} else {
	usage();
}
if (! -e $targetserverfilename) {
	usage();
}
if (! -e $usernamefilename) {
	usage();
}
if (! -e $passwordfilename) {
	usage();
}
if ($sleeptime =~ /([0-9]+)/) {
	$sleeptime = $1;
} else {
	usage();
}
if ($timingflag =~ /([01])/) {
	$sleeptime = $1;
} else {
	usage();
}

$forkmanager = new Parallel::ForkManager($maximumprocess);
open($usernamefilehandle, "<" . $usernamefilename);
while (<$usernamefilehandle>) {
	$username = $_;
	$username =~ s/\x0a//g;
	open($passwordfilehandle, "<" . $passwordfilename);
	while (<$passwordfilehandle>) {
		$password = $_;
		$password =~ s/\x0a//g;
		open($targetserverfilehandle, "<" . $targetserverfilename);
		while (<$targetserverfilehandle>) {
			$targetserver = $_;
			$targetserver =~ s/\x0a//g;
			$processid = $forkmanager->start() and next;
			$testedflag = 0;
			($hostname, $portnumber) = split(/:/, $targetserver);
			if ($portnumber && ($portnumber =~ /([0-9]+)/)) {
				$portnumber = $1;
				if (($portnumber <= 0) || ($portnumber > 65535)) {
					$portnumber = 22;
				}
			} else {
				$portnumber = 22;
			}
			print "[sshatter] trying " . $username . "@" . $hostname . ":" . $portnumber . "/" . $password . "\n";
			while ($testedflag != 1) {
				eval {
					$sshhandle = Net::SSH::Perl->new($hostname, port => $portnumber);
				};
				if ($@ ne "") {
					print STDERR "Net::SSH::Perl->new() failed: " . $@;
					if ($sleeptime > 0) {
						sleep($sleeptime);
					} else {
						$testedflag = 1;
					}
				} else {
					eval {
						if ($timingflag == 1) {
							$starttime = gettimeofday();
						}
						$sshhandle->login($username, $password);
						$sshhandle->cmd("echo SSHatter");
					};
					if ($@ ne "") {
						if ($timingflag == 1) {
							print "[sshatter] " . $username . "@" . $hostname . ":" . $portnumber . ":" . sprintf("%.4f", gettimeofday() - $starttime) .  " seconds elapsed\n";
						}
						if ($@ !~ /Permission denied/) {
							print STDERR "Net::SSH::Perl->cmd() failed: " . $@;
							if ($sleeptime > 0) {
								sleep($sleeptime);
							} else {
								$testedflag = 1;
							}
						} else {
							$testedflag = 1;
						}
					} else {
						print "[sshatter] " . $username . "@" . $hostname . ":" . $portnumber . ":" . sprintf("%.4f", gettimeofday() - $starttime) .  " seconds elapsed\n";
						print "[sshatter] " . $username . "@" . $hostname . ":" . $portnumber . "/" . $password . ":success\n";
						$testedflag = 1;
					}
				}
			}
			$forkmanager->finish();
		}
		close($targetserverfilehandle);
	}
	close($passwordfilehandle);
}
close($usernamefilehandle);
$forkmanager->wait_all_children();
exit(1);
