/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */

#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <string.h>
#include <sys/param.h>

#include <limits.h>

int expandfilename(char *filename,const char *name) {
	switch(name[0]) {
		case '/': strcpy(filename,name);return 0;
		case '~': {
			struct passwd *pas;
			if(name[1]=='/'||!name[1]) {
				uid_t uid=getuid();
				if((pas =getpwuid(uid))) {
					strcpy(filename,pas->pw_dir);
					strcat(filename,name+1);
					return 1;
					}
				else {
					strcpy(filename,name);
					return 2;
					}
				}
				else {
					char *sl=index(name,'/');
					if(sl) {
						strncpy(filename,name+1,(sl-name-1));
						filename[(sl-name-1)]='\0';
						pas=getpwnam(filename);
						if(pas) {
							strcpy(filename,pas->pw_dir);
							strcat(filename,sl+1);
							return 3;
							}
						}
					else {
						if((pas=getpwnam(name+1)))
							strcpy(filename,pas->pw_dir);
							return 4;
						}	
					strcpy(filename,name);
					return 5;
				}
			};
		default: if(getcwd(filename, MAXPATHLEN)) {
				int len=strlen(filename);
				filename[len]='/';
				strcpy(filename+len+1,name);
				return 5;
				}
			else {
				strcpy(filename,name);
				return 6;
				}
		};
	}
#ifdef TRY
void main(void) {
	char name[MAXPATHLEN];
	char input[MAXPATHLEN];
	while(1) {
		gets(input);
		 expandfilename(name,input);
		 puts(name);
		 }
	 }
#endif
