/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <unistd.h>
#include "readcolors.h"
       #include <pwd.h>
              #include <sys/types.h>
              #include <grp.h>
#include "getfile.h"

#include "system.h"

char space[240];
inline int min(int x,int y) {return (x>y)?y:x;}
inline int max(int x,int y) {return (x<y)?y:x;}
#ifdef CURSES
#include <curses.h>
#if defined(TEST) || defined(TEST2)
#define ggetch(x) wgetch(x)
#define thelines LINES
#define thecols COLS

int initscreen(void) {
	initscr();
	clearok(stdscr,FALSE);
	clearok(curscr,FALSE);

		noecho();
	   	cbreak();
	   	nonl();

	if(has_colors()) {
			short f,b;
			start_color();
			getfilecolors();
			}
		scrollok(stdscr,0);
	   	};
//#define SELSELATTR         SELATTR|A_REVERSE|A_BOLD
void getfilecolors(void) {
			init_pair(4,COLOR_RED,COLOR_BLUE);
			SELATTR=COLOR_PAIR(4)|A_BOLD;
			init_pair(5,COLOR_BLACK,COLOR_YELLOW);
			KEYATTR=COLOR_PAIR(5)|A_STANDOUT|A_BOLD;
			init_pair(6,COLOR_BLACK,COLOR_GREEN);
			TITLEATTR=COLOR_PAIR(6);
			init_pair(7,COLOR_WHITE,COLOR_BLACK);
			BACKATTR=COLOR_PAIR(7);
		}
#else
extern int thelines,thecols;
extern int ggetch(WINDOW *w);
#endif
inline void cursoraway(void) {
		leaveok(takescr,TRUE);
		leaveok(stdscr,FALSE);
		move(thelines-1,thecols);
		refresh();
		leaveok(stdscr,TRUE);
		}

//#define cursoraway()

	#define winb 48
	#define winh 15
WINDOW *takescr;
#define optionscreen takescr

#define	SELCOLOR wattrset(takescr,SELATTR)
#define	KEYCOLOR wattrset(takescr,KEYATTR)
#define	TITLECOLOR wattrset(takescr,TITLEATTR)
#define	SELSELCOLOR  wattrset(takescr,SELSELATTR)
#define	BACK wattrset(takescr,BACKATTR)
#define	NORMALCOLOR BACK
#define	UNSELCOLOR    wattrset(takescr,UNSELATTR)
#else
#ifdef CONIO
#include <conio.h>

#define	initscreen()
int  addnstr(char *x,int n) {
	int len=strlen(x);
	cwrite(x,min(len,n));
	}
#define addch putch
#define  waddstr(takescr,(x) cputs(x)
#define move(y,x) gotoxy(x+1,y+1)
#define endwin()
#define refresh()

#define clrtoeol() clreol()
#define	SELCOLOR textattr(LIGHTRED|(BLUE<<4))
#define	SELSELCOLOR textattr(LIGHTBLUE|(RED<<4))
#define	KEYCOLOR textattr(YELLOW|(BLACK<<4))
//#define	TITLECOLOR textattr(YELLOW|(RED<<4))
#define	TITLECOLOR textattr(BLACK|(CYAN<<4))
#define	BACK textattr(LIGHTMAGENTA|(BLACK<<4))
#define	NORMALCOLOR BACK
#define LINES tinfo.screenheight
#define COLS tinfo.screenwidth
#endif
#endif
	#define RETURN 0xff1
	#define NEXT 0xff2
	#define PREV 0xff3
	#define BEG 0xff4
	#define END 0xff5
	#define PGDN 0xff6
	#define PGUP 0xff7
	#define FILEPART 0xff8
	#define DIR 0xff9
	#define FIL 0xff10
	#define DOWN 0xff11
	#define UP 0xff12
	#define BACKSPACE 8
	#define DELETE 0xff13
	#define TAB  9
	#define SHIFTAB 0xff15
	#define QUIT 254
	#define REFRESH 12
	#define CLEAR  21

#include "keyinput.h"

#define keylabel(label,edit,menu,open) open,
int getfilesym[]= {
#include "keylist.h"
};
#undef keylabel


int  keyinput::keyseq(unsigned char input) {
		struct tree *iter;
		for(iter=keyhead->children;iter;iter=iter->next) 
			if(iter->ch==input) {
				if(iter->nr>0) {
					keyhead=iter;
					return -1;
					}
				keyhead=treebase;
				return iter->sym;
				};
		keyhead=treebase;
		return -1;

	}

extern void showkeys(FILE*,unsigned char *,int ) ;



void	freekeys(struct keyinput::tree *par) {
	struct keyinput::tree *next,*iter;
	if(!par->nr)
		return;
	for(iter=par->children;iter;iter=next) {
		next=iter->next;
		freekeys(iter);
		delete iter;
		}
	}









int keyinput::putseq(int sym,int nrkeys, unsigned char *keybuf) {
	unsigned char *keys=keybuf;
	int nr=nrkeys;
	struct tree *parent;
	struct tree *iter;
	for(parent=treebase;nr>0;parent=iter,keys++,nr--) {

		for(iter=parent->children;iter&&(iter->ch!=*keys);iter=iter->next) 
			;

		if(iter) {
				if(nr==1) {
					if(iter->nr>0) {
						fprintf(stderr,"Overwriting previous keys with: ");
						showkeys(stderr,keybuf,nrkeys);
						freekeys(iter);
						fprintf(stderr,"\n");
						}
					iter->sym=sym;
					iter->nr=0;
					return 0;
					}
				if(iter->nr)
					continue;
				fprintf(stderr,"Overwriting previous key with: ");
				showkeys(stderr,keybuf,nrkeys);
				fprintf(stderr,"\n");
				}
		do {
			iter= parent->children;
			parent->children=new (struct tree);

			parent->children->next=iter;
			iter=parent->children;
			iter->ch=*keys;
			iter->nr=0;
			iter->children=NULL;

			parent->nr++;
			nr--;
			keys++;
			parent=iter;
				} while(nr>0);
			iter->sym=sym;
			return 0;
		}
	return 0;
	}

#include "glob.h"

void	attrall(WINDOW *takescr,int attrs) {
	int y,x,i;
	getmaxyx(takescr,y,x);
	char line[x+1];
	memset(line,' ',x);
	wattrset(takescr, attrs );
	wmove(takescr,0,0);
	for(i=0;i<y;i++) 
		waddnstr(takescr,line,x);
	}

void winsel::show(void) {
	int last=min(h,tot-beg);
	SELCOLOR;
	refresh();
	for(int i=0;i<h;i++) {
		wmove(takescr,i+y,x-1);
//		s/\<addnstr\>(/waddnstr(takescr,/g
		waddnstr(takescr,space,l+2);

		}
	for(int i=0;i<last;i++) {
		wmove(takescr,i+y,x);
		waddnstr(takescr,strings[beg+i],(l));
		}
	if(tot<1)
		return;
	if(sel>=last)
		sel=last-1;
	if(sel<0)
		sel=0;
	SELSELCOLOR;
	wrefresh(takescr);
	wmove(takescr,y+sel,x);
	waddnstr(takescr,space,l);
	wmove(takescr,y+sel,x);
	waddnstr(takescr,strings[beg+sel],l);
	wrefresh(takescr);
	wrefresh(takescr);
	}
	/*
void winsel::showsel(int dir) {
	int oldpos=sel+beg;
	int newpos=oldpos+dir;
	int endscr=min(beg+h,tot);
	int newsel;
	if(newpos<0)
		newpos=0;
	if(newpos>=tot)
		newpos=tot-1;

	if(newpos<beg) {
		beg=newpos;
		sel=0;
		show();
		return;
		}
	else {
		if(newpos>=endscr) {
			sel=min(h,tot-beg)-1;
			beg=newpos-sel;
			show();
			return;
			}
		else
			newsel=sel+dir;
		}

	SELCOLOR;
	wmove(takescr,y+sel,x);
	waddnstr(takescr,space,l);
	wmove(takescr,y+sel,x);
	waddnstr(takescr,strings[beg+sel],l);
	sel=newsel;
	SELSELCOLOR;
//		s/\<refresh(/wrefresh(takescr
	wrefresh(takescr);
	wmove(takescr,y+sel,x);
	waddnstr(takescr,space,l);
	wmove(takescr,y+sel,x);
	waddnstr(takescr,strings[beg+sel],l);
	wrefresh(takescr);
	}

*/
void winsel::showsel(int dir) {
	if(tot<1)
		return;
	int newsel=sel+dir;
	int last=min(h,tot-beg);
	if(newsel>=last)  {
		if((newsel+beg)>=tot)  {
			beg=tot-last;
			sel=tot-1-beg;
			}
		else  {
			beg+=dir;
			}
		 show();
		 return;
		}
	if(newsel<0) {
		if(beg) {
			sel=beg+newsel;
			beg=max(0,beg+dir);
			sel=max(0,sel-beg);
			}
		else
			sel=0;
		show();
		return;
		}
	if((newsel+beg)>=(tot-1))  
		newsel=tot-beg-1;

		SELCOLOR;
		wmove(takescr,y+sel,x);
		waddnstr(takescr,space,l);
		wmove(takescr,y+sel,x);
		waddnstr(takescr,strings[beg+sel],l);
		sel=newsel;
		SELSELCOLOR;
//		s/\<refresh(/wrefresh(takescr
		wrefresh(takescr);
		wmove(takescr,y+sel,x);
		waddnstr(takescr,space,l);
		wmove(takescr,y+sel,x);
		waddnstr(takescr,strings[beg+sel],l);
		wrefresh(takescr);
	}
	void winsel::leave(void) {
		if(tot<1)
			return;
		UNSELCOLOR;
		wrefresh(takescr);
		wmove(takescr,y+sel,x);
		waddnstr(takescr,space,l);
		wmove(takescr,y+sel,x);
		waddnstr(takescr,strings[beg+sel],l);
		wrefresh(takescr);
		}	
#include "getlabel.h"
char *winsel::select(int key) {
		switch(key) {
			case RETURN: in=0;
				if(tot>0)
					return strings[beg+sel];
				break;
			case DOWN: showsel(1);;break;
			case UP: showsel(-1);;break;
			case END: showsel(tot);break;
			case BEG: showsel(-tot);break;
			case PGDN: showsel(h-1);break;
			case PGUP: showsel(1-h);break;
			default:
				if((key<0xff)&&isprint(key)) {
					int start,pos;
					if(!in)
						start=0;
					else
						start=sel+beg;
					al[in++]=key;
					al[in]='\0';
					pos=getunderlabel(strings+start,tot-start,al);
					showsel(pos+start-(sel+beg));
					return NULL;
					}
			};
		in=0;
		return NULL;
		}
int winsel::selectindex(int key) {
		switch(key) {
			case RETURN: in=0; 
			if(tot>0)
					return beg+sel;
			break;
			case DOWN: showsel(1);;break;
			case UP: showsel(-1);;break;
			case END: showsel(tot);break;
			case BEG: showsel(-tot);break;
			case PGDN: showsel(h-1);break;
			case PGUP: showsel(1-h);break;
			default:
			if((key<0xff)&&isprint(key)) {
				int start,pos;
				if(!in)
					start=0;
				else
					start=sel+beg;
				al[in++]=key;
				al[in]='\0';
				pos=getunderlabel(strings+start,tot-start,al);
				showsel(pos+start-(sel+beg));
				return -1;
				}
			};
		in=0;
		return -1;
		}

		/*
char *winsel::select(void) {
	int key;
	while(1) {
		while((key=input.keyseq(ggetch(takescr)))==-1)
			wrefresh(takescr);
		switch(key) {
			case RETURN: return strings[beg+sel];
			case NEXT: showsel(1);;break;
			case PREV: showsel(-1);;break;
			case END: showsel(tot);break;
			case BEG: showsel(-tot);break;
			case PGDN: showsel(h-1);break;
			case PGUP: showsel(1-h);break;
			};
		wmove(takescr,-1,-1);
		wrefresh(takescr);
		}
	}
	*/

#define	seqput(sym,keys...) keyinp->putseq(sym,sizeof((unsigned char [])##keys),(unsigned char []) ##keys)
void putkeys(class keyinput *keyinp) {
		seqput(RETURN,{13});
		seqput(RETURN,{10});
		seqput(DOWN,{27,91,66});
		seqput(UP,{27,91,65});
		seqput(END,{27,91,52,126});
		seqput(BEG,{27,91,49,126});
		seqput(PGUP,{27,91,53,126});
		seqput(PGDN,{27,91,54,126});

		seqput(NEXT,{27,91,67});
		seqput(PREV,{27,91,68});
		seqput(BACKSPACE,{BACKSPACE});
		seqput(DELETE,{27,91,51,126});
		seqput(QUIT,{27,QUIT});
		seqput(QUIT,{27,120});
		seqput(REFRESH,{REFRESH});

		seqput(CLEAR,  {21});
		seqput(SHIFTAB,{27,91,90});
		seqput(TAB,{9});

		seqput(FILEPART,{27,102});
		seqput(DIR,{27,100});
		seqput(FIL,{27,110});
		memset(space,' ',240);
		space[239]='\0';
		}
keyinput input(putkeys);

	line::line(char *name,int xpos,int ypos,int s=38):end(endbuf) {
		size=s;
		bij=0;
		x=xpos;y=ypos;
		pos=end=strlen(name);
		memmove(buf,name,end);
		};
	line::line(char *name,int &p, int xpos,int ypos,int s=38):end(p) {
		size=s;
		bij=0;
		x=xpos;y=ypos;
		pos=end;
		memmove(buf,name,end);
		};
	void line::show(void) {
		SELCOLOR ;
		wmove(takescr,y,x);
		for(int i=0;i<(size+2);i++)
			waddch(takescr,' ');
		wmove(takescr,y,x+1);
		for(char *i=buf+bij;i<(buf+bij+min(end-bij,size));i++)
			waddch(takescr,*i);
		
	//	waddnstr(takescr,buf+bij,min(end-bij,size));
		wmove(takescr,y,x+pos-bij+1);
		}
	void line::add(int key) {
		SELCOLOR ;
		cursor();
		pos++;
		waddch(takescr,key);
		}
	void line::take(void) {
		start=1;
		pos=0;
		show();
		KEYCOLOR;
		wmove(takescr,y,x+1);

		for(char *i=buf+bij;i<(buf+bij+min(end-bij,size));i++)
			waddch(takescr,*i);
//		waddnstr(takescr,buf+bij,min(end-bij,size));
		cursor();
		}
	char *line::change(int key) {
		switch(key) {
			case RETURN: buf[end]='\0';return buf;
			case NEXT: 
				if(start)
					show();
				if(pos<end) {
					pos++;
					if(pos>=(bij+size)) {
						bij++;
						show();
						}
					else
						cursor();
					}
				break;
			case PREV: 
				if(pos>0) {
					pos--; 
					if(pos<bij) {
						bij--;
						show();
						}
					else {
						if(start)
							show();
						else
							cursor();
						}

					}
				else
					if(start)
						show();
				break;
			case BEG:  bij=0;pos=0; show();break;
			case END:  if(end<size)
						bij=0;
				else 
					bij=end-10;
				pos=end; 
				show();
				break;
			case BACKSPACE: 
					if(pos>0) {
						end--;
						pos--;

						memmove(buf+pos,buf+pos+1,end-pos);
						if(pos<bij) {
							bij--;
							}
						show();
						}
					else {
						if(start)
							show();
						};
					break;
			case DELETE: 
				if(!start) {
					if(pos<end) {
							end--;
							memmove(buf+pos,buf+pos+1,end-pos);
							cursor();
							show();
							}
					break;
					}
			case CLEAR:
				memmove(buf,buf+pos,end-pos);
				end-=pos;
				pos=0;bij=0;
				show();
			default:
			if(start) {
				bij=pos=end=0;
				start=0;
				show();
				}
			if((key<0xff)&&isprint(key)) {
				if(pos<end) {
					memmove(buf+pos+1,buf+pos,end-pos);
					end++;
					buf[pos++]=key;
					if(pos>=(bij+size))
						bij++;
					show();
					}
				else {
					buf[pos]=key;
					pos++;
					if(pos>end)
						end=pos;
					if(pos>=(bij+size)) {
						bij++;
						show();
						}
					else {
						pos--;
						add(key);
						}
					}
				return NULL;
				}
		}
		start=0;
		return NULL;
	}


#define p(x,el) ((x&(1<<el))?(permsym[el]):'-')

                     #include <time.h>
//char timestr[]="%b %d %Y %X";
void filegeg(char *name,char *buf) {
	char *permsym="xwrxwrxwr",*ptr;
	struct tm *tp;
	int i,j=0;
	struct stat st;
	char *user;
	struct passwd *pas;
	char timestr[]=" %b %d %Y %H:%M";
	if(stat(name,&st)<0) {
		buf[0]='\0';
		return;
		}
	sprintf(buf,"%d ",st.st_nlink);
	j=strlen(buf);
	if(S_ISDIR(st.st_mode))
		buf[j++]='d';
	else
		buf[j++]='-';
	for(i=8;i>=0;i--)
		buf[j++]=p(st.st_mode,i);
	if((pas=getpwuid(st.st_uid)))
		user=pas->pw_name;
	else
		user="????";
	tp=localtime(&st.st_mtime);

	ptr=buf+j;
	strftime(ptr,80,timestr,tp);
	sprintf(strlen(ptr)+ptr," %s %ld",user,st.st_size);
	}
/*
char * selectitem(char *prompt,char **files,int nr,int start) {
		int key;
		char *name;

		int xpos=1;
		int ypos=1;
		int l=11,c=40;
		int begy=(thelines-l)/2;
		int begx=(thecols-c)/2;
		if(!takescr)
			takescr=newwin(l,c,max(begy,0),max(begx,0));
		else {
			int x,y;
			 getbegyx(takescr,y,x);
			if(((y!=begy)||(x!=begx))) {
				delwin(takescr);
				takescr=newwin(l,c,max(begy,0),max(begx,0));
				}
			}
		if(!takescr)
			return NULL;
		werase(takescr);
		wrefresh(takescr);
		winsel fil(files,nr,xpos,ypos,max((start-l+1),0),l-1,c-2);
		TITLECOLOR ;
		wmove(takescr,ypos-1,xpos-1);
		waddnstr(takescr,space,42);
		wmove(takescr,ypos-1,xpos);
		waddnstr(takescr,prompt,41);
		fil.sel=start-fil.beg;
		fil.show();
		while(1){
			key=ggetch(takescr);
			while((key=input.keyseq(key))==-1)
					key=ggetch(takescr);
			switch(key) {
				case	REFRESH: return (char *)1;
				case 	QUIT: return NULL;
				default: if((name=fil.select(key))) {
					return name;
					}
				};
			}
		}
		*/
WINDOW *rightwin(int l,int c,int by,int bx) {
		if(!takescr)
			takescr=newwin(l,c,by,bx);
		else {
			int x,y;
			 getbegyx(takescr,y,x);
			if(((y!=by)||(x!=bx))||(getmaxyx(takescr,y,x), (y!=l)||(x!=c))) {
				delwin(takescr);
				takescr=newwin(l,c,by,bx);
				}
			}
		return takescr;
		}
int  selectitemindex(char *prompt,char **files,int nr,int start) {
		int key;
		int nameindex;

		int xpos=1;
		int ypos=1;
		int l=15,c=60;
		int begy=(thelines-l)/2;
		int begx=(thecols-c)/2;
		rightwin(l,c,max(begy,0),max(begx,0));
		if(!takescr)
			return LONG_MAX;
		werase(takescr);
		wrefresh(takescr);
		winsel fil(files,nr,xpos,ypos,max((start-l+5),0),l-1,c-2);
		TITLECOLOR ;
		wmove(takescr,ypos-1,xpos-1);
		waddnstr(takescr,space,c+2);
		wmove(takescr,ypos-1,xpos);
		waddnstr(takescr,prompt,c+1);
		fil.sel=start-fil.beg;
		fil.show();
		while(1){
			key=ggetch(takescr);
			if(!isprint(key)) {
				while((key=input.keyseq(key))==-1)
						key=ggetch(takescr);
				}
			switch(key) {
				case	REFRESH: return (LONG_MAX-1);
				case 	QUIT: return LONG_MAX;
				default: if((nameindex=fil.selectindex(key))>=0) {
					return nameindex;
					}
				};
			}
		}
//	qsort(files,len,sizeof(char *),strcmp);
void arraysort(char **files,int len) {
	if(len<2)
		return;
	int half=len/2;
	char *pivot=files[half];
	int it1=0,it2=len-1,i;
	char **naar=new (char *)[len]; 
	memmove(naar,files,len*sizeof(char *));
	for(i=0;i<half;i++){
		if(strcmp(naar[i],pivot)<0) 
			files[it1++]=naar[i];
		else
			files[it2--]=naar[i];
		}
	for(i=half+1;i<len;i++){
		if(strcmp(naar[i],pivot)<0) 
			files[it1++]=naar[i];
		else
			files[it2--]=naar[i];
		}
	delete[] naar;
	arraysort(files,it1);
	arraysort(files+it2+1,len-it1-1);
	files[it1]=pivot;
	}

#define titlemaak(waar) \
	switch(waar) { \
		case 0:\
			wmove(takescr,ypos+1,xpos+1);\
			SELSELCOLOR ;\
			waddch(takescr,'F');\
			KEYCOLOR ;\
			waddstr(takescr,"iles: ");\
			break;\
		case 1:\
			wmove(takescr,ypos+1,xpos+25);\
			SELSELCOLOR ;\
			waddch(takescr,'D');\
			KEYCOLOR ;\
			waddstr(takescr,"irectories: ");\
			break;\
		case 2:\
		wmove(takescr,ypos+winh-2,xpos+1);\
			SELSELCOLOR ;\
			waddch(takescr,'N');\
			KEYCOLOR ;\
			waddstr(takescr,"ame: ");\
			break;\
		}
#define titleweg(waar) \
	switch(waar) { \
		case 0:\
			wmove(takescr,ypos+1,xpos+1);\
			KEYCOLOR ;\
			waddch(takescr,'F');\
			NORMALCOLOR ;\
			waddstr(takescr,"iles: ");\
			break;\
		case 1:\
			wmove(takescr,ypos+1,xpos+25);\
			KEYCOLOR ;\
			waddch(takescr,'D');\
			NORMALCOLOR ;\
			waddstr(takescr,"irectories: ");\
			break;\
		case 2:\
		wmove(takescr,ypos+winh-2,xpos+1);\
			KEYCOLOR ;\
			waddch(takescr,'N');\
			NORMALCOLOR ;\
			waddstr(takescr,"ame: ");\
			break;\
		}
const char *mvtakefile(int ypos,int xpos,const char *com,const char *pat) {
	char *showstr;
	int end;
	char *fil;
	char filebuf[MAXPATHLEN];
	char **files,*lekt;
	int waar=2;
	char str[winb];
	memset(str,' ',winb);
	int len=strlen(com);

	input.putseq(FILEPART,2,((unsigned char []){27,102}));
	input.putseq(DIR,2,((unsigned char []){27,100}));
	input.putseq(FIL,2,((unsigned char []){27,110}));
//	wrefresh(takescr);
	TITLECOLOR ;
	wmove(takescr,ypos+0,xpos+0);
	waddnstr(takescr,str,winb);
	wmove(takescr,ypos+0,xpos+(23-(len/2)));
	waddstr(takescr,com);

	wmove(takescr,ypos+1,xpos+1);
	KEYCOLOR ;
	waddch(takescr,'F');
	NORMALCOLOR ;
	waddstr(takescr,"iles: ");
	wmove(takescr,ypos+1,xpos+25);
	KEYCOLOR ;
	waddch(takescr,'D');
	NORMALCOLOR ;
	waddstr(takescr,"irectories: ");

	wmove(takescr,ypos+winh-2,xpos+1);
	KEYCOLOR ;
	waddch(takescr,'N');
	NORMALCOLOR ;
	waddstr(takescr,"ame: ");
	const char *path=pat;
 back: {
	lekt=0;
	showstr="";
	expandfilename(filebuf,path);
	path=filebuf;
	if(chdir(path)<0) {
		if((fil=rindex(path,'/'))) 
			*fil++='\0';
		else
			fil="*";
		nasplit:
		chdir(path);
		}
	else
		fil="*";
	TITLECOLOR ;
	wmove(takescr,ypos+winh-1,xpos);
	waddnstr(takescr,str,winb);
	wmove(takescr,ypos+winh-1,xpos+1);
	getcwd(filebuf,MAXPATHLEN);
	waddnstr(takescr,filebuf,winb-1);
	len=getfiles(fil,&files,&end);
	arraysort(files,end);
	arraysort(&files[end],len-end);
	winsel sel(files,end,xpos+2,ypos+2);
	winsel dir(&files[end],len-end,xpos+26,ypos+2);
	winsel *vorig;
	line lin(fil,xpos+7,ypos+winh-2,35);
	sel.show();
	dir.show();
	terug:
	lin.show();
	switch(waar) {
		case 0:
			dir.leave();
			vorig=&sel;
			sel.showsel(0);
			break;
		case 1:
			sel.leave();
			vorig=&dir;
			dir.showsel(0);
			break;
		case 2:
		default: 
			sel.leave();
			dir.leave();
			vorig=&sel;
			lin.take();
		};
	titlemaak(waar);
	wrefresh(takescr);
	while(1) {
		showstr=vorig->current();
		NORMALCOLOR;
		wmove(takescr,ypos+winh-3,xpos+1);
		waddnstr(takescr,str,winb-2);
		wmove(takescr,ypos+winh-3,xpos+1);
		if(showstr)
			filegeg(showstr,filebuf);
		waddnstr(takescr,filebuf,winb-2);
		lin.cursor();
		wrefresh(takescr);
		int key;
		key=ggetch(takescr);
	DEBUGGING("Start: %d=ggetch()\n",key)
		if(!(isprint(key)) )
			while((key=input.keyseq(key))==-1) {
				key=ggetch(takescr);
				DEBUGGING("%d=ggetch()\n",key)
				}
		
		wrefresh(takescr);
	switch(key) {
		case REFRESH: return pat;
		case QUIT: return NULL;
		case SHIFTAB: titleweg(waar);waar--; if(waar<0) waar=2; goto terug;
		case TAB: titleweg(waar);waar++;
			if(waar>2) 
				waar=0;
			goto terug;
			break;
		case FILEPART:
			if(vorig!=&sel) {
				vorig->leave();
				vorig=&sel;
				}
			sel.showsel(0);
			titleweg(waar);
			waar=0;
			titlemaak(waar);
			break;
		case DIR:
			if(vorig!=&dir) {
				vorig->leave();
				vorig=&dir;
				}
			titleweg(waar);
			dir.showsel(0);
			waar=1;
			titlemaak(waar);
			break;


		case FIL: 

			titleweg(waar);
			vorig->leave();
			waar=2;lin.take();
			titlemaak(waar);
			break;
		default: {
			lekt=NULL;
			switch(waar) {
				case 0: lekt=sel.select(key); 
					if(lekt)  {
						return lekt;
						}
					break;
				case 1: lekt=dir.select(key); 
					if(lekt)  {
							path=lekt;
							fil="*";
							goto nasplit;
							};
					break;
				case 2: lekt=lin.change(key); 
					if(lekt) {
						titleweg(waar);
						     waar=0;
							path=lekt;
							goto back;
							};
					break;
				};
			};
		};
	}
	}	
	}

void resetinput(void) {
				nocbreak();
				noecho();
				cbreak();
				nonl();
	}
const char *takefile(const char *com,const char *pat) {
	int begy=(thelines-winh)/2;
	int begx=(thecols-winb)/2;
	rightwin(winh,winb,max(begy,0),max(begx,0));
	if(takescr) {
		touchwin(takescr);
		attrall(takescr,BACKATTR);
		const char  *ret;
		leaveok(takescr,FALSE);
		ret=mvtakefile(0,0,com,pat);
		cursoraway();
		return ret;
		}
	return NULL;
	}




	item::item(char *txt1,int ya,int xb) {
		strcpy(text,txt1);
		if((after=index(text,'~'))) {
			*after++='\0';
			ch=*after++;
			}
		else {
			after="";
			ch=' ';
			}
		lowch=tolower(ch);
		x=xb;
		y=ya;
		};
/*
#define	SELCOLOR wattrset(takescr,SELATTR)
#define	KEYCOLOR wattrset(takescr,KEYATTR)
#define	SELSELCOLOR wattrset(takescr,SELATTR|A_REVERSE|A_BOLD)
#define	TITLECOLOR wattrset(takescr,TITLEATTR)
#define	BACK wattrset(takescr,BACKATTR)
#define	NORMALCOLOR BACK
#define	UNSELCOLOR  TITLECOLOR
*/
	void check::show(void) {
//		wattrset(optionscreen,CHECKCOLOR);
		SELCOLOR;
		wmove(optionscreen,y,x);
		waddch(optionscreen,'[');
		waddch(optionscreen,(var?'x':' '));
		waddch(optionscreen,']');
		waddch(optionscreen,' ');
		waddstr(optionscreen,text);
		KEYCOLOR;
//		wattrset(optionscreen,KEYCHECKCOLOR);
		waddch(optionscreen,ch);
		SELCOLOR;
//		wattrset(optionscreen,CHECKCOLOR);
		waddstr(optionscreen,after);
		};
	void check::select(void) {
		SELSELCOLOR;
//		wattrset(optionscreen,SELCHECKCOLOR);
		wmove(optionscreen,y,x);
		waddch(optionscreen,'[');
		waddch(optionscreen,(var?'x':' '));
		waddch(optionscreen,']');
		waddch(optionscreen,' ');
		waddstr(optionscreen,text);
		KEYCOLOR;
//		wattrset(optionscreen,KEYCHECKCOLOR);
		waddch(optionscreen,ch);
		SELSELCOLOR;
//		wattrset(optionscreen,SELCHECKCOLOR);
		waddstr(optionscreen,after);
		wmove(optionscreen,y,x+1);
		};

	 int check::switchvar(void) {
		var=!var;
		SELSELCOLOR;
//		wattrset(optionscreen,SELCHECKCOLOR);
		wmove(optionscreen,y,x);
		waddch(optionscreen,'[');
		waddch(optionscreen,(var?'x':' '));
		waddch(optionscreen,']');
		wmove(optionscreen,y,x+1);
		return 0;
		};

	int Common::save(void) {
		old=last->val;
		return 0;
		}
	 void or::sel(void) {
		wmove(optionscreen,y,x);
		waddch(optionscreen,'(');
		waddch(optionscreen,(com->last==this?'*':' '));
		waddch(optionscreen,')');
		}
	void or::show(void) {
		SELCOLOR;
		sel();
		waddch(optionscreen,' ');
		waddstr(optionscreen,text);
		KEYCOLOR;
//		wattrset(optionscreen,KEYCHECKCOLOR);
		waddch(optionscreen,ch);
		SELCOLOR;
//		wattrset(optionscreen,CHECKCOLOR);
		waddstr(optionscreen,after);
		};
	void or::select(void) {
		SELCOLOR;
		sel();
		waddch(optionscreen,' ');
		waddstr(optionscreen,text);
		KEYCOLOR;
//		wattrset(optionscreen,KEYCHECKCOLOR);
		waddch(optionscreen,ch);
		SELSELCOLOR;
//		wattrset(optionscreen,SELCHECKCOLOR);
		waddstr(optionscreen,after);
		wmove(optionscreen,y,x+1);
		};
	void or::showvar(void) {
//		wattrset(optionscreen,CHECKCOLOR);
		SELCOLOR;
		sel();
		wmove(optionscreen,y,x+1);
		}
	void or::selectvar(void) {
		SELSELCOLOR;
//		wattrset(optionscreen,SELCHECKCOLOR);
		sel();
		wmove(optionscreen,y,x+1);
		}

	 int or::switchvar(void) {
	 	or *was=com->last;
	 	if(was!=this) {
			com->last=this;
			was->showvar();
			selectvar();
			return 1;
			}
		return 0;
		};


	void action::show(void) {
		SELCOLOR;
	//	wattrset(optionscreen,CHECKCOLOR);
		wmove(optionscreen,y,x);
		waddstr(optionscreen,text);
		KEYCOLOR;
	//	wattrset(optionscreen,KEYCHECKCOLOR);
		waddch(optionscreen,ch);
		SELCOLOR;
	//wattrset(optionscreen,CHECKCOLOR);
		waddstr(optionscreen,after);
		wmove(optionscreen,y,x);
		};
	void action::select(void) {
		SELSELCOLOR;
	//	wattrset(optionscreen,SELCHECKCOLOR);
		wmove(optionscreen,y,x);
		waddstr(optionscreen,text);
		KEYCOLOR;
	//	wattrset(optionscreen,KEYCHECKCOLOR);
		waddch(optionscreen,ch);
//		wattrset(optionscreen,SELCHECKCOLOR);
		SELSELCOLOR;
		waddstr(optionscreen,after);
		wmove(optionscreen,y,x);
		};

	int ok::saveall(void) {
		var=1;
		return 2;
		}


	void lineitem::show(void) {
		SELCOLOR;
	//	wattrset(optionscreen,CHECKCOLOR);
		wmove(optionscreen,y,x);
		waddstr(optionscreen,text);
		KEYCOLOR;
	//	wattrset(optionscreen,KEYCHECKCOLOR);
		waddch(optionscreen,ch);
		SELCOLOR;
	//wattrset(optionscreen,CHECKCOLOR);
		waddstr(optionscreen,after);
		wmove(optionscreen,y,x);
		l.show();
		}
	void lineitem::select(void) { 
		SELSELCOLOR;
	//	wattrset(optionscreen,SELCHECKCOLOR);
		wmove(optionscreen,y,x);
		waddstr(optionscreen,text);
		KEYCOLOR;
	//	wattrset(optionscreen,KEYCHECKCOLOR);
		waddch(optionscreen,ch);
//		wattrset(optionscreen,SELCHECKCOLOR);
		SELSELCOLOR;
		waddstr(optionscreen,after);
		wmove(optionscreen,y,x);
		l.take();
		}

	int lineitem::saveall(void) {
		return 2;
		}



#define	keydef(sym,keys...) input.putseq(sym,sizeof((unsigned char [])##keys),(unsigned char []) ##keys)
int show(item **al,int maxar,int old) {
	int i,news=old,ch,res;

	attrall(takescr,SHOWBACK);
//	wattrset(takescr,SHOWBACK);
	box(takescr,0,0);

	unsigned char k[2];
	k[0]=27;
	for(i=0;i<maxar;i++) {
		al[i]->show();
		k[1]=al[i]->thekey();
		input.putseq(i|0xfff000,2,k);
		}
	k[1]=al[old]->thekey();
	input.putseq(old|0xfff000,2,k);
	al[old]->select();

	leaveok(takescr,FALSE);
	wrefresh(takescr);
	while(1){
		ch=ggetch(takescr);
		if(!(isprint(ch)) )
			while((ch=input.keyseq(ch))==-1)
				ch=ggetch(takescr);
		switch(ch) {
			case QUIT : cursoraway(); return 0;
			case DOWN:
			case TAB:	news++;if(news>=maxar) news=0; break;
			case SHIFTAB:;
			case UP: news--;if(news<0) news=maxar-1; break;
			case RETURN: if((res=al[old]->saveall())) {
					if(res==2) {
						for( i=0;i<maxar;i++) {
							al[i]->save();
//							delete(al[i]);
							}

						cursoraway();
						return old+1;
						}
					cursoraway();
					return 0;
					}
				break;
			case REFRESH: 
				cursoraway();
				return LONG_MAX;
			default: 
				if((0xfff000&ch)==0xfff000) {
					int key=ch&0xfff;
					if(key>=0&&key<maxar)
						news=key;
					else
						al[old]->change(ch);
					}
				else
					al[old]->change(ch);
					/*
					if(al[old]->change(ch)) {
						al[old]->save();
						for(i=0;i<maxar;i++)
							delete(al[i]);
						}
						*/

			};
		if(old!=news) {
			al[old]->show();
			al[news]->select();
			old=news;
			}
		wrefresh(takescr);
		}
	}




#ifdef TEST2
void main(void) {
	int i,reg=0,cas=1,maxar=4;
	char get[256]="*";

	initscreen() ;

	int wlin=15,wcol=60;
	while(1) {

		Common combase(reg),*com=&combase;
		plcsconfig(wlin,wcol,2,com->last=(or*)al[reg], ore("~Een",2,3,0,com),ore("~Twee",3,3,1,com), 
		ore("~Drie",4,3,2,com), 
		ore("~Vier",5,3,3,com), 
			liner("~Name",get,7,3),
			oke(12,5),
			act("C~ancel", 12,15)); 

		printw("reg=%d, cas=%d get=%s\n",reg,cas,get);
		refresh();
		}
	getch();
	endwin();
	}
#endif

#ifdef TEST
void main(int argc,char **argv) {
	int f,b;
	const char *file,*prompt,*orig;
	if(argc<3) {
		file="*";
		if(argc<2)
			prompt="Select file";
		else
			prompt=argv[1];
		}
	else  {
		 file=argv[2];
		 prompt=argv[1];
		 }
	orig=file;
	do {
		initscreen();
		file=takefile(prompt,file);
		endwin();
		} while(file==orig);
	if(file)
		write(3,file,strlen(file));
	}
#endif
