/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */

#ifdef  __cplusplus
extern "C" {
#endif
const char *mvtakefile(int ypos,int xpos,const char *com,const char *pat) ;
const char *takefile(const char *com,const char *pat) ;
void getfilecolors(void) ;

char * selectitem(char *prompt,char **files,int nr,int start) ;
int  selectitemindex(char *prompt,char **files,int nr,int start) ;
#ifdef  __cplusplus
}
#include <curses.h>
extern WINDOW *takescr;
class winsel {
	public:
	char al[80];
	int in;
	char **strings;
	int tot,beg,h,l,x,y,sel;
	winsel(char **str,int nr,int xpos,int ypos,int begin=0,int hight=10,int len=20) {
		strings=str;
		tot=nr;
		beg=begin;
		h=hight;
		l=len;
		sel=0;
		x=xpos;
		in=0;
		y=ypos;
		};
	~winsel() {}
	char *current(void) {
		if(!tot)
			return NULL;
		return strings[beg+sel];
		};
	void leave(void) ;
	void show(void) ;
//	char *select(void) ;
	char *select(int key) ;
	int selectindex(int key) ;
	void showsel(int) ;
	};

class item {
	public:
	char text[80],*after;
	int ch;
	char lowch;
	int x,y;
	public:

	item::item(void) {;};
	item::item(char *txt1,int ya,int xb) ;
	char thekey(void) {return lowch;};
	virtual void show(void) =0;
	virtual void select(void)=0; 
	virtual int switchvar(void) =0;
	virtual int save(void) {return 0;} ;
	virtual int saveall(void) {return 0;} ;
	virtual int change(int key) {if(key==' '||key=='x'||key=='*') return switchvar(); return 0;};

	};

class line {
	public:
	char buf[256];
	int &end,endbuf;
	int size,pos,bij;
	int x,y;
	int start;
	line(char *name,int xpos,int ypos,int s=38) ;
	line(char *name,int &p,int xpos,int ypos,int s=38) ;
	void show(void) ;
	void add(int key) ;
	void take(void) ;
inline	void cursor(void) {
		wmove(takescr,y,x+pos+1-bij);
		}
	char *change(int key) ;

	};
class lineitem:public item {
	line l;
	char *var;
	public:
	lineitem(char *txt,char *name,int ypos,int xpos,int s=35): item(txt,ypos,xpos),l(name,xpos+strlen(txt)+1,ypos,s) {
		var=name;
		}
	lineitem(char *txt,int &len,char *name,int ypos,int xpos,int s=35): item(txt,ypos,xpos),l(name,len,xpos+strlen(txt)+1,ypos,s) {
		var=name;
		}

	void show(void) ;
	void select(void);

	int switchvar(void) {l.change(' ');return 0;};
	int save(void) {memmove(var,l.buf,l.end);var[l.end]='\0';return 0;};
	int change(int key) { return (int)l.change(key);};
	int saveall(void);
	};

class check: public item {
	public:
	int var;
	int &old;
	check(void): old(var) {; };
	check(char *txt,int y1,int x1,int &var1): item(txt,y1,x1), old(var1) {
		var=var1;
		};
	void show(void) ;
	void select(void) ;
	 int switchvar(void) ;
	 int save(void) {
		old=var;
		return 0;
		};
	};
class or;
class Common {
	public:
	int &old;
	or *last;
	Common(int &v):old(v) {
		};
	or *setlast(or *l) {
		last=l;
		return l;
		}
	int save(void);
	};
class or: public item {
	public:
	int val;
	Common *com;
	or(char *txt,int y1,int x1,int v,Common *c): item(txt,y1,x1), val(v),com(c) {
		};
	void show(void) ;
	void select(void) ;
	 int switchvar(void) ;
	 int save(void) {
	 	return com->save();
		};
	void or::showvar(void);
	void or::selectvar(void) ;
	 void or::sel(void) ;
	int saveall(void) {
			return 2; 
			};
	};
class action: public item {
	protected:
	int var;
	public:
	action(void) {;};
	action(char *txt,int y1,int x1,int &v): item(txt, y1, x1),var(v) {;};
	void show(void) ;
	void select(void) ;
	 virtual int switchvar(void) {
		return 0;
		};
	virtual int saveall(void) {
		var=1;
		return 1;
		};
	};

class ok: public action {
	item **alles;
	int nr;
	public:
	ok(item **al,int len,int y,int x,int &var): action("  ~Ok  ",y,x,var) {
		alles=al;
		nr=len;
		}
	int saveall(void) ;
	};


int show(item **al,int maxar,int sel) ;
static int zomaareenvar;
#define el(check,str,y,x,var) (al[i++]= new check(str,y,x,var))
#define checker(str,y,x,var) (al[i++]= new check(str,y,x,var))
#define act(str,y,x) (al[i++]= new action(str,y,x,zomaareenvar))
#define acti(str,y,x,var) (al[i++]= new action(str,y,x,var))
#define oker(al,maxar,y,x) (al[i++]= new ok(al,maxar,y,x))
#define oke(y,x) (al[i++]= new ok(al,maxar,y,x,zomaareenvar))
#define okvar(y,x,var) (al[i++]= new ok(al,maxar,y,x,var))
#define liner(txt,name,x,y) (al[i++]= new lineitem(txt,name,x,y))
#define linerlen(txt,len,name,x,y) (al[i++]= new lineitem(txt,len,name,x,y))
#define linernr(txt,name,x,y,nr) (al[i++]= new lineitem(txt,name,x,y,nr))
#define orel(txt,y,x,val)  (al[i++]=new or(txt,y,x,val,com))
#define oreen(txt,y,x,val)  (al[i++]=new or(txt,y,x,val,com=new Common(var)))
#define ore(txt,y,x,val,com)  (al[i++]=new or(txt,y,x,val,com))
#define orsel(txt,y,x,val,com)  (al[i++]=com->setlast(new or(txt,y,x,val,com)))

/*
#define ors(var,items...,item) {Common *com=new Common(var);int was=i;  ##items;com->last=al[was+val]}
#define ors(var,items...) {Common *com=new Common(var);int was=i;  ##items;com->last=al[was+val]}
*/

#define config(items...) {item **al;int i=0; int maxar=sizeof((item* []){##items})/sizeof(item *);al=new (item *)[maxar];##items;show(al,maxar);for(i=0;i<maxar;i++) delete al[i];delete[] al;}

extern void	attrall(WINDOW *takescr,int attrs) ;
extern WINDOW *rightwin(int l,int c,int by,int bx) ;
#define lcconfig(l,c,items...) lcsconfig(l,c,0,##items)
#define lcsconfig(l,c,sel,items...) {item **al;int i=0; int maxar=sizeof((item* []){##items})/sizeof(item *); if((takescr=rightwin(l,c,(thelines-l)/2,(thecols-c)/2))) { al=new (item *)[maxar];##items;show(al,maxar,sel);for(i=0;i<maxar;i++) delete al[i];delete[] al; }}
#define plcsconfig(l,c,sel,post,items...) {item **al;int i=0; int maxar=sizeof((item* []){##items})/sizeof(item *); if((takescr=rightwin(l,c,(thelines-l)/2,(thecols-c)/2))) {al=new (item *)[maxar];##items;post;show(al,maxar,sel);for(i=0;i<maxar;i++) delete al[i];delete[] al;}}
#define alcsconfig(ant,l,c,sel,items...) {item **al;int i=0; int maxar=sizeof((item* []){##items})/sizeof(item *); if((takescr=rightwin(l,c,(thelines-l)/2,(thecols-c)/2))) {al=new (item *)[maxar];##items;ant=show(al,maxar,sel);for(i=0;i<maxar;i++) delete al[i];delete[] al;}}
#define palcsconfig(ant,l,c,sel,post,items...) {item **al;int i=0; int maxar=sizeof((item* []){##items})/sizeof(item *); if((takescr=rightwin(l,c,(thelines-l)/2,(thecols-c)/2))) { al=new (item *)[maxar];##items;post;ant=show(al,maxar,sel);for(i=0;i<maxar;i++) delete al[i];delete[] al;};}
#endif

