/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */


#include <stdio.h>
#include <string.h>

long getfree(void) {
	char gegs[80];
	FILE *fp;
	int memfree=-1,swapfree=-1,freem;
	if(!(fp=fopen("/proc/meminfo","r"))) {
		fprintf(stderr,"Can't open /proc/meminfo");
		return -1;
		}
	while(fgets(gegs,80,fp))  {
		if(!strncmp("MemFree:",gegs,8)) {
			sscanf(gegs+9,"%d",&memfree);
			if(swapfree>0)
				break;
			}
		if(!strncmp("SwapFree:",gegs,9)) {
			sscanf(gegs+10,"%d",&swapfree);
			if(memfree>0)
				break;
			}
		}
	fclose(fp);
	if(memfree==-1||swapfree==-1) {
		fprintf(stderr,"Error reading /proc/meminfo\n");
		return -1;
		}
	freem=(memfree+swapfree);
	return freem*1024;
	}
#ifdef TEST
void main(void) {
	int ret,i;
	for(i=0;i<1000;i++)
		ret=getfree();
	printf("Free: %d\n",ret);
	}
#endif
