/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */



class keylookup {
public:
struct mark  {
	unsigned char *keys;
	unsigned long pos;
	char *des;
	struct mark *next,*prev;
	};

struct tree {
	int nr;
	unsigned char ch;
	union  {
		struct tree *children;
		struct mark *mark;
		};
	struct tree *next;
	};

struct tree treebase,*keyhead;
struct mark *head,begin,*iter;
keyinput input;

keylookup() {keyhead=&treebase;memset(keyhead,0,sizeof(treebase));iter=head=&begin;};
int putkeys(unsigned char *keys,int nr,unsigned long pos) {
	head->next=new (struct mark);
	head->next->prev=head;

	head=head->next;
	head->pos=pos;
	head->keys=keys;
	return keymap(keys, nr, head) ;
	};
inline int isstart(void) {return input.isstart();};
struct mark *next(void) {
	if(iter!=head) {
		iter=iter->next;
		return iter;
		}
	return NULL;
	}
void tobegin(void) {iter=&begin;};
struct mark *prev(void) {
	struct mark *tmp;
	if(iter!=&begin) {
		tmp=iter;
		iter=iter->prev;
		return tmp;
		}
	return NULL;
	}
void defaultmark(int pos) {
	head->next=new (struct mark);
	head->next->prev=head;

	head=head->next;
	head->pos=pos;
	head->keys=NULL;
	}
int putkey(unsigned char key, unsigned long pos) {
	return putkeys(&key,1,pos);
	};

struct mark *keylookup::getinput(unsigned char *str,int len) {
	struct mark *mark;
 
	for(int i=0;(i<len)&&(!(mark=lookup(str[i])));i++)
		if(isstart())
			return NULL;
	return mark;
	};
inline struct mark *keylookup::lookup(unsigned char ch) {
	int res=input.keyseq(ch);
	if(res==-1)
		return NULL;
	return (struct mark*)res;
	}
inline int keymap(unsigned char *keys,int nr, struct mark *mark ) {
	return input.putseq((int)mark, nr, keys) ;
	}
/*
struct mark *keylookup::lookup(unsigned char input) {
		struct tree *iter;
		for(iter=keyhead->children;iter;iter=iter->next) 
			if(iter->ch==input) {
				if(iter->nr>0) {
					keyhead=iter;
					return 0;
					}
				keyhead=&treebase;
				return iter->mark;
				};
		keyhead=&treebase;
		return &begin;
	};

int keylookup::keymap(unsigned char *keys,int nr, struct mark *mark ) {
	struct tree *parent;
	struct tree *iter;
	for(parent=&treebase;nr>0;parent=iter,keys++,nr--) {

		for(iter=parent->children;iter&&(iter->ch!=*keys);iter=iter->next) 
			;

		if(iter) {
				if(nr==1) {
					if(iter->nr>0)
						return 1;
					iter->mark=mark;
					return 0;
					}
				}
		else { 
			{
				iter= parent->children;
				parent->children=new (struct tree);
				parent->children->next=iter;
				iter=parent->children;
				iter->ch=*keys;
				parent->nr++;
				iter->nr=0;

				iter->children=NULL;

				nr--;
				keys++;
				parent=iter;
				} while(nr>0);
			iter->mark=mark;
			return 0;
			}
		}
	return 0;
	};
*/
};



