/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */

#include <unistd.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/param.h>
#include "rbtree.h"
#include <regex.h>

#define BIGEST   LONG_MAX
const int BLOCKSIZE=1024;
//#define DEBUG(x...) fprintf(stderr,## x)
#define DEBUG(x...)
inline int min(int x,int y) {return ((x)>(y)?(y):(x));}
inline int max(int een,int twee) {return ((een>twee)?een:twee);}

class Memory {

	public:
	int file,errors,readonly;
	Treel *gettreel(long blockiter);
	struct stat statdata;

	unsigned long filesize;
	int lastforward;
	int searchpos;
      struct re_pattern_buffer *searchexpr;
      struct re_registers *searchregs;
	int tablebase[256];
	int *table;
	int searchlen;
	char *searchstr;

	char filename[MAXPATHLEN];
	Tree tree;
	int error(void) {return errors;}
	int size(void) {return filesize;}
	Memory(char *name);
	~Memory();

void openfile(void) ;
void init(char *name) ;
int reinit(char *name) ;
int reinit(void) ;
int empty(void) ;

	int savenode(Treel *node);
	int saveall(void);
	int saveto(int handle);
	int saveto(int handle,int beg,int len);
	int touched(void) ;
	long getblock(long blocknr,char *buf);
	long putblock(long blocknr,char *buf) ;
long Memory::getblockpiece(unsigned long beg,unsigned long len,char *get) ;
	long getpart(unsigned long begin, unsigned long len, char * buf);
long Memory::putblockpiece(unsigned long beg,unsigned long len,char *get) ;
	long putpart(unsigned long begin, unsigned long len, char * buf);
	inline long blocksize() { return BLOCKSIZE;};
void	setborder(unsigned long pos) ;
void extend(unsigned long newsize) ;
void truncate(unsigned long pos) ;
//f c r
inline	unsigned long search(unsigned long beg,char *str,int len) {
		switch(lastforward) {
								//forward, icase, norm
		case 3: return casesearch(beg,str,len);
		case 1: return icasesearch(beg,str,len);
		case 7:return regexsearch(beg,str,len);
		case 5: return icaseregexsearch(beg,str,len);



		case 2: return backsearch(beg,str,len);
		case 0: return backicasesearch(beg,str,len);
		case 6: return backregexsearch(beg,str,len);
		case 4: return backicaseregexsearch(beg,str,len);
		default: return 1;
		};
	}

	unsigned long Memory::nextsearch(void) ;

unsigned long Memory::icaseregexsearch(unsigned long beg,char *str,int len) ;
unsigned long Memory::backicaseregexsearch(unsigned long beg,char *str,int len) ;
unsigned long Memory::backregexsearch(unsigned long beg,char *str,int len) ;
unsigned long Memory::nextbackregexsearch(void) ;
unsigned long Memory::regexsearch(unsigned long beg,char *str,int len) ;
unsigned long Memory::nextforwardregexsearch(void) ;
unsigned long Memory::icasesearch(unsigned long beg,char *str,int len) ;
unsigned long Memory::nextforwardicasesearch(void) ;
unsigned long Memory::casesearch(unsigned long beg,char *str,int len) ;
unsigned long Memory::nextforwardsearch(void) ;
unsigned long Memory::backsearch(unsigned long beg,char *str,int len) ;
unsigned long Memory::nextbacksearch(void) ;
unsigned long Memory::backicasesearch(unsigned long beg,char *str,int len) ;
unsigned long Memory::nextbackicasesearch(void) ;


	int readat(char *ptr,long size,long offset);
	int writeat(char *ptr,long size,long offset);

	};



