/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */


#include <string.h>
#include <ctype.h>
#include <curses.h>
#include <stdlib.h>
struct {char lab[8];int num;} colo[] = { {"black",COLOR_BLACK}, {"red",COLOR_RED}, {"green",COLOR_GREEN}, {"yellow",COLOR_YELLOW}, {"blue",COLOR_BLUE}, {"magentA",COLOR_MAGENTA}, {"cyan",COLOR_CYAN}, {"white",COLOR_WHITE}};
int nrcolors=8;

struct attr {
	char lab[12];
	int num;
	char des[80];
	};
struct attr at[] = {
{"normal",A_NORMAL,"Normal display (no highlight)"},
{"standout",A_STANDOUT,"Best highlighting mode of the terminal."},
{"underline",A_UNDERLINE,"Underlining"},
{"reverse",A_REVERSE,"Reverse video"},
{"blink",A_BLINK,"Blinking"},
{"dim",A_DIM,"Half bright"},
{"bold",A_BOLD,"Extra bright or bold"},
{"protect",A_PROTECT,"Protected mode"},
{"invis",A_INVIS,"Invisible or blank mode"},
{"altcharset",A_ALTCHARSET,"Alternate character set"},
{"chartext",A_CHARTEXT,"Bit-mask to extract a character"}};
int nrattr=11;

struct {
	char text[20];
	int var;
	int colornr;
	} fieldcolor[]={

{"text",0,1},{"command",A_REVERSE,2},{"bar",A_REVERSE,3},
{"barkey",A_NORMAL,4},{"menu",A_REVERSE,5},{"menukey",A_NORMAL,6},
{"menusel",A_BOLD|A_UNDERLINE,7},
{"opentitle",A_BOLD,8}, {"openkey",A_BOLD,9},
{"opennormal",0,10},
{"openlist",A_REVERSE,11},{"openlistsel",A_NORMAL,12},
{"openlistact",A_NORMAL|A_BOLD,13},{"showback",A_BOLD,14},{"selection",A_REVERSE,15}, {"cursor",A_REVERSE,16}, {"selcursor",A_UNDERLINE|A_BOLD,17} };

int colortypes=17;
char *next(char *str) {
	char *end=strpbrk(str," 	\n#");
	if(!end||!*end)
		return NULL;
	if(*end=='#') {
		*end='\0';
		return NULL;
		}
	*end++='\0';
	while(isspace(*end))
		end++;
	if(!*end||*end=='#') {
		*end='\0';
		return NULL;
		}
	return end;
	}

int colornr(char *name) {
	int i;
	for(i=0;i<nrcolors;i++) {
		if(!strcmp(colo[i].lab,name))
			return colo[i].num;
		}
	return 0xff;
	}
int attrnr(char *attr){
	for(int i=0;i<nrattr;i++)
		if(!strcmp(at[i].lab,attr))
			return at[i].num;
	return 0x4fff;
	}
int getattr(char *str) {
	if(!str)
		return 0;
	char *at=next(str);
	int val=getattr(at);
	return val+attrnr(str);
	}
char mess[80];
int hasc;
int makeattr(char *str) {
	char *fore,*back;
	int fornr,bacnr,val,i;
	for(;isspace(*str);str++)
		;
	if(!*str||*str=='#') {
		return 1;
		}
	if(!(fore=next(str))) {
		sprintf(mess,"Error after %s\n",str);
		return -1;
		}
	for(i=0;i<colortypes;i++) {
	 	if(!strcmp(str,fieldcolor[i].text)) {
			back=next(fore);
			if(!back||(fornr=colornr(fore))==0xff) {
				fieldcolor[i].var=attrnr(fore)+getattr(back);
				return 0;
				}
			val=getattr(next(back));
			if((bacnr=colornr(back))==0xff) {
				sprintf(mess,"Error don't recognise %s\n",back);
				return -1;
				}
			if(hasc) {
				init_pair(fieldcolor[i].colornr,fornr,bacnr);
				fieldcolor[i].var=COLOR_PAIR(fieldcolor[i].colornr)+val;
				}
			else
				fieldcolor[i].var=val;
			return 0;
			}
		}
	sprintf(mess,"Don't recognise %s\n",str);
	return -1;
	}
int MAXLINE=400;

void strup(char *gegs) {
	char *ptr;
	for(ptr=gegs;*ptr;ptr++)
		*ptr=tolower(*ptr);
	}
int MAXKEYS=100;
int putproc(char *str,int nr,unsigned char keys[]) ;
extern int getfilesym[];
#define keylabel(label,edit,menu,open) label,
char *keysyms[]= { 
#include "keylist.h"
};
int keysnr=sizeof(keysyms)/sizeof(char *);
class Editor {
	public:
	static  int (Editor::**dynproc)(void);
	static  char **dynprocnames;
	static int dynprocnr;
	static int (Editor::*ineditproc[])(void);
	static int (Editor::*inmenuproc[])(void);
	static int keymap(unsigned char *keys,int nr, int (Editor::*proc)(void));
	};
#include "keyinput.h"
extern  keyinput input;
#include "getlabel.h"
int makekeys(char *str) {
	unsigned char keybase[MAXKEYS],*keys=keybase+1;
	int sym;
	keybase[0]=menukey;
	int i=0,j;
	do {
		char *key=next(str);
		keys[i++]=atoi(str);
		if(!key) {
			sprintf(mess,"Missing = after %s\n",str);
			return -1;
			}
		str=key;
		} while(*str!='=');
	str++;
	while(isspace(*str))
		str++;
	if(!*str||*str=='#') {
			sprintf(mess,"Missing function after = \n");
			return -1;
			}
	char *func=next(str);
	if(func) {
		sprintf(mess,"Characters after %s\n",str);
		return -1;
		}
	if(i==1&&keys[0]==27)
		keys[i++]=secondescape;
	if((j=getlabel(keysyms,keysnr,str))>=0) {
		int (Editor::*proc)(void);
		if((proc=Editor::ineditproc[j])) 
		       Editor::keymap(keys,i,proc);
		 if((proc=Editor::inmenuproc[j])) 
		       Editor::keymap(keybase,i+1,proc);
		 if((sym=getfilesym[j]))
			input.putseq(sym,i,keys);
		return 0;
		};


	switch(putproc(str,i,keys)) {
		case -1: sprintf(mess,"Unknown procedure %s \n",str); return -1;
		case 1:  {
			int j;
			char *ptr;
			strcpy(mess,"Defined Prefix of   " ); 
			for(j=0,ptr=mess+18;j<i;j++) {
				sprintf(ptr,"%d ",keys[i]);
				ptr=ptr+strlen(ptr);
				}
			return -1;
			};
		default: return 0;
		}
	}

int dynlink(char *name) ;

int readconfig(char *file) {
	int outofcontext=0;
	char gegsbuf[MAXLINE],*ptr,*gegs;
	FILE *fp=fopen(file,"r");

	if(!fp) {
		return -1;
		}
	hasc=has_colors();
	for(int l=0;fgets(gegsbuf,MAXLINE,fp);l++) {
		for(gegs=gegsbuf;isspace(*gegs);gegs++)
			;
		if(!*gegs||*gegs=='#')
			continue;
		ptr=next(gegs);
		strup(gegs);
		if(!strcmp(gegs,"context")) {
			if(!ptr) {
				fprintf(stderr,"%s, line %d: nothing after %s",file,l+1,gegs);
				continue;
				}
			char *is,*val=next(ptr);
			if(!(is=getenv(ptr))||(val&&(next(val),strcasecmp(val,is)))) {
					outofcontext=1;
					continue;
					}

			outofcontext=0;
			continue;
			}
		else
			if(outofcontext) {
				continue;
				}
		if(ptr)
			strup(ptr);
		if(!strcmp(gegs,"color")) {
			if(makeattr(ptr)<0) 
				fprintf(stderr,"%s, line %d: %s",file,l+1,mess);
			continue;
			}
		else {
			if(!strcmp(gegs,"keys")) {
				if(makekeys(ptr)<0)
					fprintf(stderr,"%s, line %d: %s",file,l+1,mess);
				}
			else {
				if(!strcmp(gegs,"plugin")) {
					next(ptr);
					if(dynlink(ptr)<0)
						fprintf(stderr,"%s, line %d: %s",file,l+1,mess);
					}
				else
					fprintf(stderr,"%s, line %d: don't recognise %s",file,l+1,gegs);
				}
			}

		}
	fclose(fp);
	return 0;
	}

#include "system.h"
int readconfig(void) {
	char configname[MAXPATHLEN];
	char *conf=getenv(CONFFILE);
	if(conf) {
		expandfilename(configname,conf);
		if(readconfig(configname)>0)
			return 0;
		fprintf(stderr,"Can't open %s", configname);
		return 1;
		}
	expandfilename(configname,"~/." CONFFILE);
	if(readconfig(configname)>=0)
		return 0;
	char general[MAXPATHLEN];
	expandfilename(general,CONFDIR "/" CONFFILE);
	if(readconfig(general)>=0)
		return 0;
	fprintf(stderr,"Can't open %s or %s\n",configname, general);
	return 1;
	}
#ifdef NODL
int dynlink(char *name) {
	sprintf(mess,"Can't use %s, compiled with NODL enebled\n",name);
	return -1;
	}
#else 
#include <dlfcn.h>
int dynlink(char *name) {
	const char *error;
	int nr;
	void *handle=dlopen(name,RTLD_GLOBAL|RTLD_LAZY);
	if(!handle) {
		 if ((error = dlerror()) != NULL)  
			sprintf(mess,"Can't open %s: %s\n",name,error);
		else
			sprintf(mess,"Can't open %s\n",name);
		return -1;
		}
	nr=*((int*) dlsym(handle,"_6Editor.dynprocnr"));
	 if ((error = dlerror()) != NULL)  {
		sprintf(mess,"%s: Editor::dynprocnr: %s\n",name,error);
		return -1;
		   }
	int newnr=Editor::dynprocnr+nr;
	int (Editor::**olddynproc)(void)=Editor::dynproc;
	char **olddynprocnames=Editor::dynprocnames;

	Editor::dynprocnames=new (char *)[newnr];
	Editor::dynproc=new (int (Editor::*)(void))[newnr];

	if(Editor::dynprocnr) {
		memmove(Editor::dynprocnames,olddynprocnames,Editor::dynprocnr*sizeof(char *));
		delete(olddynprocnames);
		memmove(Editor::dynproc,olddynproc,Editor::dynprocnr*sizeof(int (Editor::*)(void) ));
		delete(olddynproc);
		}
	olddynprocnames= (char **) dlsym(handle,"_6Editor.dynprocnames");
	 if ((error = dlerror()) != NULL)  {
		sprintf(mess,"%s: Editor::dynprocnames: %s\n",name,error);
		return -1;
		   }
	memmove(Editor::dynprocnames+Editor::dynprocnr,olddynprocnames,nr*sizeof(char *));

	olddynproc= (int (Editor::**)(void)) dlsym(handle,"_6Editor.dynproc");
	 if ((error = dlerror()) != NULL)  {
		sprintf(mess,"%s: Editor::dynproc: %s\n",name,error);
		return -1;
	   }
	memmove(Editor::dynproc+Editor::dynprocnr,olddynproc,nr*sizeof(int (Editor::*)(void)) );
	Editor::dynprocnr=newnr;
	return 0;
	}
#endif
#ifdef TEST
void main(int argc,char **argv) {
	initscr();
	           clearok(stdscr,FALSE);
	                           clearok(curscr,FALSE);
	                                    noecho();
	                                                    cbreak();
	                                                                    nonl();

	clear();
		hasc=has_colors();
		if(hasc)
			start_color();
		readconfig("/home/stolypin/.beditrc");
		refresh();
		for(int i=0;i<colortypes;i++) {
			attrset(fieldcolor[i].var);
			move(i+10,0);
			refresh();
			addstr(fieldcolor[i].text);
			refresh();
			}
		getch();
		}
	endwin();
	}
#endif
