
extern int starttrace(void) ;
extern int	traceproc(Editor* ed, int (Editor::*pr)(void)) ;
extern int endtrace(void) ;
FILE *tracefile;
int tracing=1;
#include <stdio.h>
#include <time.h>
#include <unistd.h>
       #include <pwd.h>
              #include <sys/types.h>


int starttrace(void) {
	time_t tim;
	char tracename[256];
	char *user;
	struct passwd *pas;
	if((pas=getpwuid(getuid())))
		user=pas->pw_name;
	else 
		user="";
	sprintf(tracename,"/tmp/bedtrace_%s",user);
	if(!tracing)
		return -1;
	tracefile=fopen(tracename, "a");
	setvbuf(tracefile,NULL,  _IONBF,0);
	time(&tim);
	fprintf(tracefile,"\nRestart %d at %s",pid,ctime(&tim));
	return 0;
	}

int	traceproc(Editor* ed, int (Editor::*pr)(void)) {
	int i;
	for(i=0;i<Editor::procnr;i++) {
		if(Editor::proc[i]==pr) {
			fprintf(tracefile,"%-55.55s: %s\n",ed->mem.filename,Editor::procnames[i]);
			fflush(tracefile);
			return 0;
			}
		}
	for(i=0;i<Editor::dynprocnr;i++) {
		if(Editor::dynproc[i]==pr) {
			fprintf(tracefile,"%-55.55s: %s\n",ed->mem.filename,Editor::dynprocnames[i]);
			fflush(tracefile);
			return 0;
			}
		}
	fprintf(tracefile,"%-55.55s: Unknown procedure (ERROR)\n",ed->mem.filename);
	fflush(tracefile);
	return -1;
	}


int endtrace(void) {
	return fclose(tracefile);
	}
