/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */

#include "memory.h"
#include <ctype.h>
#include "screen.h"
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/ioctl.h>
#include "getfile.h"
#include "keyinput.h"
#include "editlimits.cpp"
#include "readcolors.h"
#include "debug.h"
#include "system.h"
/*
#define editerase()  werase(editscreen); 
inline void normaal(WINDOW *editscreen) {
	wattrset(editscreen,0);
	wbkgdset(editscreen,' '|TEXTATTR);
	}
inline void selectieon(WINDOW *editscreen)	{
	wbkgdset(editscreen,0);	
	wattrset(editscreen,SELECTIE);
	}
#define SELECTIEON selectieon(editor->editscreen)
#define NORMAAL normaal(editscreen) 
#define	COMMANDON {wbkgdset(editscreen,0);wattrset(editscreen,COMMANDATTR);}
#define	COMMANDOFF NORMAAL

#define CURSORON		{wbkgdset(editor->editscreen,0);if(!editor->selected(editor->filepos+pos)) wattrset(editor->editscreen,CURSORATTR); else wattrset(editor->editscreen,SELCURSORATTR); }
#define CURSOROFF		{if(!editor->selected(editor->filepos+pos)) normaal(editor->editscreen); else SELECTIEON;}
*/

#define editerase()  werase(editscreen); 
#define NORMAAL normaal(editscreen) 
#define normaal(editscreen) wattrset(editscreen,TEXTATTR)
#define	COMMANDON wattrset(editscreen,COMMANDATTR);
#define	COMMANDOFF NORMAAL
#define SELECTIEON			wattrset(editor->editscreen,SELECTIE)
//#define CURSORON		 if(editor->selected(editor->filepos+pos)) wattrset(editor->editscreen,0)
#define CURSORON		{if(!editor->selected(editor->filepos+pos)) wattrset(editor->editscreen,CURSORATTR); else wattrset(editor->editscreen,SELCURSORATTR);}
#define CURSOROFF		{if(!editor->selected(editor->filepos+pos)) normaal(editor->editscreen); else SELECTIEON;}
//#define CURSOROFF
//#define CURSORALL		| ((editor->selected(editor->filepos+pos))?(SELCURSORATTR):(CURSORATTR))
#define CURSORALL		
inline hexel(unsigned char x)  {
	return (((x)<10)?((x)+'0'):(x+'A'-10));
	}
//#undef refresh()
//#define		refresh()
inline int maxof(int een,int twee) {return ((een>twee)?een:twee);}
int ggetch(WINDOW *w) ;
int resized(void);
void putmenus(void) ;
void resizemenus(void) ;
void resizehandler(int signum) ;
int thelines,thecols;
int OldMainScreenwidth=thecols;
int maxmenusize=0;
#define					rewritescreen redistribute
int pid;
#define LIVEWITHXITERM
#define MESSAGELINE Screenheight-nomessage
#define MAXANT 500
jmp_buf screenjmp;
jmp_buf resizejmp;
#ifdef CURSES
	#define editmove(y,x) wmove(editscreen,y,x)
int ls=0,rs=0,ts=0,bs=0,tl=0,tr=0,bl=0,br=0;
WINDOW *barwin;
#define keyscr stdscr
int dontdesturbe=0;
int waitinput=0;
int resizeflag=0;
int ismessage;
#define newscherm redistribute
int redistribute=1;
int menuon=1;
const int maxparts=10;

class Editor;
#ifdef TRACEON
extern int starttrace(void) ;
extern int	traceproc(Editor* ed, int (Editor::*pr)(void)) ;
extern int endtrace(void) ;
#else
#define starttrace() 
#define	traceproc(x,y)
#define endtrace() 
#endif

Editor *argfile(void) ;
Editor *newfile(const char *file ); 
Editor *editfile(const char *file) ;
int addlast(void) ;
int maxedit=10,nredit=0, editfocus=-1,startnonactive=0;
int	startactive=0;
Editor **edits;

void rewriteall(void) ;
Editor *getactive(void) {
	return edits[editfocus];
	}

void setactives(void) {
	if(editfocus>(nredit-1))
		editfocus=nredit-1;
	if(startactive>editfocus) 
		startactive=editfocus;
	if(startnonactive<(startactive+1))
		startnonactive=startactive+1;
	if(startnonactive>nredit)
		startnonactive=nredit;
	}

inline int hex2dig(char ch) {return ((ch>='0'&&ch<='9')?(ch-'0'):((ch<='f'&&ch>='a')?(ch-'a'+10):
		((ch<='F'&&ch>='A')?(ch-'A'+10):30))); }

#define num(x) hex2dig(x)
#undef getch
#define RESIZE 12

void scrsize(void) {
	struct winsize win;
   if (ioctl(0, TIOCGWINSZ, &win) == 0) {
        if (win.ws_row != 0) {
            thelines = win.ws_row;
        }
        if (win.ws_col != 0) {
            thecols = win.ws_col;
        }
	}
	if(thecols<0)
		thecols=80;
	if(thelines<0)
		thelines=24;
	if(thecols<32)
		thecols=32;
	if(thelines<3)
		thelines=3;

}
void initcolor(void) {
		if(has_colors()) {
			start_color();
			}
		readconfig();
	   	};
//void terminate(int err,void *nothing) ;
class nocurses_init {
	public:
	curses_init(void) { /*Initialize screen */
	//	on_exit(terminate,0);

		putenv("LINES=120");
		putenv("COLUMNS=240");
		initscr();
		clearok(stdscr,FALSE);
		clearok(curscr,FALSE);

		initcolor();
		setscreen();
		reset();
		OldMainScreenwidth=MainScreenwidth;
		};
	void restore(void) { /*restore screen from before start program */
		move(thelines-1,0);
		clrtoeol();
		touchline(stdscr,thelines-1,1);
		refresh();
		endwin();
		};
	void setscreen(void) { /*Set screen for program */
		noecho();
	   	cbreak();
	   	nonl();
	   	};
	void reset(void ) {
		scrsize();
		clear();
		refresh();
		wresize(stdscr,thelines,thecols);
		redistribute=1;
		}
	int resized(void) { /*Reset screen for program */
		int oldlines=thelines, oldcols=thecols;
		scrsize();
		if(oldlines!=thelines||oldcols!=thecols) {
			wresize(stdscr,thelines,thecols);
			clear();
			refresh();
			redistribute=1;
			return 1;
			}
		return 0;
		};
	};
 nocurses_init curses_init_curses;

const char *getfile(const char *prompt,const char *ask) {
	const char *file=ask;
			while(1) {
				if(!(file=takefile(prompt,ask))) {
					return NULL;
					}
				if(file!=ask)  {
					return file;
					}
				resized();
				rewriteall();
				}
			}
/*
void terminate(int err,void *nothing) {
	switch(err) {
		case 234:  return;
		case 0: return;
		default: longjmp(screenjmp,SIGTERM);
		};
}
*/
#else //CURSES
#ifdef CONIO
void    reset_screen(void) {
        gotoxy(1,MainScreenheight);
        clreol();
        }
struct text_info texi;


class init_screen {
	public:
	init_screen() {
	        gppconio_init();
	        gettextinfo(&texi);
		atexit(reset_screen);
        };


	};
//init_screen screen_init;

#endif //CONIO
#endif //CURSES
//typedef enum {HEX,ASCII,DEC } Type;
typedef enum {HEX=16,ASCII=256,DEC=10,BIN=2,OCT=8 } Type;

char *modename(Type type) {
	switch(type) {
		case BIN: return "Bin";
		case OCT: return "Oct";
		case HEX: return "Hex";
		case  DEC: return "Dec";
		case ASCII: return "Ascii";
		default: return "";
		}
	}
class Editor;
class ScreenPart {
	public:
	Editor *editor;
	int left,top,chsize, spaceafter;
	Type type;
	char searchquestion[20];
	ScreenPart(Editor *ed,int x1, int y1,Type t,int sp,int cs) 
		{ left=x1;top=y1;;editor=ed;
		type=t;
		spaceafter=sp;
		chsize=cs;
		sprintf(searchquestion,"%s: search: ",modename(type));
		};
	void printchar(int pos, int ch);
	inline void postoxy(int pos,int &x,int &y) {
			y=(pos/(nrx()));
			x=(pos%(nrx()))*chsize;
			};
	inline int x(int pos) { return ((pos%nrx())*chsize);};
	inline int y(int pos) { return (pos/nrx());};
	inline int &nrx(void);
	inline int &nry(void);
	inline int oldpos(void);
 
	inline void place(int l, int t) { left=l;top=t;};
	int putline(int y);

	virtual void chput(unsigned char ch) =0;
	int sput(char *buf, int size);
	void movepos(int pos);

	inline int cols(void) {return nrx();};
	inline int rows(void) {return nry();};
	int nocursor(void);
	virtual int select(void)=0;
	virtual int leave(void) {;};
	virtual 	int makeascii(unsigned char *ant)=0;
	virtual 	int fromascii(unsigned char *to,unsigned char *from,int len) =0;


	inline	int getsearch(char *ant);

	virtual void cursorpos(int pos)=0;
	virtual int backchar(void) {return 0;};
	virtual int nextchar(void) {return 0;};
	virtual inline int newchar(int)=0;
	void troggleselect(int pos);
	};

	 int  hexmakeascii(unsigned char *ant,unsigned char *out) {
		int een,twee,i;
		unsigned char *ptr=out,*start=out,*to=ant;
		for(i=0;ant[i];i++) {
			while(isspace(ant[i]))
				i++;
			if(!ant[i])
				break;
			*to++=ant[i];
			}
		*to='\0';
		int len=to-ant;
		if(len<1)
			return 0;
		if(len%2) 
			*ptr++=num(*ant++);
		while((een=num(*ant++),twee=num(*ant++),(een!=30&&twee!=30))) {
			*ptr++=een*16+twee;
			}
		*ptr='\0';
		return (ptr-start);
		}
inline	 int  hexmakeascii(unsigned char *ant) {
	 	return hexmakeascii(ant,ant);
		}

	 int hexfromascii(unsigned char *to,unsigned char *from,int len) {
	 	unsigned char *begin=to;
		int i;
		for(i=0;i<len;i++) {
			*to++=hexel((*from)/16);
			*to++=hexel((*from++)%16);
			}
		*to='\0';
		return to-begin;
		}
class Hex: public ScreenPart {
	public:
	int half;
	Hex( Editor *ed,int x1=0, int y1=0): ScreenPart(ed,x1,y1,HEX,1,3)	{
		half=2;
		}; 
	void chput(unsigned char ch);
	void chput(unsigned char ch,int pos);
	void cursorpos(int pos);
	int select(void);
	int leave(void) {half=2;};
	int newchar(int key);
	 int backchar(void) {
	 	half=!half;
	 	return half;
		};
	 int nextchar(void) {
		if(half) 
			{half=0;return 1;}
		else {
			half=1;
			return 0;
			}
		};

	inline int  makeascii(unsigned char *ant) {

	 	return hexmakeascii(ant);
		}
	inline int fromascii(unsigned char *to,unsigned char *from,int len) {
	 	return hexfromascii(to,from, len); 
		}

	};

class Digit: public ScreenPart {
	public:
	int half;
	int base,nrchar;
	Digit( Editor *ed,int b=10,int x1=0, int y1=0): ScreenPart(ed,x1,y1,(Type)b,1,(((int)ceil(log(256)/log(b)))+1))	{
		base=b;
		nrchar= ScreenPart::chsize-1;
		half=nrchar;
		}; 
	void chput(unsigned char ch);
	void cursorpos(int pos);
	int select(void);
	int leave(void) {half=nrchar;};
	int newchar(int key);
	 int backchar(void) {
	 	half=(++half)%nrchar;
	 	return half;
		};
	 int nextchar(void) {
	 	if(!half) {
	 		half=nrchar-1;
	 		return 0;
	 		}
		half--;
		return 1;
		};
	static inline int Digit::numel(char key) { return (key-'0');};
	inline char  Digit::numpart(unsigned char ch, int half) { return ((((ch)/((int)pow(base,half)))%base))+'0'; }
	 int Digit::makeascii(unsigned char *ant) ;
	int fromascii(unsigned char *to,unsigned char *from,int len) ;
	inline int Digit::isel(int key) { int el=numel(key); return (el>=0&&el<base); }

	};


class Ascii: public ScreenPart {
	public:
	char noprint;
	Ascii(Editor *ed,int x1=0, int y1=0): ScreenPart( ed, x1,  y1,ASCII,2,1)	
		{
		noprint='.';
		}; 
	void chput(unsigned char ch);
	inline int max(void) { return ((nrx())*(nry()));}
	void cursorpos(int pos);
	int select(void);
	inline int newchar(int key) { return	(((key>0x1f&&key<0x7f)||key==13)?key:-1) ;};
	 int makeascii(unsigned char *str) {return strlen((char*)str);}

	int fromascii(unsigned char *to,unsigned char *from,int len) {
		memmove(to,from,len);
		to[len]='\0';
		return len;
		}
	};

class Editor {

	public:
		WINDOW *editscreen;
		int fromtop,numberof;
// Declaraties
struct tree {
	int nr;
	unsigned char ch;
	union  {
		struct tree *children;
		int (Editor::*proc)(void);
		};
	struct tree *next;
	};
struct Menugeg {
	char *name;
	char *key;
	int (Editor::*proc)(void);
	};
//Static 
	static  int (Editor::*proc[])(void);
	static  char *procnames[];

	static  int (Editor::**dynproc)(void);
	static  char **dynprocnames;
	static int dynprocnr;

	static int procnr;
	static struct tree basetree;
	static struct tree *treebase;
	static unsigned char *keypat[500];
//DATA:
	Memory mem;
	ScreenPart *parts[maxparts];
	int nrparts;
	int mode;
//	enum {ASCII,HEX} mode;
	char *buffer;
	char *getbuf(void);
	int filepos,changed,modified;
	int edge;
	int size,editpos,oldpos,updated;
	int dofromfile,lastgotopos;
	int commandmode;
	int allheight,Screenheight,Screenwidth,edittop;
	int shouldreinit;
	int nrx,nry;
	int getcols(void) ;
	void distribute(void) ;


/* Byte number procedures */
	int maxnum, numbase;
	char numstr[10];
	inline int nrnumber(void) {if(maxnum)
					return maxnum+2;
				else
					return 0;
					};
	inline int startnum(void) {return 0;};
	int askbase(void) ;
	int putnumbase(int base);
	void number(void);
	void numline(int y);

	inline int top(void) {return 0;};
struct block {
	unsigned char *begin;
	int last,free,len;
	struct block *prev;
	};
struct block *now,*chunkbefore;
int chunklast;

struct block *initchunk(int len) {
	now=new	(struct block);
	now->len=len;
	now->begin= new (unsigned char)[now->len];
	now->prev=NULL;
	now->free=0;
	chunkbefore=NULL;
	return now;
	}
void delchunk(void) {
	while(now) {
		struct block *old;
		delete now->begin;
		old=now;
		now=now->prev;
		delete old;
		}
	}

void newchunk(int len) {
	struct block *old=now;
	now=new	(struct block);
	now->len=maxof(old->len,len)*2;
	now->begin= new (unsigned char)[now->len];
	now->prev=old;
	now->last=0;
	}
void resetchunk(void) {
		if(chunkbefore) {
			while(now!=chunkbefore) {
				struct block *old;
				delete now->begin;
				old=now;
				now=now->prev;
				delete old;
				}
			now->last=chunklast;
			chunkbefore=NULL;
			};
		}
unsigned char *expandchunk(unsigned char *ptr,int len) {
	if(ptr==(now->begin+now->last)) {
			if(len>(now->len-now->last)) {
				now->free=now->last;
				newchunk(len);
				memmove(now->begin,ptr,len);
				now->free=len;
				return now->begin;
				}
			else 
				now->free=now->last+len;
			  
			}
	else {
		if(len>(now->len-now->free)) {
			newchunk(len);
			now->free=len;
			}
		else  {
			now->last=now->free;
			now->free+=len;
			}
		}

	return (now->begin+now->last);
	}


struct undo {
	unsigned long pos;
	unsigned char *str;
	int len;
	};
struct  undo undobuf[MAXUNDO];
int lastundo,redos,beginundo,undohalf;




	void initundo(void) {
			initchunk(5000);
			memset(undobuf,0,sizeof(undobuf));
			redos=beginundo=0;
			lastundo=-1;
			}
	void delundo(void) {delchunk();}
	inline struct undo *getnextundo(void) {
			lastundo++;
			if(lastundo>=(beginundo+MAXUNDO)) 
				beginundo++;
			return &undobuf[lastundo%MAXUNDO];
			}
	void addundo(long pos,unsigned char ch) {
		struct undo *ptr=&undobuf[lastundo%MAXUNDO];
			if(ptr->len&&((ptr->pos+ptr->len-1)==pos)) {
				switch(parts[mode]->type) {
					case HEX: 
						if(((Hex*)parts[mode])->half==!undohalf)  {
							undohalf=((Hex*)parts[mode])->half;
							return;
							}
						break;
					case DEC:
					case BIN:
					case OCT: 
						if(((Digit*)parts[mode])->half==(undohalf-1) ){
							undohalf=((Digit*)parts[mode])->half;
							return;
							}
						break;
					case ASCII:break;
					}
				};
		if((ptr->pos+ptr->len)!=pos) {
			ptr=getnextundo();
			ptr->pos=pos;
			ptr->len=0;
			ptr->str=NULL;
			};
		redos=lastundo;
		resetchunk();
		ptr->str=(unsigned char *)expandchunk(ptr->str,ptr->len+1);
		ptr->str[ptr->len++]=ch;
		switch(parts[mode]->type) {
			HEX:
				undohalf=((Hex*)parts[mode])->half;
				break;
			case DEC:
			case BIN:
			case OCT: undohalf=((Digit*)parts[mode])->half;break;
			default: undohalf=0xffff;
			};
		}
	void strtoundo(long pos,int size) {
		struct undo *ptr=getnextundo();
		ptr->len=size;
		ptr->pos=pos;
		ptr->str=(unsigned char *)expandchunk(ptr->str,size);
		mem.getpart(pos,size,(char *)(ptr->str));
		redos=lastundo;
		};
	int  popundo(unsigned char **buf,unsigned long *pos) {
		int len;
		*buf=undobuf[lastundo%MAXUNDO].str;
		*pos=undobuf[lastundo%MAXUNDO].pos;
		len=undobuf[lastundo%MAXUNDO].len;

		undobuf[lastundo%MAXUNDO].str=NULL;
		lastundo--;
		return len;
		};
int resetnumbase(void) {
				int oldnum=maxnum;
				putnumbase(numbase);
				if(oldnum!=maxnum)
					shouldreinit=1;
			return shouldreinit;
			}
	int undo(void) {
		int ret;
		while((ret=undoone())==0)
			;
		if(ret<0)
			beep();
		return ret;
		}
	int undoone(void) {
		if(lastundo>=beginundo) {
			unsigned char *buf;
			int undosize;
			unsigned long pos;
			undosize=popundo(&buf,&pos);
			if(undosize!=0) {
	dontdesturbe++;
				memorize();
				chunkbefore=now;
				chunklast=now->last;
				if((pos+undosize)>mem.filesize) {
					if(pos!=mem.filesize) {
						struct undo *ptr=&undobuf[(lastundo+1)%MAXUNDO];
						ptr->len=0;
						ptr->pos=pos;
						ptr->str=NULL;
						return 0;
						}
					mem.extend(pos+ undosize);
					resetnumbase() ;
					{
					struct undo *ptr=&undobuf[(lastundo+1)%MAXUNDO];
					ptr->len=-1;
					ptr->pos=pos;
					};
					mem.putpart(pos,undosize,(char *)buf);
					}
				else {
					if(undosize<0)  {
						int thesize=mem.filesize-pos;
						struct undo *ptr=&undobuf[(lastundo+1)%MAXUNDO];
						ptr->len=thesize;
						ptr->pos=pos;
						ptr->str=(unsigned char *)expandchunk(ptr->str,thesize);
						mem.getpart(pos,thesize,(char *)(ptr->str));
						mem.truncate(pos);
						resetnumbase() ;
						pos--;
						}
					else { 
						{
						struct undo *ptr=&undobuf[(lastundo+1)%MAXUNDO];
						ptr->len=undosize;
						ptr->pos=pos;
						ptr->str=(unsigned char *)expandchunk(ptr->str,undosize);
						mem.getpart(pos,undosize,(char *)(ptr->str));
						};
						mem.putpart(pos,undosize,(char *)buf);
						}
					undosize=1;
					}
				topos(pos);
				modified++;
				if(!shouldreinit)
					fromfile();
				updated=0;
	dontdesturbe--;
				return undosize;
				}
			else 
				return 0;
			}
		else
			return -1;
		};


	int redo(void) {
		int ret;
		do {
			if(redos>lastundo) {
				struct block *chunkbefore2=chunkbefore;
				int chunklast2=chunklast;
				lastundo++;
				ret=undoone();
				lastundo++;
				chunkbefore=chunkbefore2;
				chunklast=chunklast2;
				}
			else {
				beep();
				return -1;
				}
			} while(ret==0);
		}
	struct tree *keyhead;


	void *lookup(unsigned char input);
//PROCEDURES
	int proceskey(void);

	 static int keymap(unsigned char *keys,int nr, int (Editor::*proc)(void));
	static int keymap(int (Editor::*proc)(void),int nr,...); 
	 static	void keyinit(void); 
	 static void defaultkeys(void) ;

	Editor(char *filename);
	~Editor() ;
	int zoommode(void) ;
	int removemode(void) ;

	int Editor::prevmode(void) ;
	int Editor::nextmode(void) ;
	int reinit(void);
	int place(int);
	int changechar(int pos,unsigned char ch);
	inline int Editor::printchar(int pos,unsigned char ch) { for(int i=0;i<nrparts;i++) parts[i]->printchar(pos,ch);};
	int changestr(int pos,unsigned char *str,int size);
	void doexit(void);
	void nocursor(void);
	int fromfile(int pos) { dofromfile=0;return((size=mem.getpart(pos, max(), buffer))); };
/*	int fromfile(int pos) { 
		static int oldpos=0;
		static char *buf=NULL;
		if(buf==buffer) {
			int dif=oldpos-pos;
			
			if((-dif)<max()) {
				dif=-dif;
				memmove(buffer,buffer+dif,max()-dif);
				return(size=mem.getpart(pos+dif,dif,buffer)+max()-dif);
				}
			if(dif<max()) {

			memmove(buffer+dif,buffer,max()-dif);
			return(size=mem.getpart(pos,dif,buffer)+max()-dif);
			}
			}
		buf=buffer;
		oldpos=pos;
		return((size=mem.getpart(pos, max(), buffer)));
		}
		*/
	int fromfile(void) { return(fromfile(filepos)); };
	int geteditpos(void);
	int getfilepos(void);

/* Geometry */

	inline void Editor::splitpos(long pos) { 
		editpos=(pos%mem.blocksize())%max();
		filepos=pos-editpos;
		};
	inline int cols(void) { return nrx;};
	inline int rows(void) { return nry;};

	inline int x(void) { return (editpos%nrx);};
	inline int y(void) { return (editpos/nrx);};
	int writebuf(void);
	void cursorpos(void) ;
	inline void resetpos(void);
	int topos(long pos) ;
int Editor::setpos(long pos) ;
	void putline(int y) ;
	int nomessage;
	inline void textovermessage(void) {editmove(MESSAGELINE,0);clearline();putline(MESSAGELINE);cursorpos();ismessage=0;}
	inline void restoremessageline(void)	{if(nomessage&&ismessage) textovermessage();};
	inline void clearmessage(void) { if(nomessage) textovermessage();else fileinfo(); }
	int getinput(const char question[],char *answer) ;
	int inputget(char *answer,const char *format,...) ;

#define NEXTFILE 888
#define PREVFILE 889
#define ASKFILE  890
#define LASTFILE 891
#define FIRSTFILE 891
#define FILENR	892
#define MAXFILES 60
	int selectprocedure(void); 
	int selectdynprocedure(void) ;
	int listfiles(void) {
		int i;
		char *files[nredit];
		int fil;

		for(i=0;i<nredit;i++) {
			files[i]=new char[MAXFILES];
			sprintf(files[i],"%-53.53s  %c",edits[i]->mem.filename,((edits[i]->modified||edits[i]->changed)?'*':' '));
			}
		while((fil=selectitemindex("Select open buffer",files,nredit,editfocus))!=LONG_MAX) {
			if(fil==(LONG_MAX-1)) {
				menuresized();
				wrefresh(editscreen);
				}
			else {

				editfocus=fil;
				if(editfocus<startactive||editfocus>=startnonactive) {
						redistribute=1;
						addlast();
						}
				else {
					editup();
					nocursor();
					wrefresh(editscreen);
					edits[editfocus]->cursorpos();
					}

				for(i=0;i<nredit;i++)
					delete(files[i]);
				return 0;
				 }
			}
		editup();
		for(i=0;i<nredit;i++)
			delete(files[i]);
		return -1;
		};
	int nextfile(void) {
		if((editfocus>=(nredit-1))) {
				if(!argfile())  {
					beep();
					return -1;
					}
				}
		else {
			editfocus++;
			if(editfocus>=startnonactive) {
				redistribute=1;
				}
			else {
				nocursor();
				wrefresh(editscreen);
				edits[editfocus]->cursorpos();
				}
			}

		return NEXTFILE;
		};
	int prevfile(void) {
		if(editfocus) {
			editfocus--;
			if(editfocus<startactive) {
				redistribute=1;
				}
			else {
				nocursor();
				wrefresh(editscreen);
				edits[editfocus]->cursorpos();
				}
			}
		else {
			beep();
			};
		return PREVFILE;
		};

	int emptyfile(void) {
		if(!newfile("/dev/zero")) {
			message("Configuration error: Can't open /dev/zero");
			return -1;
			}
		if(addlast()>-1)
			redistribute=1;
		}
	int askmenufile(void) {
		char buf[MAXPATHLEN]="*";
		const char *file;
			while(1) {
				if((file=getfile("Open file",buf))) {
					if(!newfile(file)){
						message("Can not edit %s",file);
						wrefresh(editscreen);
						strcpy(buf,file);
						continue;
						}
					else
						return 0;
					}
				else {
					editup();
					return -1;
					}
				}
			}
	int askfile(void) {
		char ant[MAXANT];
		getinput("Name of file to visit: ",ant);
		if(!newfile(ant)) {
			const char *file;
			if((file=getfile("Open file",ant))) {
				if(!newfile(file)){
						rewritescreen=1;
						message("Error opening %s",file);
						return -1;
						}
					}
			else {
					editup();
				return -1;
				}
			return 0;
			}
		return ASKFILE;
		};
	inline int switchcursor(void) {
			nocursor();
			wrefresh(editscreen);
			edits[editfocus]->cursorpos();
			}
	int lastfile(void) {
		if(editfocus==(nredit-1)) {
			beep();
			return -1;
			}
		editfocus=nredit-1;
		if(editfocus>=startnonactive)
			redistribute=1;
		else {
			switchcursor();
			}
		return LASTFILE;
		};
	int firstfile(void) {
		if(!editfocus) {
			beep();
			return -1;
			}
		editfocus=0;
		if(editfocus<startactive)
			redistribute=1;
		else
			switchcursor();
		return FIRSTFILE;
		};


	int backchar(void);
	int nextchar(void);
	int nextfast(void) ;
	int scrollup(void);
	int edscholldown(void);
	int lineup(void);
	int linedown(void);
	int pagedown(void) ;
	int pageup(void) ;
	int endline(void);
	int beginline(void); 
	int gettopos(void);
	int endfile(void); 
	int beginfile(void); 
	int endpage(void); 
	int beginpage(void);
	int middlepage(void) ;
	int save(void);
	int dosave(void);
	int saveas(void) ;
	int Editor::saveas(const char *ant) ;

	int extendfile(int len) ;
	int extend(void) ;

	int putbuf(char *buf,int len);


int Editor::toscreen(void) ;
int Editor::posputbuf(long pos,char *buf,int len);

int Editor::getmem(long pos,char *buf,int len);
int Editor::putmem(long pos,char *buf,int len);
	int truncate(void) ;
	int openfile(const char *ant) ;
	int nextsearch(void);
	int search(void);

	int dosearch(char *ant,int len);
	char replacestr[MAXANT];
	int replacestrlen;
	int replacehere(long pos, char *str,int len  ) ;
	int replace(void); 
	int quit(void);
	int endedit(void);
	int closethis(void);
	int closefile(void);
	int fileinfo(void) ;

	int addbefore(Type type,int to);
	inline int addafter(Type type,int to) { return addbefore(type,to+1); }
	int tomode(Type type) {
				for(int i=0;i<nrparts;i++) 
					if(parts[i]->type==type) {
						parts[mode]->leave();
						parts[mode=i]->select();
						 if(!nomessage) 
							fileinfo();
						return 0;
						}
				return -1;
				};
	int tosubscreen(void) {
		char ch=getch()-'0';
		if(ch>=0&&ch<nrparts) {
			parts[mode]->leave();
			return parts[mode=ch]->select();
			}
		beep();
		return -1;
		};
	int Editor::getmode(Type type);
	int asktomodeget(void) {
		 output("What mode do you want ((h)ex/(o)ct/(d)ecimal/(a)scii/(b)it/(c)ancel) ?");
		 return tomodeget();
		 }
	int tomodeget(void) {
		Type type;
		char ch;
		switch((ch=getch())) {
			case 'h': type=HEX;break;
			case 'd': type=DEC;break;
			case 'o': type=OCT;break;
			case 'b': type=BIN;break;
			case 'a': type=ASCII;break;
			case 27:;
			case 'c': clearmessage();beep();return -1;
			default: beep();return asktomodeget();
			};
		clearmessage();
		return getmode(type);
		}
		/*
inline	void	lotattrs(WINDOW *w) {
	wattrset(w,TEXTATTR);
	wattrset(w,TEXTATTR);
	wattrset(w,TEXTATTR);
	wattrset(w,TEXTATTR);
	}
	*/
inline void editup(void) {
	for(int i=startactive;i<startnonactive;i++) {
		touchwin(edits[i]->editscreen);
		wrefresh(edits[i]->editscreen);
		}
	}

void Editor::filesup(void);
	int selectmode(void) {
		int ascii=0,hex=0,dec=0,bin=0,oct=0,i,res,later=0;
		int wlin=9, wcol=30;
		for(i=0;i<nrparts;i++) {
			switch(parts[i]->type) {
				case ASCII: ascii=1;break;
				case HEX: hex=1;break;
				case DEC: dec=1;break;
				case BIN: bin=1;break;
				case OCT: oct=1;break;
				};
			}
		terug:
		alcsconfig(res,wlin,wcol,6,
			checker("~Ascii",2,3,ascii),
			checker( "~Hex",3,3,hex), 
			checker( "~Decimal",4,3,dec), 
			checker( "~Binary",5,3,bin), 
			checker( "Octa~l",6,3,oct), 
			oke(3,20),
			act("~Cancel", 5,20)); 
		if(later||res) {
			if(res==LONG_MAX)  {
				menuresized();
				wrefresh(editscreen);
				goto terug;
				}
			for(i=0;i<nrparts;i++) 
				delete parts[i];
			nrparts=0;
			if(oct)
				parts[nrparts++]=new Digit(this,OCT);
			if(bin)
				parts[nrparts++]=new Digit(this,BIN);
			if(dec)
				parts[nrparts++]=new Digit(this,DEC);
			if(hex)
				parts[nrparts++]=new Hex(this);
			if(ascii)
				parts[nrparts++]=new Ascii(this);
			if(!nrparts) {
				beep();
				output("Should select at least one mode");
				wrefresh(editscreen);
				later=1;
				goto terug;
				}
			mode=0;
			editup();
			shouldreinit=1;
			}
		editup();
		}

	long digfrom(char *ant);
	inline int max(void) { return ((nrx)*(nry));}

	int screensize(void);
	inline void memorize(void) {if(changed) {
				dontdesturbe++;
				mem.putpart(filepos,size,buffer);
				dontdesturbe--;
				changed=0;
				modified++;
				}; };
	struct tree *exampletree(void);



//	long selects[2];

	static	int	lensel;
	static char *selbuf;
	long other;
	int el;
	int setselect(void) ;
	int copyselect(void);
	int pastselect(void);
	int saveselect(void);
	int selected(int pos) {
		long posf=filepos+editpos;
		if((other>=0)&&((pos>=posf&&pos<=other)||(pos>=other&&pos<=posf)))
			//if(pos>=selects[0]&&pos<selects[1]) 
				return 1; 
		else return 0;
		};
#include "marks.cpp"
keylookup marx;
int defaultmark(void) {
	marx.defaultmark(editpos+filepos);
	return 0;
	};
int keymark(void) {
	int i,key;
	unsigned char keys[100];
	output("Mark: Type key");
	wrefresh(editscreen);
	keys[0]=wgetch(stdscr);
	halfdelay(1); 
	wrefresh(stdscr);
	for(i=1;(key=wgetch(stdscr))!=ERR;i++)
	 	keys[i]=(unsigned char)key;
	if(i==1&&*keys==27)
		keys[i++]=secondescape;
	flushinp();
	nocbreak();
	cbreak();
	refresh();
	output("Mark made");
	return marx.putkeys(keys,i,filepos+editpos);
	};
int tomark(void) {
	struct keylookup::mark *mark;
	output("Goto mark: type key");
	wrefresh(editscreen);
	while(!(mark=marx.lookup(ggetch(stdscr)))) 
		if(marx.isstart()) {
			flushinp();
			beep();
			output("Goto mark: Unknown key");
			return -1;
			};
	flushinp();
	refresh();
	output("Goto mark: Moved");
	return topos(mark->pos);
	};
int nextmark(void) {
	struct keylookup::mark *mark;
	do {
		mark=marx.next();
		if(!mark)  {
			beep();
			return -1;
			};
		} while((editpos+filepos)==mark->pos);
	return topos(mark->pos);
	};

int prevmark(void) {
	struct keylookup::mark *mark;
	do {
		mark=marx.prev();
		if(!mark)  {
			beep();
			return -1;
			};
		} while((editpos+filepos)==mark->pos);
	return topos(mark->pos);
	};
#define START 10
int showmarks(void) {
	static int size=START;
	static char **names=(char **)malloc(START*sizeof(char*));
	struct keylookup::mark *mark,*first;
	int tmp,i,take=0,ant;
	first=marx.next();
	marx.tobegin();
	for(i=0;(mark=marx.next());i++) {
		if(first==mark)
			take=i;
		if(i>=size) {
			size*=2;
			names=(char **)realloc(names,size*sizeof(char*));
			}
		names[i]=(char *)malloc(MAXFILES);
		tmp=mark->pos;
		mem.getpart(tmp,45,names[i]);
		for(int j=0;j<45;j++)
			if(!isprint(names[i][j]))
				names[i][j]='.';
		sprintf(names[i]+45,"  %d",tmp);
		}
	while((ant=selectitemindex("Select mark",names,i,take))!=LONG_MAX) {
			if(ant==(LONG_MAX-1)) {
				menuresized();
				wrefresh(editscreen);
				}
			else {
				editup();
				topos(atol(names[ant]+45));
				marx.tobegin();
				for(i=0;(mark=marx.next());i++) 
					free(names[i]);
				return 0;

				 }
		}
	editup();
	for(i=0;(mark=marx.next());i++) 
		free(names[i]);
	return -1;
	}

inline int pgetch(void) {
	int ch;
	waitinput=1;
	if((setjmp(resizejmp))) {

		waitinput=0;
		return RESIZE;
		};
	ch=wgetch(editscreen);
	waitinput=0;
	return ch;
	};
	
inline int getch(void) {
	int ch;
	waitinput=1;
	if((setjmp(resizejmp))) {

		waitinput=0;
		return RESIZE;
		};
	leaveok(editscreen,0);
	wrefresh(editscreen);
	ch=wgetch(editscreen);
	leaveok(editscreen,1);
	waitinput=0;
	return ch;
	};

#define scrollon(x,y) scrollok(x,y)
inline void overline() {for(int i=0;i<Screenwidth;i++) waddch(editscreen,' ');}
/*
inline int output(const char info[]) { }
*/
inline int output(const char info[]) {
	editmove(MESSAGELINE,0);
	COMMANDON;
	overline() ;
	editmove(MESSAGELINE,0);
	waddnstr(editscreen,info,Screenwidth);
	COMMANDOFF;
	ismessage=1;
	}
int message(char *format ...) {
	va_list ap;
	char str[255];
	va_start(ap,format);
	vsprintf( str, format,  ap);
	va_end(ap);
	return output(str);
	}

int getkeyinput(char *format ...) {
	int key;
	va_list ap;
	char str[255];
	va_start(ap,format);
	vsprintf( str, format,  ap);
	va_end(ap);
	again:
	output(str);
	key= getch();
	if(key==RESIZE) {
		resized();
		rewriteall();
		goto again;
		}
	return key;
	}

int outbox(char **output,int x,int y) {
	int i,yis=y+2,xis=maxof(26,x)+2;
	WINDOW *win=newwin(yis,xis,(thelines-yis)/2,(thecols-xis)/2);
	box(win,0,0);
	for(i=0;i<y;i++) {
		wmove(win,i+1,1);
		waddstr(win,output[i]);
		}
	wmove(win,i+1,1);
	wrefresh(win);
	return wgetch(win);
	}

int switchmenu(void) {
	menuon=!menuon;
	putmenus();
	redistribute=1;
	}
int switchmessage(void) {
	nomessage=!nomessage;
	shouldreinit=1;
	}
// Split window operaties 
int zoomwindow(void) {
	for(int i=startactive;i<startnonactive;i++)
		edits[i]->windel();
	editfocus=startactive=startactive+fromtop;
	startnonactive=startactive+1;
	redistribute=1;
	return 0;
	};
int hidewindow(void) {
	Editor *ed;
	if(nredit<2) {
		if(!argfile())
			return(askfile());
		else {
			return 0;
			}

		}
	if(startnonactive<(startactive+2)||editfocus>=startnonactive||editfocus<startactive) {
		if(editfocus>0)
			editfocus--;
		else
			editfocus++;
		newscherm=1;
		return 0;
		}
	ed=edits[editfocus];
	startnonactive--;
	for(int i=editfocus;i<startnonactive;i++)
		edits[i]=edits[i+1];
	edits[startnonactive]=ed;
	if(editfocus>startactive)
		editfocus--;
	else
		editfocus++;
	redistribute=1;
	return 0;
	}
int addnext(void) {
	if(nredit>startnonactive) {
		editfocus=startnonactive++;
		redistribute=1;
		return 0;
		}
	if(!argfile())  {
				beep();
				return -1;
				}
	startnonactive++;
	redistribute=1;
	return 0;
	}

int gotonrwin(int nr) {
	if(nr<0||nr>=nredit) {
		beep();
		return -1;
		}
	editfocus=nr;
	if(editfocus<startactive||editfocus>=startnonactive) {
			startactive=editfocus;
			startnonactive=editfocus+1;
			redistribute=1;
			return 0;
			}
	nocursor();
	wrefresh(editscreen);
	edits[editfocus]->cursorpos();
	return 0;
	}
#define gotowin(nr) int goto##nr(void) {return gotonrwin(nr-1);} 
gotowin(1)
gotowin(2)
gotowin(3)
gotowin(4)
gotowin(5)
gotowin(6)
gotowin(7)
gotowin(8)
gotowin(9)

int addprev(void) {
	if(startactive>0) {
		startactive--;
		editfocus=startactive;
		redistribute=1;
		return 0;
		}
	beep();
	return -1;
	}
int addfile(void) {
	if((askmenufile())==-1)
		return -1;
	if(addlast()>-1)
		redistribute=1;
	}
void windel(void) {
	delwin(editscreen);
	editscreen=NULL;
	}


#define STOP {wrefresh(m->win);getch();}
struct menuel {
	int key;
	int (Editor::*proc)(void);
	};
struct menu {
	WINDOW *win;
	int len,nu;
	struct menuel *el;
	};
/*
		if(edits[i]->edittop>(maxmenusize+3)) {
			wrefresh(edits[i]->editscreen);
			}
		else

void editontop(void) {
	for(int i=startactive;i<startnonactive;i++) {
		overwrite(edits[i]->editscreen,stdscr);
		edits[i]->clearmessage();
		}
	wrefresh(stdscr);
	}
*/
void editontop(void) {
	for(int i=startactive;i<startnonactive;i++) {
		if(edits[i]->edittop>(maxmenusize+3))
			break;
		touchwin(edits[i]->editscreen);
		wrefresh(edits[i]->editscreen);
		}
	}
int showmenu(void) {
	if(!editscreen)
		return -1;
	static int keys[20];
	void *procedure;
	char ch;
	int i,key;
	startover:
	struct menu *m=menulist[menunu];

	touchwin(m->win);
	wrefresh(m->win);
	goon:
	key=ggetch(m->win);
	wrefresh(m->win);

	ch=tolower(key);
	if(key==13) {
			editontop();
			traceproc(this,m->el[m->nu].proc);
			return (m->el[m->nu].proc)();
			}
	for(i=0;i<m->len;i++)
		if(ch==m->el[i].key) {
			editontop();
			traceproc(this,m->el[i].proc);
			return (m->el[i].proc)();
			}


	lookup(menukey);
	keys[0]=key;	
	for(i=0;!(procedure=lookup(keys[i++]));) {
		if(keyhead==treebase) {
			if(isalnum(key)) {
				flushinp();
				goto goon;
				}
			for(int j=0;j<i;j++) {
				if((procedure=lookup(keys[j])))
					goto away;
				if(keyhead==treebase) {
					flushinp();
					goto goon;
					}
				}
			while(!(procedure=lookup(ggetch(m->win)))) {
				if(keyhead==treebase) {
					flushinp();
					goto goon;
					}
				}
			goto away;
			}
		keys[i]=ggetch(m->win);
		}
	int ret;		
	traceproc(this,((struct tree *)procedure)->proc);
	switch((ret=(((struct tree *)procedure)->proc)())) {
		case -3: 
			wrefresh(m->win);
			goto goon;
		
		case -4:
			editontop();
			goto startover;
		default:
			editontop();
			return ret;
		};
	away:
	editontop();
	traceproc(this,((struct tree *)procedure)->proc);
	return	(((struct tree *)procedure)->proc)();	
	}



void selectmenu(struct menu *m,int dir) {
	char *buf;
	int maxx=getmaxx(m->win)-2;
	wattrset(m->win,MENUATTR);
	wmove(m->win,m->nu+1,1);
	int old=m->nu;
	m->nu+=dir;
	if(dir>0)
		while(!(m->el[m->nu].key))
			m->nu++;
	else
		while(!(m->el[m->nu].key))
			m->nu--;
	if(m->nu>=0&&m->nu<m->len) {
		for(int i=0;i<maxx;i++) {
			chtype ch=winch(m->win);
			if((ch&A_ATTRIBUTES)!=MENUKEYATTR)
				waddch(m->win,(ch&A_CHARTEXT));
			else {
				wattrset(m->win,MENUKEYATTR);
				waddch(m->win,(ch&A_CHARTEXT));
				wattrset(m->win,MENUATTR);
				}

			}
		wmove(m->win,m->nu+1,1);
		wattrset(m->win,MENUSELATTR);
		for(int i=0;i<maxx;i++) {
			chtype ch=winch(m->win);
			if((ch&A_ATTRIBUTES)!=MENUKEYATTR)
				waddch(m->win,(ch&A_CHARTEXT));
			else {
				wattrset(m->win,MENUKEYATTR);
				waddch(m->win,(ch&A_CHARTEXT));
				wattrset(m->win,MENUSELATTR);
				}
			}
		}
	else
		m->nu-old;
	}

struct menu *menumk(int x,int el,struct Menugeg pro[]) {
	struct menu *m;
	int i;
	int klen;
	int maxname=0;
	m= (struct menu *)malloc(sizeof(struct menu));
	m->len=el;
	m->nu=0;
	m->el=(struct menuel*)malloc(sizeof(struct menuel)*el);
	for(i=0;i<el;i++) {
		char *str=pro[i].name;
		if(str) {
			char *k=pro[i].key;
			m->el[i].key=klen=strlen(k);
			if(klen)
				klen+=2;
			maxname=maxof(maxname,strlen(str)+klen);
			m->el[i].proc=pro[i].proc;
			}
		else
			m->el[i].key=0;
		}
	maxname--;	
	m->win=newwin(el+2,maxname+2,1,x);
	leaveok(m->win,1);
	/*
	wattrset(m->win,MENUATTR);
	wbkgdset(m->win,' '|MENUATTR);
	werase(m->win);
	wbkgdset(m->win,0);
*/
	attrall(m->win,MENUATTR);
//	wattrset(m->win,MENUATTR);
	for(i=0;i<el;i++) {
		int in;
		char *iter,*str=pro[i].name;
		if(str) {
			iter=index(str,'~');
			klen=m->el[i].key;
			m->el[i].key=tolower(*(iter+1));
			wmove(m->win,i+1,1);
			waddnstr(m->win,str,(iter-str));
			wattrset(m->win,MENUKEYATTR);
			waddch(m->win,*(iter+1));
			wattrset(m->win,MENUATTR);
			waddstr(m->win,	iter+2);
			wmove(m->win,i+1,maxname-klen+1);
			waddstr(m->win,	pro[i].key);
			}
		else {
			wmove(m->win,i+1,1);
			whline(m->win,0,maxname);
			}

		}
	wborder(m->win,ls,rs,ts,bs,tl,tr,bl,br);
	selectmenu(m,0);
	maxmenusize=maxof(el,maxmenusize);
	return m;
	}
/*
struct menu *mkmenu(int x,int el,...) {
	struct menu *m;
	int i;
	int maxname=0;
	va_list ap;
	m= (struct menu *)malloc(sizeof(struct menu));
	m->len=el;
	m->nu=0;
	m->el=(struct menuel*)malloc(sizeof(struct menuel)*el);
	va_start(ap,el);
	for(i=0;i<el;i++) {
		char *str=va_arg(ap,char *);
		maxname=maxof(maxname,strlen(str));
		m->el[i].proc=va_arg(ap,int (Editor::*)(void));
		}

	va_end(ap);
	maxname--;	
	m->win=newwin(el+2,maxname+2,1,x);
	leaveok(m->win,1);
	wattrset(m->win,MENUATTR);
	wbkgdset(m->win,' '|MENUATTR);
	werase(m->win);

	va_start(ap,el);
	for(i=0;i<el;i++) {
		int in;
		char *iter,*str=va_arg(ap,char *);
		iter=index(str,'~');
		m->el[i].key=tolower(*(iter+1));
		wmove(m->win,i+1,1);
		waddnstr(m->win,str,(iter-str));
		wattrset(m->win,MENUKEYATTR);
		waddch(m->win,*(iter+1));
		wattrset(m->win,MENUATTR);
		waddstr(m->win,	iter+2);
		va_arg(ap,int (Editor::*)(void));
		}
	va_end(ap);
	wborder(m->win,ls,rs,ts,bs,tl,tr,bl,br);
	selectmenu(m,0);
	return m;
	}
*/

//#define keydef(proc, keys...)  keymap((unsigned char []){## keys},sizeof((unsigned char []){## keys}),proc)
static struct menu *menulist[20];
static int menuiter,menunu;
/*
#define menumake(name,under,items...) \
	int name ## show(void) {\
	static int nu=(((menulist[++menuiter]=mkmenu(startbar,sizeof((char []){##items})/2,##items)),keymap(name ## show,2,27,addtobar(under))),menuiter);\
	menunu=nu;\
	return showmenu();\
	}
	*/
#define menumake(name,under,items...) \
	int name ## show(void) {\
	static int nu=(((menulist[++menuiter]=menumk(startbar,sizeof((struct Menugeg []){##items})/sizeof(struct Menugeg),((struct Menugeg []){##items}))),keymap(name ## show,2,27,addtobar(under))),menuiter);\
	menunu=nu;\
	return showmenu();\
	}
int addtobar(char *name) {
	int len=strlen(name);
	char *key=index(name,'~');

	wmove(barwin,0,startbar);
	waddnstr(barwin,name,(key-name));
	wattrset(barwin,BARSTANDATTR);
	waddch(barwin,*(key+1));
	wattrset(barwin,BARATTR);
	waddstr(barwin,	name+2);

	startbar+=(len+1);
	return tolower(*(key+1));
	}
int startbar;
#define elm(name,proc) (struct Menugeg){name,"",proc}
#define elk(name,key,proc) (struct Menugeg){name,key,proc}
#define LINE elm(NULL,nop)
menumake(file,"~File",
	elm("~New",emptyfile),
	elk("~Open","C-o",addfile),
	LINE,
	elk("~Save","F2",dosave),
	elm("Save ~as",saveas),
	LINE,
	elk("~Refresh","C-l",rewrite),
	LINE,
	elm("~Procedures", selectprocedure),
	elm("~Dynamic", selectdynprocedure),
	elm("~Key binding", showprocedure),
	LINE,
	elk("~Close","M-c",closethis),
	elk("E~xit","M-x",quit));


menumake(edit,"~Edit", 
	elk("~Undo","C-u",undo), 
	elk("~Redo","C-r",redo),
	LINE ,
	elk("~Select","F12",setselect), 
	elk("~Copy","C-y",copyselect), 
	elk("~Past","M-p",pastselect), 
	elm("S~ave selection",saveselect),
	LINE,
	elk("R~eplace","M-r",replace),
	LINE,
	elm("E~xtend file" ,extend),
	elm("~Truncate" ,truncate), 
	elk("Repeat ~nr","M-.",repeat));
menumake(move,"~Move", 
	elk("~Search","M-s",search),
	elk( "~Nextsearch","F3",nextsearch), 
	LINE,
	elk("~Position","C-p",gettopos), 
	LINE,
	elk("~Mark","C-g",keymark), 
	elk("~Goto Mark","M-g",tomark), 
	elk( "Ne~xt Mark","Tab",nextmark), 
	elk("P~revious Mark","M-Tab",prevmark), 
	elk("~List marks","M-l",showmarks),
	LINE,
	elm("~Top",postotop),
	elk("~Begin file", "S-F9",beginfile),
	elk("~End file", "S-F10",endfile),
	elk("Beg~in Pg","F9",beginpage),
	elk("En~d Pg","F10",endpage),
	elk("Middle~ Pg","C-M",middlepage) );

menumake(display,"~Data type" , 
	elk("~Prev","F7",prevmode), 
	elk("~Next","F8",nextmode), 

	elm("~Select",selectmode) , 

	elk("~To","C-t",asktomodeget), 
	elk("~Remove","M-t",removemode), 
	elk("~Full","C-f",zoommode));

menumake(window,"~Window",
	elk("A~dd Prev","S-F5",addprev), 
	elk("~Add Next","S-F6",addnext),
	elk("~Prev","F5",prevfile),  
	elk("~Next","F6",nextfile), 
	elm("~First",firstfile), 
	elm("Las~t",lastfile),
	LINE, 
	elk("~Zoom","M-z",zoomwindow), 
	elk("~Hide","M-h",hidewindow),
	elk("~List","M-0",listfiles));

menumake(options,"~Options" , 
	elm("~Numbertype",askbase), 
	elm("~Messageline",switchmessage), 
	elm("Men~u",switchmenu),
	elm("~Commandmode(on/off)",switchcommand));
void menus(void) {
	int i,next;
	barwin=newwin(1,MainScreenwidth,0,0);
	leaveok(barwin,1);
	//wresize(barwin,1,MainScreenwidth);
	OldMainScreenwidth=MainScreenwidth;
/*
	wattrset(barwin,BARATTR);
	wbkgdset(barwin,' '|BARATTR);
	werase(barwin);
	*/
	attrall(barwin,BARATTR);
	wmove(barwin,0,0);
	startbar=0;
	maxmenusize=0;
	menuiter=-1;
/*
	wbkgdset(barwin,0);
	*/
	fileshow();
	editshow();
	moveshow();
	displayshow();
	windowshow();
	optionsshow();
	wattrset(barwin,BARATTR);
	wbkgdset(barwin,' '|BARATTR);
	menuiter++;
	}

int prevmenu(void) {
	if(!menunu) 
		menunu=menuiter-1;
	else
		menunu--;
	return -4;
	}

int menuresized(void){			
	resized();
	rewriteall();
	return -4;
	}
int firstmenuitem(void) {
	selectmenu(menulist[menunu],-(menulist[menunu]->nu));
	return -3;
	}
int lastmenuitem(void) {
	selectmenu(menulist[menunu],menulist[menunu]->len-menulist[menunu]->nu-1);
	return -3;
	}
int nextmenuitem(void) {
	if(menulist[menunu]->nu>(menulist[menunu]->len-2))
		selectmenu(menulist[menunu],-(menulist[menunu]->nu));
	else
		selectmenu(menulist[menunu],1);
	return -3;
	}
int prevmenuitem(void) {
	if(menulist[menunu]->nu==0)
		selectmenu(menulist[menunu],menulist[menunu]->len-1);
	else
		selectmenu(menulist[menunu],-1);
	return -3;
	}
int nextmenu(void) {
	menunu++;
	if(menunu>=menuiter)
		menunu=0;
	return -4;
	}
int nop(void) {return 0;};
int rewrite(void) {
	curses_init_curses.reset();
	refresh();
	if(MainScreenwidth>OldMainScreenwidth){
		wresize(barwin,1,MainScreenwidth);
		OldMainScreenwidth=MainScreenwidth;
		}
	redistribute=1;
	return -1;
	}
/*
	*/
int Editor::fileok(void) ;
int Editor::saveinode(void) ;
int discard(void) {
	dontdesturbe++;
	mem.empty();
	modified=0;
	updated=1;
	dontdesturbe--;
	return 0;
	}
int tocommand(void) {
	commandmode=1;
	}
int fromcommand(void) {
	commandmode=0;
	}
int switchcommand(void) {
	commandmode=!commandmode;
	}
/*
int saveexample(void) {
	char *ex1="example1";
	char *ex2="example2";
	char *file="/tmp/examples";
	char ch='\n';
	int (Editor::*p)(void);
	int handle=creat(file,0777);
	if(handle<0)	{
		message("can't open %s",file);
		return -1;
		}
	unsigned long beg;
	for(int i=0;i<procnr;i++) {
		beg=(unsigned long)&proc[i];
		write(handle,(char *)&beg,4);
		write(handle,procnames[i],strlen(procnames[i]));
		write(handle,&ch,1);
		}
	write(handle,ex1,strlen(ex1));
	write(handle,(char *)example1,1000);
	write(handle,ex2,strlen(ex2));
	write(handle,(char *)example2,1000);
	close(handle);
	}
	*/
	long getpart(unsigned long begin, unsigned long len, char * buf); 
	long putpart(unsigned long begin, unsigned long len, char * buf);
	int filesize(void);
	void erefresh(void);

static int (Editor::*Editor::ineditproc[])(void);
static int (Editor::*Editor::inmenuproc[])(void);
int Editor::repeat(void) ;
int Editor::therepeat(int nr) ;
int Editor::doproc( int (Editor::*proc)(void)) ;
char *Editor::getfilename(char *buf);

int Editor::getselbuf(char **buf) ;
int Editor::putselbuf(char *buf,int len) ;
int Editor::getselect(void) ;
int Editor::putselect(int pos) ;

int Editor::postotop(void);

int Editor::showprocedure(void) ;
};

#ifdef TRACEON
#include "trace.cpp"
#endif
void Editor::erefresh(void) {
	wrefresh(editscreen);
	}
	long Editor::getpart(unsigned long begin, unsigned long len, char * buf) {return mem.getpart(begin,len,buf);}
	long Editor::putpart(unsigned long begin, unsigned long len, char * buf) {return mem.putpart(begin,len,buf);}
	int Editor::filesize(void) {return mem.size();}
inline	int ScreenPart::getsearch(char *ant) { editor->getinput(searchquestion,ant); return makeascii((unsigned char*)ant); };
struct Editor::menu *Editor::menulist[20];
int Editor::menuiter=0;
int Editor::menunu=-1;

int Editor::lensel=0;
char *Editor::selbuf=NULL;

int Editor::getinput(const char question[],char *answer) {
	int i;
	getinputback:
	COMMANDON;
	editmove(MESSAGELINE,0);
	overline() ;
	editmove(MESSAGELINE,0);
	waddnstr(editscreen,question,Screenwidth-1);
	echoon();
	leaveok(editscreen,0);
	wrefresh(editscreen);
	waitinput=1;
	if((setjmp(resizejmp))) {

		resized();
		rewriteall();
		goto getinputback;
		};
	wgetstr(editscreen,answer);
	leaveok(editscreen,1);
	waitinput=0;
	ismessage=1;
	COMMANDOFF;
	noecho();
	clearmessage();
	wrefresh(editscreen);
	}
int Editor::inputget(char *answer,const char *format,...) {
	int i;
	char question[255];
	va_list ap;
	va_start(ap,format);
	vsprintf( question, format,  ap);
	va_end(ap);

	getinputback:
	COMMANDON;
	editmove(MESSAGELINE,0);
	overline() ;
	editmove(MESSAGELINE,0);
	waddnstr(editscreen,question,Screenwidth-1);
	echoon();
	leaveok(editscreen,0);
	wrefresh(editscreen);
	waitinput=1;
	if((setjmp(resizejmp))) {

		resized();
		rewriteall();
		goto getinputback;
		};
	wgetstr(editscreen,answer);
	leaveok(editscreen,1);
	waitinput=0;
	ismessage=1;
	COMMANDOFF;
	noecho();
	clearmessage();
	wrefresh(editscreen);
	}


void ScreenPart::troggleselect(int pos) {
	if(editor->selected(editor->filepos+pos))
			SELECTIEON;
		else
			normaal(editor->editscreen);
	}
inline int &ScreenPart::nrx(void) {return editor->nrx;};
inline int &ScreenPart::nry(void) {return editor->nry;};

inline int ScreenPart::oldpos(void) {
					return (editor->oldpos<editor->size?editor->oldpos:0);
					};

void ScreenPart::movepos(int pos) {
	int x,y;
	postoxy(pos,x,y);
	wmove(editor->editscreen,top+y,left+x);
	}

	
void ScreenPart::printchar(int pos, int ch) {
	movepos(pos);
	troggleselect(pos);
	chput(ch);
	}

int ScreenPart::putline(int y) {
	int pos,  x;
	unsigned long last;
	wmove(editor->editscreen,y+top,left);
	last=min((y+1)*nrx(),editor->size);
	for(pos=y*nrx();pos<last;pos++) {
		troggleselect(pos);
		chput(editor->buffer[pos]);
		}
	}
int ScreenPart::sput(char *buf, int size) {
	int pos=0, maxy=size/nrx(), maxlast=size%nrx(),x,y;
	for(y=0;y<maxy;y++) {
		wmove(editor->editscreen,y+top,left);
		for(x=0;x<nrx();x++) {
			troggleselect(pos);
			chput(buf[pos++]);
			}
		}
	wmove(editor->editscreen,y+top,left);
	for(x=0;x<maxlast;x++) {
		troggleselect(pos);
		chput(buf[pos++]);
		}
	}
int ScreenPart::nocursor(void) {
	int was=oldpos();
	movepos(was);
	troggleselect(was);
	chput(editor->buffer[was]);
	}

inline int Editor::changechar(int pos,unsigned char ch) {
	addundo(filepos+ pos,buffer[pos] );
	buffer[pos]=ch;
	printchar(pos,ch);
	}
int digitmakeascii(int base,int nrchar,unsigned char *ant,unsigned char *out) {
	int power,i,num,over;
	char ch;
	unsigned char *ptr=out,*start=out,*to=ant;
	for(i=0;ant[i];i++) {
		while(isspace(ant[i]))
			i++;
		if(!ant[i])
			break;
		*to++=ant[i];
		}
	*to='\0';
	int len=to-ant;
	if(len<1)
		return 0;
	if((over=(len%nrchar))) {
		for(power=1,ch=0,i=over-1;i>=0;i--) {
			if((num=Digit::numel(ant[i]))>=base)
				return 0;
			ch+=(num*power);
			power*=base;
			}
		*ptr++=ch;
		ant+=over;
		}
	while(*ant) {
		for(power=1,ch=0,i=nrchar-1;i>=0;i--) {
/*			if(!ant[i])
				goto endid;*/
			if((num=Digit::numel(ant[i]))>=base)
				return 0;
			ch+=(num*power);
			power*=base;
			}
		*ptr++=ch;
		ant+=nrchar;
		}
	endid:
	*ptr='\0';
	return (ptr-start);
	}

inline int digitmakeascii(int base,int nrchar,unsigned char *ant) {
	unsigned char tijd[MAXANT];
	strcpy((char *)tijd,(char *)ant);
	return digitmakeascii(base,nrchar,tijd,ant);
	}

int digitfromascii(int base,int nrchar,unsigned char *to,unsigned char *from,int len) {
	int i,j,power;
	unsigned char ch,*end,*begin=to;
	for(end=from+len;from<end;to+=nrchar,from++) {
		ch=*from;
		for(power=1,j=nrchar-1;j>=0;j--,power*=base) {
			to[j]=(ch/power)%base+'0';
			}
		
		}
	*to='\0';
	return (to-begin);
	}

int fromascii(int tmode,unsigned char* to,unsigned char* from,int len) {
	switch(tmode) {
		case 256:  memmove(to,from,len);to[len]='\0'; return len;
		case 16:  return hexfromascii(to,from,len);
		default:  return digitfromascii(tmode,(((int)ceil(log(256)/log(tmode)))),to,from,len);
		}
	}
int mkascii(int tmode, unsigned char *ant,unsigned char *out) {
	switch(tmode) {
		case 256:  {int len=strlen((char *)ant);memmove(out,ant,len);out[len]='\0';return len;};
		case 16: return hexmakeascii(ant,out);
		default: return digitmakeascii(tmode,(((int)ceil(log(256)/log(tmode)))),ant,out);
		}
	}


int mkascii(int tmode, unsigned char *ant,unsigned char *out,int len) {
	switch(tmode) {
		case 256:  {memmove(out,ant,len);out[len]='\0';return len;};
		case 16: return hexmakeascii(ant,out);
		default: return digitmakeascii(tmode,(((int)ceil(log(256)/log(tmode)))),ant,out);
		}
	}
	/*
int mkascii(int tmode, unsigned char *ant) {
	switch(tmode) {
		case 256: return strlen((char *)ant);
		case 16: return hexmakeascii(ant);
		default: return digitmakeascii(tmode,(((int)ceil(log(256)/log(tmode)))),ant);
		}
	}
	*/
inline int Digit::makeascii(unsigned char *ant) {
	return digitmakeascii(base,nrchar,ant);
	}

inline int Digit::fromascii(unsigned char *to,unsigned char *from,int len) {
	 return digitfromascii(base,nrchar,to,from, len) ;
	}
int Digit::newchar(int key) {
	int ant;
	if(!isel(key))
		return -1;
	unsigned char ch=editor->buffer[editor->editpos];
	ant=(ch+(-((((ch)/((int)pow(base,half)))%base))+numel(key))*(int)pow(base,half));
	if(ant<256)
		return ant;
	return -1;
	}

int Digit::select(void) {half=0; editor->cursorpos(); return 0;}; 
void Digit::cursorpos(int pos) {
	char ch;
		int was=oldpos();
		movepos(was);
		troggleselect(was);
		chput(editor->buffer[was]);
		ch=editor->buffer[pos];
		if(half<nrchar) {
				int x,y;
				postoxy(pos,x,y);
				CURSORON;
				wmove(editor->editscreen,top+y,left+x+(nrchar-half-1));
				waddch(editor->editscreen,numpart(ch,half) CURSORALL);
				CURSOROFF;
				}
		else
			{
				movepos(pos);
				CURSORON;
				for(int i=(nrchar-1);i>=0;i--)
					waddch(editor->editscreen,numpart(ch,i) CURSORALL);
				CURSOROFF;
			}
		
	}

void Digit::chput(unsigned char ch) {
	for(int i=(nrchar-1);i>=0;i--)
		waddch(editor->editscreen,numpart(ch,i));
	waddch(editor->editscreen,' ');
	}






int Hex::newchar(int key) {
	int numnr;
		if((numnr=num(key))==30)
			return -1;
		return (editor->buffer[editor->editpos]&(0xf<<(!half*4))| (numnr<<((half)*4)));
		}

int Hex::select(void) {half=1; editor->cursorpos(); return 0;}; 

void Hex::cursorpos(int pos) {
	int was=oldpos();
	movepos(was);

	troggleselect(was);
	chput(editor->buffer[was]);
	switch(half) {
		case 1:;
		case 0:
			CURSORON;
		 	chput(editor->buffer[pos] CURSORALL,pos);
			CURSOROFF;
			break;
		default: {
			movepos(pos);
			char ch=editor->buffer[pos];
			CURSORON;
			waddch(editor->editscreen,hexel((ch>>4)&0xf) CURSORALL);
			waddch(editor->editscreen,hexel(ch&0xf) CURSORALL);
			CURSOROFF;
			break;
			}
		}
	}
//	s/addch(/waddch(editor->editscreen,
void Hex::chput(unsigned char ch) {
	waddch(editor->editscreen,hexel((ch>>4)&0xf));
	waddch(editor->editscreen,hexel(ch&0xf));
	waddch(editor->editscreen,' ');
	}


void Hex::chput(unsigned char ch,int pos) {
	int x,y;
	postoxy(pos,x,y);
	wmove(editor->editscreen,top+y,left+x+!half);
	if(half)
		waddch(editor->editscreen,hexel((ch>>4)&0xf));
	else
		waddch(editor->editscreen,hexel(ch&0xf));
	}


int Ascii::select(void) {editor->cursorpos();return 0;}; 

inline void Ascii::chput(unsigned char ch) {
	if(ch>31&&ch<127)
		waddch(editor->editscreen,ch);
	else
		waddch(editor->editscreen,noprint);
	}
void Ascii::cursorpos(int pos) {
	int i,was=oldpos();
	movepos(was);
	troggleselect(was);
	waddch(editor->editscreen,(winch(editor->editscreen)&0xff));
#ifdef ENDOFLINEBUG
	wrefresh(editor->editscreen);
#endif


	CURSORON;
	movepos(pos);
	waddch(editor->editscreen,(winch(editor->editscreen)&0xff));
	CURSOROFF;
	}

struct change {
	char *buf;
	int pos,size;
	struct change *next;
	};


/* Specifiek voor een file */



int Editor::setselect(void) {
	if(other<0)
		other=filepos+editpos;
	else {
		other=-1;
		updated=0;
		}
	/*
	selects[el%2]=filepos+editpos;
	if((selects[0]>selects[1])) {
		int old;
		old=selects[0];
		selects[0]=selects[1];
		selects[1]=old;
		}
	else
		el++;
		*/
	}
//MAXSELBUF: can do without looking


extern long getfree(void) ;
 
int Editor::getselect(void) {
	return other;
	}
int Editor::putselect(int pos) {
	return other=pos;
	}
int Editor::getselbuf(char **buf) {
	if(!selbuf)
		return -1;
	*buf=selbuf;
	return lensel;
	}

int Editor::putselbuf(char *buf,int len) {
	if(selbuf)
		delete selbuf;
	selbuf= new char[len];
	memmove(selbuf,buf,len);
	updated=0;
	lensel=len;
	return lensel;
	}
int Editor::copyselect(void) {
	if(other<0) {
		beep();
		return -1;
		}

	long posf=filepos+editpos,first;
	long len;
	if(other>posf) {
		len=other-posf+1;
		first=posf;
		}
	else {
		len=posf-other+1;
		first=other;
		}
	if((len>MAXSELBUF)&&(usecopy(len)>getfree())) {
		output("Not enough memory");
		beep();
		return -1;
		}
	char *newbuf=new char[len];
	if(!newbuf) {
		message("Can't allocate %d of memory for selection",len);
		beep();
		return -1;
		}
	else {
		if(selbuf)
			delete selbuf;
		lensel=len;
		selbuf=newbuf;
		memorize();
		mem.getpart(first, lensel, selbuf);
		updated=0;
		other=-1;
		return 0;
		}
	beep();
	return -1;
	}
int Editor::putbuf(char *buf,int len){
	dontdesturbe++;
		memorize();
		strtoundo(editpos+filepos,len);
		mem.putpart(editpos+filepos,len,buf);
		modified++;
		fromfile();
		updated=0;
	dontdesturbe--;
		}


int Editor::toscreen(void) {
	if(editfocus<startactive||editfocus>=startnonactive) {
			startactive=editfocus;
			startnonactive=editfocus+1;
			}
	if(resizeflag) 
		resized();
	if(redistribute||(fromtop>(startnonactive-startactive-1))) {
		rewriteall();
			}
	else  {
		if(shouldreinit)  
			reinit();
		else {
			if(dofromfile) {
				fromfile();
				updated=0;
				}
			if((!updated||(other>-1))) {
				writebuf();
				updated=1;
				}
			}
		}
	wrefresh(editscreen);
	}

int Editor::posputbuf(long pos,char *buf,int len){
	dontdesturbe++;
		strtoundo(pos,len);
		mem.putpart(pos,len,buf);
		modified++;
	dontdesturbe--;
	return len;
	}

int Editor::getmem(long pos,char *buf,int len){
		memorize();
		return mem.getpart(pos,len,buf);
		}
int Editor::putmem(long pos,char *buf,int len){
	dontdesturbe++;
		strtoundo(pos,len);
		mem.putpart(pos,len,buf);
		modified++;
	dontdesturbe--;
	if(pos>=filepos&&(pos<(filepos+max()))) {
		updated=0;
		fromfile();
		}
	}
int Editor::pastselect(void) {
	if(selbuf) {
	dontdesturbe++;
		int len=min(lensel,mem.size()-(editpos+filepos));
		putbuf(selbuf,len);
		topos(editpos+filepos+len);
	dontdesturbe--;
		return 0;
		}
	else {
		beep();
		return -1;
		}
	}

char *Editor::getfilename(char *buf) {
	strcpy(buf,mem.filename);
	return buf;
	}
int Editor::openfile(const char *ant) {
		struct stat st;
			int handle;
			if((handle=open(ant,O_WRONLY|O_CREAT,0666))<0) {
				message("Can't open %s: %s",ant,sys_errlist[errno]);
				wrefresh(editscreen);
				return -1;
				}
			if(fstat(handle,&st)==-1) {
				output("fstat failt, file not saved");
				wrefresh(editscreen);
				return -1;
				}


			if(st.st_size!=0) {
				for(int i=0;i<nredit;i++)
					if((st.st_ino==edits[i]->mem.statdata.st_ino)) {
						message("User error: %s is open. Use save or close first",edits[i]->mem.filename);
						wrefresh(editscreen);
						close(handle);
						return -1;
						}
				message("Nonzero %s exists, overwrite? (y/n)",ant);
				wrefresh(editscreen);
				switch(getch()) {
					case 'y':;
					case 'Y': if(ftruncate(handle,0)<0) {
							message("Can't truncate %s: %s",ant,sys_errlist[errno]);
							wrefresh(editscreen);
							return -1;
							}
						break;
					case 'n':;
					case 'N':;
					default:message("Not saved");wrefresh(editscreen);close(handle);return -1;
					};
				}
			return handle;
		}



int Editor::saveselect(void) {
	if(other>=0||selbuf) {
		int ret;
		const char *ant;
		char buf[MAXPATHLEN]="*";
		again:
		ant=getfile("Save Selection?",buf) ;
		editup();
		if(ant) {
			int handle;
			memorize();
			if((handle=openfile(ant))<0) {
				strcpy(buf,ant);
				goto again;
				}
			if(other>-1&&(copyselect()==-1))
				{
				long posf=filepos+editpos,first;
				if(other>posf) {
					lensel=other-posf+1;
					first=posf;
					}
				else {
					lensel=posf-other+1;
					first=other;
					}
				message("Writing to file %s",ant);
				wrefresh(editscreen);
				if(mem.saveto(handle,first,lensel)!=0) {
					close(handle);
					beep();
					message("Write to %s failt ",ant);
					wrefresh(editscreen);
					strcpy(buf,ant);
					goto again;
					}
				updated=0;
				other=-1;
				}
			else {
				ret=write(handle,selbuf,lensel);
				if(ret!=lensel) {
					close(handle);
					beep();
					message("write failt: %s",sys_errlist[errno]);
					wrefresh(editscreen);
					strcpy(buf,ant);
					goto again;
					}
				}
			if(close(handle)<0){
				message("close(handle) fails: %s",sys_errlist[errno]);
				return -1;
				}
			writebuf();
			message("Selection saved in %s",ant);
			return 0;
			}
		}
	return -1;
	}

int Editor::edscholldown(void) {
	if(filepos>0) {
		memorize();
		filepos-=cols();
		if(filepos<0)
			filepos=0;
		fromfile();
#ifdef CURSES
//		nocursor();
		scrollon(editscreen,1);
		wscrl(editscreen,-1);
		scrollon(editscreen,0);
		putline(0);
		oldpos+=cols();
		cursorpos();
#else
#ifdef CONIO
		updated=0;
#endif
#endif
		return 0;
		}
	beep();
	return -1;
	}
/* ADD: posibility to expand file */
void Editor::nocursor(void) {
	for(int i=0;i<nrparts;i++)
		parts[i]->nocursor();
	}

	int Editor::geteditpos(void) {return editpos;};
	int Editor::getfilepos(void) {return filepos;};
	char *Editor::getbuf(void) {return buffer;}
int Editor::scrollup(void) {
	if((filepos+max())<(mem.size()-1)) {
		memorize();
		filepos+=cols();
		if((filepos+max())>mem.size())
			filepos=mem.size()-max();

		fromfile();
#ifdef CURSES
		scrollon(editscreen,1);
		wscrl(editscreen,1);
		scrollon(editscreen,0);
		putline(rows()-1);
		oldpos-=cols();
		cursorpos();
#else
#ifdef CONIO
		updated=0;
#endif
#endif
		return 0;
		}
	cursorpos();
	beep();
	return -1;
	}
int Editor::backchar(void) {
	if(parts[mode]->backchar()) {
		cursorpos();
		return 0;
		}
	if(editpos) {
		editpos--;
		cursorpos();
		}
	else {
		if(filepos<=0) {
			beep();
			return -1;
			}
		memorize();
		filepos--;
		updated=0;
		fromfile();
		return -1;
		}
	return 0;
	};
int Editor::nextchar(void) {
	if(parts[mode]->nextchar()) {
		cursorpos();
		return 0;
		}
	if(editpos<(size-1)) {
		editpos++;
		cursorpos();
		}
	else {
		if((filepos+max())>=mem.size()) {
			beep();
			return -1;
			}
		memorize();
		filepos++;
		updated=0;
		fromfile();
		return 0;
		}
	return 0;
	}

int Editor::nextfast(void) {
	if(parts[mode]->nextchar()) {
		cursorpos();
		return 0;
		}
	if(editpos<(size-1)) {
		editpos++;
		cursorpos();
		}
	else {
		if(!scrollup()) {
			editpos-=(cols()-1);
			cursorpos();
			return 0;
			}
		return -1;
		}
	return 0;
	}
int Editor::lineup(void) {
	if(y()>0) {
		editpos-=cols();
		cursorpos();
		}
	else	{
		return edscholldown();
		}
	return 0;
	};
int Editor::linedown(void) {
	if(y()<(rows()-1)) {
		editpos+=cols();
		resetpos();
		cursorpos();
		}
	else {
		return scrollup();
		}
	return 0;
	};
int Editor::pageup(void) {
	memorize();
	filepos-=max();
	if(filepos<0)
		filepos=0;
	updated=0;
	fromfile();
	return 0;
	}
inline void Editor::resetpos(void) {
	if((filepos+editpos)>=(mem.size())) {
		beep();
		if(filepos>=(mem.size())) {
			filepos=mem.size()-1;
			}
		editpos=mem.size()-filepos-1;
		}
	}
int Editor::pagedown(void) {
	if(filepos>(mem.size()-max()-1)) {
		beep();
		return -1;
		}
	memorize();
	filepos+=max();
	if(filepos+editpos>=(mem.size()))
		editpos=mem.size()-filepos-1;
	updated=0;	
	fromfile();
	return 0;
	}
int Editor::endline(void) {
	editpos=(editpos/cols())*cols()+cols()-1;
	resetpos();
	cursorpos();
	return 0;
	}
int Editor::beginline(void) {
	editpos=(editpos/cols())*cols();
	cursorpos();
	return 0;
	}

long Editor::digfrom(char *ant) {
	long base,add;
	char *ptr;

	while(isspace(*ant))
		ant++;
	switch(ant[0]) {
		case '+': {
			add=filepos+editpos;
			ant++;
			break;
			}
		case '|': add=filepos;ant++;break;
		default: add=0;
		}
	if(ant[0]=='0') {
		if(ant[1]=='x') {
			ant+=2;
			base=16;
			}
		else {
			if(ant[1]=='\0')
				return 0;
			ant++;
			base=8;
			}
		}
	else
		base=10;
	return(strtol(ant,&ptr,base)+add);
	}
//((x>47&&x<58)?x-'0':((x>0x40&&x<0x47)?(x-55):((x>0x60&&x<0x67)?(x-87):30)))
int Editor::topos(long pos) {
		if(pos>=0&&pos<mem.size()) {
			if(pos<filepos||pos>(filepos+max()-1)) {
				memorize();
				splitpos((pos<mem.size())?pos:(mem.size()-1));
				fromfile();
				updated=0;
				return 0;
				}
			else {
				editpos=pos-filepos;
				cursorpos();
				return 0;
				}
			}
	beep();
	return -1;
	}

int Editor::postotop(void) {
	memorize();
	filepos=editpos+filepos;
	editpos=0;
	fromfile();
	updated=0;
	}

int Editor::setpos(long pos) {
		if(pos>=0&&pos<mem.size()) {
			if(pos<filepos||pos>(filepos+max()-1)) {
				splitpos((pos<mem.size())?pos:(mem.size()-1));
				return 0;
				}
			else {
				editpos=pos-filepos;
				return 0;
				}
			}
	return -1;
	}

int exitall(void) {
	while(nredit>0)
		if(edits[--nredit]->closefile()<0) {
			editfocus=nredit;
			nredit++;
			startnonactive=nredit;
			return -1;
			}
	curses_init_curses.restore();
	exit(0);
	}
int endedit(Editor *ed) {
	Editor *now,*vorig;
	int i;
	nredit--;
	for(i=nredit,vorig=NULL;i>=0&&edits[i]!=ed;i--) {
			now=edits[i];
			edits[i]=vorig;
			vorig=now;
			}
	edits[i]=vorig;

	redistribute=1;
	setactives();
	return 0;
	}
int Editor::endedit(void) {
	if(nredit<2) {
		if(!argfile())
			return exitall();
		}

	if(closefile()<0)
		return( -1);
	return ::endedit(this);
	}	
int Editor::closethis(void) {
	if(endedit()<0)
		return -1;
	else
		delete this;
	return 0;
	}
int Editor::quit(void) {
	return exitall();
	}
int Editor::closefile(void) {
	int i;
	memorize();
	if(!modified) {
		return 0;
		}
	for(i=startactive;i<startnonactive;i++) 
		if(this==edits[i])
			break;
	if(i==startnonactive) {
		startactive=editfocus;
		startnonactive=startactive+1;
		place(0);
		}
	wrefresh(editscreen);
	while(1) {
		message("Save changes %s before leaving? (y/n/c)",mem.filename);
		switch(getch()) {
			case 'y':;
			case 'Y': if(save())
					return -1;
			case 'n':;
			case 'N': return 0;
			case 'c':;
			case 'C':
				clearmessage();
					return -1;
			case 27: halfdelay(1); 
				if(getch()==ERR) {
					nocbreak();
					noecho();
					cbreak();
					nonl();
					scrollon(editscreen,0);
					flushinp();
					clearmessage();
					wrefresh(editscreen);
					return -1;
					};
				nocbreak();
				noecho();
				cbreak();
				nonl();
				scrollon(editscreen,0);
				flushinp();
				wrefresh(editscreen);
			default: beep();
			};
		}; 
	return 0;
	}
/* INFO */

int Editor::fileinfo(void) {
	message("%s %d bytes (%s) %s",mem.filename,mem.size(),((modified||changed)?"Modified":"Unmodified"),modename(parts[mode]->type));
	return 0;
	}
/*name, size, editpos */
/* stat gegs */
/*  wat is veranderd, gegevens undo?
* Geselecteerd gedeelte */

#include <sys/time.h>
#define timerdiff(een, twee) (((een).tv_sec - (twee).tv_sec)*1000000+ (een).tv_usec - (twee).tv_usec)



extern const char *regexerrorstring;
int Editor::dosearch(char *ant,int len) {
	int pos;
	memorize();
	//pos=(mem.lastforward&1)?(edge?0:filepos): (edge?(mem.size()-1):(filepos+size-len));
	pos=(mem.lastforward&1)?(edge?0:filepos+editpos+1): (edge?(mem.size()-1):(filepos+editpos-1));
	if(len) {
		message("Searching for %s",ant);
		wrefresh(editscreen);
		pos=mem.search(pos,ant,len);
		}
	else {
		if(mem.searchstr) {
			message("Next search for %s",mem.searchstr);
			wrefresh(editscreen);
			pos= mem.nextsearch();
			}
		else {
			return -1;
			}

		}
	if(pos==ULONG_MAX) {
		if(regexerrorstring) {
			output(regexerrorstring);
			regexerrorstring=NULL;
			}
		else
			message("Not found %s",mem.searchstr);
		return -1;
		}
	int ret=  topos(pos);
	if(!updated)
		writebuf();
	message("Found %s",mem.searchstr);
	return  ret;
	}
	/*
int Editor::search(void) { 
	char ant[MAXANT];
	int len;
	len=parts[mode]->getsearch(ant); 
	return dosearch(ant,len);
	}
	*/

int Editor::search(void) {
	char ant[MAXANT];
	char ascant[MAXANT];
	int len,reg=0,cas=1,forward, isok=0,res=1;
	int wlin=15,wcol=60;
	if(mem.searchstr) {
		 len=parts[mode]->fromascii((unsigned char*)ant,(unsigned char*)mem.searchstr,mem.searchlen);
		}
	else {
		ant[0]='\0';
		len=0;
		}

	forward=mem.lastforward&1;
	cas=(mem.lastforward>>1)&1;
	reg=(mem.lastforward>>2)&1;
	int tmode=(int)parts[mode]->type;
again:
        Common combase(tmode),*com=&combase;
	palcsconfig(res,wlin,wcol,4,com->last=(or*)al[((tmode>16)?7:(tmode>10?8:tmode>8?9:tmode>2?11:10))],
		checker("~Regular expression ",2,3,reg),
		checker( "~Case sensitive",3,3,cas), 
		checker( "For~ward",2,41,forward), 
		checker( "~Edge file",3,41,edge), 
		linerlen("~Find: ",len,ant,7,3),
		oke(10,3),
		act("Cance~l", 12,3),
		ore("~Ascii",11,15,256,com),
		ore("~Hex",12,15,16,com),
		ore("~Dec",11,27,10,com),
		ore("~Bin",12,27,2,com),
		ore("Oc~t",11,39,8,com)
		); 
		if(!res)	 { 
			editup(); 
			return -1; 
			}	
		else {
			if(res==LONG_MAX)  {
				menuresized();
				wrefresh(editscreen);
				goto again;
				}
			else {
				if(res>7&&res<13) {
					len=mkascii(tmode,(unsigned char*)ant,(unsigned char *)ascant,len);
					 switch(res) {
						case 8:tmode=256;break;
						case 9:tmode=16;break;
						case 10:tmode=10;break;
						case 11:tmode=2;break;
						case 12:tmode=8;break;
						}
					 len=fromascii(tmode,(unsigned char*)ant,(unsigned char*)ascant,len);
					 goto again;
					 }
				}
			}

	len=mkascii(tmode,(unsigned char*)ant,(unsigned char *)ascant,len);
	if(!len&&ant[0]) {
		output("Conversion failt");
		erefresh();
		goto again;
		}

	if(tmode!=((int)parts[mode]->type))
		getmode((Type)tmode);
	mem.lastforward=forward|(cas<<1)|(reg<<2);
	editup();
	return dosearch(ascant,len);
	}

int Editor::replacehere(long pos, char *str,int len  ) {
	if((mem.lastforward>>2)&1) {
		int offset,i;
		struct re_registers *searchregs=mem.searchregs;
		int matchlen=searchregs->end[0]-searchregs->start[0];
		char whole[matchlen];
		char to[BLOCKSIZE*2];

		getpart(pos,matchlen,whole);
		for(offset=0,i=0;i<len;) {
			if(str[i]=='&'&&(!i||str[i-1]!='\\')) {
				memmove(to+offset,whole,matchlen);
				offset+=matchlen;
				i++;
				}
			else {
				if(str[i]=='\\'&&(str[i+1]>'0'&&str[i+1]<='9')&&searchregs->start[str[i+1]-'0']!=-1) {
					int gr=str[++i]-'0';
					int grlen=searchregs->end[gr]-searchregs->start[gr];
					memmove(to+offset,whole+searchregs->start[gr]-searchregs->start[0],grlen);
					offset+=grlen;
					i++;
					}
				else {
					to[offset++]=str[i++];
					}
			      }
			}
		return posputbuf(pos,to,offset); 
		}
	else
		return posputbuf(pos,str,len); 

	}

      
int Editor::replace(void) {	
	char ant[MAXANT];
	char rep[MAXANT]="";
	char ascant[MAXANT];
	char rtmp[MAXANT];
	long lastpos;
	int len,isok,pos,rlen;

	int reg=0,cas=1,forward,res;
	int wlin=15,wcol=60;
	if(mem.searchstr)
		 len=parts[mode]->fromascii((unsigned char*)ant,(unsigned char*)mem.searchstr,mem.searchlen);
	else {
		ant[0]='\0';
		len=0;
		}

	if(replacestrlen)
		 rlen=parts[mode]->fromascii((unsigned char*)rep,(unsigned char*)replacestr,replacestrlen);
	else {
		rep[0]='\0';
		rlen=0;
		}
	forward=mem.lastforward&1;
	cas=(mem.lastforward>>1)&1;
	reg=(mem.lastforward>>2)&1;




	int tmode=(int)parts[mode]->type;



again:

        Common combase(tmode),*com=&combase;
	palcsconfig(res,wlin,wcol,4, com->last=(or*)al[((tmode>16)?8:(tmode>10?9:tmode>8?10:tmode>2?12:11))],
		checker("~Regular expression ",2,3,reg),
		checker( "~Case sensitive",3,3,cas), 
		checker( "For~ward",2,41,forward), 
		checker( "~Edge file",3,41,edge), 
		linerlen("~Find: ",len,ant,6,3),
		linerlen("Re~place with:",rlen,rep,8,3),
		oke(11,3),
		act("Cance~l", 13,3),
		ore("~Ascii",12,15,256,com),
		ore("~Hex",13,15,16,com),
		ore("~Dec",12,27,10,com),
		ore("~Bin",13,27,2,com),
		ore("Oc~t",12,39,8,com)
		); 
		if(!res)	 { 
			editup(); 
			return 0; 
			}	
		else {
			if(res==LONG_MAX)  {
				menuresized();
				wrefresh(editscreen);
				goto again;
				}
			if(res>8&&res<14) {
				len=mkascii(tmode,(unsigned char*)ant,(unsigned char *)ascant,len);
				rlen=mkascii(tmode,(unsigned char*)rep,(unsigned char *)rtmp,rlen);

				 switch(res) {
					case 9:tmode=256;break;
					case 10:tmode=16;break;
					case 11:tmode=10;break;
					case 12:tmode=2;break;
					case 13:tmode=8;break;
					}
				 len=fromascii(tmode,(unsigned char*)ant,(unsigned char*)ascant,len);
				 rlen=fromascii(tmode,(unsigned char*)rep,(unsigned char*)rtmp,rlen);
				 goto again;
				 }
			}

	len=mkascii(tmode,(unsigned char*)ant,(unsigned char *)ascant,len);
	if(!len&&ant[0]) {
		output("Conversion failt");
		beep();
		erefresh();
		goto again;
		}
	if(rep[0]=='\0') {
		output("Use space to clear");
		beep();
		erefresh();
		goto again;
		}
	else {
		replacestrlen=mkascii(tmode,(unsigned char*)rep,(unsigned char *)replacestr,rlen);
		if(!replacestrlen) {
			message("User error: %s is no %s",rep,modename(parts[mode]->type));
			beep();
			erefresh();
			goto again;
			}
		}
	if(tmode!=((int)parts[mode]->type))
		getmode((Type)tmode);
	mem.lastforward=forward|(cas<<1)|(reg<<2);
	editup(); 
	editpos+=(1-(2*forward));
	if(dosearch(ascant,len)<0)  {
		editpos-=(1-(2*forward));
		return -1;
		}
	lastpos=mem.size()-replacestrlen;
	while(1) {
		if((!updated||(other>-1))) {
			writebuf();
			wrefresh(editscreen);
			}

		while(1) {
				if((editpos+filepos)>lastpos) {
						message("User error: Replace over end of file");
						return -1;
						}
				switch(getkeyinput("%s: Replace with %s (y)es/(n)o/(s)top/(a)all)",modename(parts[mode]->type),rep)) {
					case 'n':;
					case 'N': break; 
					case 'a':;
					case 'A': 
						output("Replace all ...");
						wrefresh(editscreen);
						mem.searchpos+=((replacehere(editpos+filepos,replacestr,replacestrlen)-1)*(2*forward-1));
						while((pos=mem.nextsearch())!=ULONG_MAX) {
							if(pos>lastpos) {
								topos(pos);
								if(!updated)
									writebuf();
								message("User error: Replace over end of file");
								return -1;
								}
							mem.searchpos+=((replacehere(pos,replacestr,replacestrlen)-1)*(2*forward-1));
							}
						fromfile();
						updated=0;
						return 0;
					case 'y':;
					case 'Y': 
							 
						mem.searchpos+=((replacehere(filepos+editpos,replacestr,replacestrlen)-1)*(2*forward-1));
							fromfile();
							writebuf();
							wrefresh(editscreen);break;
					case 27:
					case 's':
					case 'c':
					case 'S': clearmessage();return -1;
					default: continue;
					}

			  break;
			  }

		if(nextsearch()<0)
			return -1;
		}
	}

int Editor::nextsearch(void) {
	long pos;
	memorize();
		if(mem.searchstr) {
			message("Next search for %s",mem.searchstr);
			wrefresh(editscreen);
			pos= mem.nextsearch();
			}
		else {
			output("No previous search");
			return -1;
			}

	if(pos==ULONG_MAX) {
		message("Not found %s",mem.searchstr);
		return -1;
		}
	int ret= topos(pos);
	if(!updated)
		writebuf();
	message("Found %s",mem.searchstr);
	wrefresh(editscreen);
	return ret;
	}

	/*
int Editor::gettopos(void) {
	char ant[MAXANT];
	getinput("\\*>  Offset: ",ant);
	if(ant[0]!='\0') 
		return topos(digfrom(ant));
	beep();
	return -1;
	}
	*/


inline int typevolg(int x) {return ((x>10)?1:(x>8?2:3));}

inline int mknumstr(int tmode,int num,char *buf) {
	switch(tmode) {
		case 10: sprintf(buf,"%u",num);break;
		case 16: sprintf(buf,"%x",num);break;
		case 8: sprintf(buf,"%o",num);break;
		};
	}
int Editor::gettopos(void) {
	static int tmode=10,forward=1,edge=1;
	char ant[MAXANT],*ptr;
	int wlin=13,wcol=40,len;
	int res;
	long pos=lastgotopos;

again:
	mknumstr(tmode,pos,ant);	
        Common combase(tmode),*com=&combase;
	palcsconfig(res,wlin,wcol,2,com->last=(or*)al[typevolg(tmode)+4],
		checker( "For~ward",2,3,forward), 
		checker( "~Edge file",2,20,edge), 
		linernr("~Position: ",ant,5,3,20),
		oke(8,3),
		act("Cance~l", 10,3),
		ore("~Hex",9,15,16,com),
		ore("~Dec",10,15,10,com),
		ore("Oc~t",10,27,8,com)
		); 
	if(!res) { 
		editup(); 
		return -1; 
		}	
	else {
			if(res==LONG_MAX)  {
				menuresized();
				wrefresh(editscreen);
				goto again;
				}
		if((res>5)&&(res<9)) {
			pos=strtol(ant,&ptr,tmode);
			 switch((res-6)) {
				case 0:tmode=16;break;
				case 1:tmode=10;break;
				case 2:tmode=8;break;
				};
			 goto again;
			 }
		}
	pos=strtol(ant,&ptr,tmode);
	editup();
	if(ptr==ant) {
		message("No digit");
		return -1;
		}
	lastgotopos=pos;
	int cur=filepos+editpos;
	pos=  (edge?((!forward)*filesize()):cur)  + (2*forward -1)*(pos);
	if(pos<0)
		pos=0;
	else {
		if(pos>=filesize())
			pos=filesize()-1;
		}

	return topos(pos);
	}
















int Editor::endfile(void) {
	return topos(mem.size()-1);
	}
int Editor::beginfile(void) {
	return topos(0);
	}
int Editor::saveas(const char *ant) {
	if(!ant) {
		return 1;
		}
	else {
		int handle;
		if((	handle=openfile(ant))<0)		{
			beep();
			return -1;
			}
	dontdesturbe++;
			if(mem.saveto(handle)!=0) {
					close(handle);
					message("Problems writing to %s: %s",ant,sys_errlist[errno]);
					beep();
					wrefresh(editscreen);
	dontdesturbe--;
					return -1;

					}
	dontdesturbe--;
			close(handle);
			message("Saved all to %s",ant);
			return 0;
			}
		}
int Editor::saveas(void) {
	char buf[MAXPATHLEN];
	const char *ant="*";
	memorize();
	do {
		strcpy(buf,ant);
		ant=getfile("Save as",buf) ;
		editup();
		} while( saveas(ant)<0);
	}
int Editor::dosave(void) {
	memorize();
	if(!modified) {
		output("Nothing to save");
		return 1;
		}


	while(1) {
		int ret=0;
		if((mem.touched())) 
			message("Error:: %s changed by other proces. Add modified screens (%d boundaries)????? (n/y)",mem.filename,BLOCKSIZE);
		else
			output("You really want to save changes? (y/n)");
		switch(getch()) {
			case 'y':;
			case 'Y': ret=save();
			case 'n':;
			case 'N': 
				flushinp();
				if(!ret) {

					clearmessage();
					return(0);
					}
				return ret;
			default: flushinp();beep();
			};
		}; 
	return 1;
	}
int Editor::save(void) {
	int ret;
	memorize();
	dontdesturbe++;
	if(mem.saveall()) {
		message("Couldn't save file %s: %s",mem.filename, sys_errlist[mem.error()]);
		ret=1;
		}
	else {
		modified=0;
		ret=0;
		}
	dontdesturbe--;
	return ret;
	}

int Editor::middlepage(void) {
	editpos%=cols();
	editpos+=(max()/2)-cols();
	resetpos();
	cursorpos();
	}
int Editor::beginpage(void) {
	editpos%=cols();
	cursorpos();
	return 0;
	}
int Editor::endpage(void) {
	editpos%=cols();
	editpos+=max()-cols();
	resetpos();
	cursorpos();

	return 0;
	}

int Editor::extendfile(int len) {
	if((len>MAXEXTEND)&&(useext(len)>getfree())) {
		message("To big. Extend multiple times with save between");
		return -1;
		}
	char buf[BLOCKSIZE];
	int iter=len;
	dontdesturbe++;
	memorize();

	long begin=(mem.filesize%BLOCKSIZE);
	long oldsize=mem.filesize;

	struct undo *ptr=getnextundo();
	ptr->len=-1;
	ptr->pos=oldsize;
	ptr->str=NULL;
	redos=lastundo;


	bl=(oldsize/BLOCKSIZE);

	mem.getblock(bl,buf);
	memset(buf+begin,'\0',BLOCKSIZE-begin);	
	mem.filesize+=len;
	mem.putblock(bl++,buf);

	int blend=mem.filesize/BLOCKSIZE+1;
	memset(buf,'\0',BLOCKSIZE);
	for(;bl<blend;bl++)
		mem.putblock(bl,buf);
	modified++;
	resetnumbase() ;
	if(!shouldreinit)
		fromfile();
	message("Wrote %d bytes at end of %s",len,mem.filename);
	updated=0;
	dontdesturbe--;
	return 0;
	}


int Editor::extend(void) {
	char ant[MAXANT];
	getinput("How many bytes? ",ant);
	return extendfile(atoi(ant));
	}
int Editor::truncate(void) {
	int vanaf=editpos+filepos+1;
	int eraf=mem.filesize-vanaf;
	int tomuch=((eraf>MAXTOUNDO)&&(usetrunc(eraf)>getfree()));
	switch(getkeyinput("Delete from cursor to end of file? (y/N/c)%s",((tomuch)?" ***no undo***":""))) {
		case 'y':
		case 'Y': break;
		default: message("Cancel"); beep();return -1;
		}

	dontdesturbe++;
	memorize();
	if(!tomuch)
		strtoundo(vanaf,eraf) ;
	mem.truncate(vanaf);
	modified++;
	resetnumbase(); 
	if(!shouldreinit) {
		fromfile();
		updated=0;
		}
	dontdesturbe--;
	}

//int Editor::zoomascii(void) {


struct Editor::tree Editor::basetree;
struct Editor::tree *Editor::treebase=&basetree;


void  *Editor::lookup(unsigned char input) {
		struct tree *iter;
		for(iter=keyhead->children;iter;iter=iter->next) 
			if(iter->ch==input) {
				if(iter->nr>0) {
					keyhead=iter;
					return NULL;
					}
				keyhead=treebase;
				return (void *)iter;
				};
		keyhead=treebase;
		return NULL;

	}
/*
#define keydef(proc, keys...) \
	unsigned char cat(proc , key) []= { ## keys};\
	keymap(cat(proc , key),sizeof(cat(proc , key)),proc); 
	*/


int Editor::keymap(int (Editor::*proc)(void),int nr,...) {
	va_list ap;
	int i;
	unsigned char ch[nr],*str;
	va_start(ap,nr);
	for(i=0;i<nr;i++) {
		ch[i]=va_arg(ap,unsigned char);
		if(ch[i]==listshow) {
			str=va_arg(ap,unsigned char*);
			while(*str!=listshow)
				ch[i++]=*str++;
			}
		}
	va_end(ap);
	return keymap(ch,nr,proc);
	}

void	freekeys(struct Editor::tree *par) {
	struct Editor::tree *next,*iter;
	if(!par->nr)
		return;
	for(iter=par->children;iter;iter=next) {
		next=iter->next;
		freekeys(iter);
		delete iter;
		}
	}
void showkeys(FILE *fp,unsigned char *keys,int nr) {
	for(int i=0;i<nr;i++)
		fprintf(fp,"%d ",keys[i]);
	}
 int Editor::keymap(unsigned char *keybuf,int nrkeys, int (Editor::*proc)(void)) {
 	unsigned char *keys=keybuf;
 	int nr=nrkeys;
	struct tree *parent;
	struct tree *iter;
	for(parent=treebase;nr>0;parent=iter,keys++,nr--) {
		for(iter=parent->children;iter&&(iter->ch!=*keys);iter=iter->next) 
			;
		if(iter) {
				if(nr==1) {
					if(iter->nr>0) {
						fprintf(stderr,"Overwriting previous keys with: ");
						showkeys(stderr,keybuf,nrkeys);
						freekeys(iter);
						fprintf(stderr,"\n");
						}
					iter->nr=0;
					iter->proc=proc;
					return 0;
					}
				if(iter->nr)
					continue;
				fprintf(stderr,"Overwriting previous key with: ");
				showkeys(stderr,keybuf,nrkeys);
				fprintf(stderr,"\n");

				}
			do {
				iter= parent->children;
				parent->children=new (struct tree);
				parent->children->next=iter;
				iter=parent->children;
				iter->ch=*keys;
				parent->nr++;
				iter->nr=0;
				iter->children=NULL;

				parent->nr++;

				nr--;
				keys++;
				parent=iter;
				  } 		while(nr>0);
			iter->proc=proc;
			return 0;
		}
	}
//struct Editor::tree *tree =(struct Editor::tree*) {1,27,{NULL}, NULL };


void rewriteall(void) {
		if((thelines-menuon)>=2) {
			if(editfocus==startactive) {
				while(((thelines-menuon)/(startnonactive-startactive))<2)
					startnonactive--;
				}
			else  
				while(((thelines-menuon)/(startnonactive-startactive))<2)
					startactive++;
			if(editfocus<startactive||editfocus>=startnonactive)  {
					startactive=editfocus;
					startnonactive=editfocus+1;
					}

			for(int i=startactive;i<startnonactive;i++)
					edits[i]->place(i-startactive);
			redistribute=0;
			}
		putmenus();
		}

int Editor::doproc( int (Editor::*proc)(void)) {
	return proc();
	}



int Editor::therepeat(int nr) {
		int i,key,ch;
		void  *procedure;
		key=ggetch(editscreen);
		if(!commandmode) {
			if(((ch=parts[mode]->newchar(key))>=0))  {
				changed=1;
				for(i=0;i<nr;i++) {
					if(((ch=parts[mode]->newchar(key))<0)||changechar(editpos,ch)<0|| nextfast()<0) {
						output("Error while inserting character");
						return -1;
						}
					

					}
				output("Done");
				return 0;
				}
			}
		while(!(procedure=lookup(key))) {
			if(keyhead==treebase) {
				beep();
				flushinp();
				output("Unknown procedure");
				return -2;
				}
			key=ggetch(editscreen);
			}
		
		for(i=0;i<nr;i++)
			if(edits[editfocus]->doproc((((struct tree *)procedure)->proc))<0) {
				output("Error while evoking procedure");
				return -1;
				}
		output("Done");
		return 0;
	}

int Editor::repeat(void) {
	char ans[MAXANT],*ptr;
	getinput("Repeat key: How many times? ",ans) ;
	if(!ans[0])
		return -1;
	long nr=strtol(ans,&ptr,10);
	if(ptr!=ans) {
		output("Type key");
		return therepeat(nr);
		}
	output("No digit");
	return -1;
	}
int oldfocus;
int Editor::proceskey(void) {
	int ch,key,ret;
	void  *procedure;
	do {
		toscreen();
		key=ggetch(editscreen);
		if(!commandmode)
			while(((ch=parts[mode]->newchar(key))>=0))  {
				changed=1;
				changechar(editpos,ch);
				nextfast();
				wrefresh(editscreen);
				key=ggetch(editscreen);
				}
		while(!(procedure=lookup(key))) {
			if(keyhead==treebase) {
				beep();
				flushinp();
				return -1;
				}
			key=ggetch(editscreen);
			}
		traceproc(this,(((struct tree *)procedure)->proc));
		ret= (((struct tree *)procedure)->proc)();	
		} while(editfocus==oldfocus);
	return ret;
	}
#define cat(x,y) x ## y


	void Editor::keyinit(void) {
	treebase=&basetree;
	treebase->nr=0;
	treebase->next=NULL;
	treebase->children=NULL;

	}
/*
	static  int (Editor::*proc[])(void);
	static  char *procnames[];
*/



#undef prodef
#define prodef(pr) pr,


int (Editor::*Editor::proc[])(void)={
	#include "procedures.h"
	};
#undef prodef
#define prodef(pr) #pr,
char *Editor::procnames[] = {
	#include "procedures.h"
	};
int Editor::procnr=sizeof(Editor::procnames)/sizeof(char *);


// char *keysyms[]= { "backspace", "delete", "down", "end", "esc", "home", "left", "pgdn", "pgup", "right", "stab", "up" };
#define keylabel(label,edit,menu,open) menu,
int (Editor::*Editor::inmenuproc[])(void)={
#include "keylist.h"
};
#undef keylabel
#define keylabel(label,edit,menu,open) edit,
int (Editor::*Editor::ineditproc[])(void)={
#include "keylist.h"
} ;

int (Editor::**Editor::dynproc)(void);
char **Editor::dynprocnames;
int Editor::dynprocnr=0;

#include "getlabel.h"
int putproc(char *str,int nr,unsigned char keys[]) {
	int i;
	i=getlabel(Editor::procnames,Editor::procnr,str);
	if(i>=0)
		return Editor::keymap(keys,nr,Editor::proc[i]);
	for(i=0;i<Editor::dynprocnr;i++) {
		if(!strcmp(str,Editor::dynprocnames[i])) 
			return Editor::keymap(keys,nr,Editor::dynproc[i]);
		}
	return -1;
	}



int Editor::selectprocedure(void) {
	static int take=0;
	int ant;
	while((ant=selectitemindex("Procedures",procnames,procnr,take))!=LONG_MAX) {
			if(ant==(LONG_MAX-1)) {
				menuresized();
				wrefresh(editscreen);
				}
			else {
				editup();
				take=ant;
				return (proc[ant])();

				 }
		}
	editup();
	return -1;
	}

int Editor::showprocedure(void) {
	int key,ch,i;
	void  *procedure;
	output("Type keys");
	key=ggetch(editscreen);



	if(!commandmode) {
			if(((ch=parts[mode]->newchar(key))>=0))  {
				changed=1;
				message("Builtin: %c",ch);
				return 0;
				}
			}


	while(!(procedure=lookup(key))) {
			if(keyhead==treebase) {
				beep();
				flushinp();
				output("No keybinding");
				return -2;
				}
			key=ggetch(editscreen);
			}
	for(i=0;i<procnr;i++) {
		if((((struct tree *)procedure)->proc)==proc[i]) {
			message("Procedure: %s",procnames[i]);
			return 0;
			}
		}
	for(i=0;i<dynprocnr;i++) {
		if((((struct tree *)procedure)->proc)==dynproc[i]) {
			message("Plugin procedure: %s",dynprocnames[i]);
			return 0;
			}
		}
	output("System error: I forgot the name");
	return -2;
}
int Editor::selectdynprocedure(void) {
	static int take=0;
	int ant;
	while((ant=selectitemindex("Dynamic Procedures",dynprocnames,dynprocnr,take))!=LONG_MAX) {
			if(ant==(LONG_MAX-1)) {
				menuresized();
				wrefresh(editscreen);
				}
			else {
				editup();
				take=ant;
				return (dynproc[ant])();

				 }
		}
	editup();
	return -1;
	}






#define keydef(proc, keys...)  keymap((unsigned char []){## keys},sizeof((unsigned char []){## keys}),proc);
 void Editor::defaultkeys(void) {
	keyinit();
	#include "builtinkeys.h"
	}
int Editor::getcols(void) {
	int i,chsize;
	int totalleft=Screenwidth-nrnumber();
	for(i=0;i<(nrparts-1);i++)
		totalleft-=parts[i]->spaceafter;
	for(i=0,chsize=0;i<nrparts;i++)
		chsize+=parts[i]->chsize;
	return (totalleft/chsize);
	}

void Editor::distribute(void) {
	int i;
	int start=nrnumber();
	nrx=getcols();
	nry=Screenheight;
	for(i=0;i<(nrparts-1);i++) {
		 parts[i]->place(start, top());
		 start+=(parts[i]->chsize)*nrx+parts[i]->spaceafter;
		 }
	parts[i]->place(start, top());
	}

Editor::Editor(char *filename): mem(filename){
	if(!mem.error()) {
		edge=0;
		replacestr[0]='\0';
		replacestrlen=0;
		commandmode=0;
		nomessage=0;
		fromtop=0;
		parts[0]= new Hex(this);
		parts[1]= new Ascii(this) ;

		mode=1;
		nrparts=2;

		initundo();
		oldpos=0;
		putnumbase(16);
		filepos=0;
		modified=0;
		changed=0;
		editpos=0;
		updated=0;
		lastgotopos=filesize()-1;

		keyhead=&basetree;
		waitinput=0;

		//selects[0]=selects[1]=0;
		other=-1;
		el=0;
		shouldreinit=1;
		editscreen=NULL;
		buffer=NULL;
		}
	else {
		editscreen=NULL;
		editpos=-1;
		}
	};

	int Editor::getmode(Type type) {
		if(tomode(type)<0)
			return addafter(type,mode);
		}
int Editor::addbefore(Type type,int to) {
	if(nrparts>=maxparts||(to<0||to>nrparts))
		return -1;
	parts[mode]->leave();
	for(int i=nrparts;i>to;i--)
		parts[i]=parts[i-1];
	switch(type) {
		case ASCII: parts[to]=new Ascii(this);break;
		case HEX: parts[to]=new Hex(this);break;
		case OCT:;
		case BIN:;
		case DEC: parts[to]=new Digit(this,(int)type); break;
		default: beep();return -1;
		};
	mode=to;
	nrparts++;
	shouldreinit=1;
	if(!nomessage)
		fileinfo();

	return 0;
	}
int Editor::zoommode(void) {
	ScreenPart *old=parts[0];
	parts[0]=parts[mode];
	parts[mode]=old;
	mode=0;
	for(int i=1;i<nrparts;i++)
		delete parts[i];
	nrparts=1;
	shouldreinit=1;
	}
int Editor::removemode(void) {
	int oldmode=mode;
	if(nrparts<2&& (asktomodeget()<0) )
			return -1;
	if(nrparts>1) {
		delete parts[oldmode];
		nrparts--;
		for(int i=oldmode;i<(nrparts);i++)
			parts[i]=parts[i+1];
		if(mode>=nrparts)
			mode--;
		shouldreinit=1;
		}
	else {
		beep();
		return -1;
		}
	}

int Editor::prevmode(void) {
	if(mode>0) {
		parts[mode]->leave();
		mode--;
		parts[mode]->select();
		if(!nomessage)
			fileinfo();
		return 0;
		}
	beep();
	return -1;
	}
int Editor::nextmode(void) {
	if(mode<(nrparts-1)) {
		parts[mode]->leave();
		mode++;
		parts[mode]->select();
		if(!nomessage)
			fileinfo();
		return 0;
		}
	beep();
	return -1;
	}
 Editor::~Editor() {
 	if(editpos>=0) {
	//	endedit();
	//	dosave();
		free(buffer);
		for(int i=0;i<nrparts;i++)
			delete parts[i];
		delundo();
		windel();
		}
	}
int Editor::place(int from) {
	fromtop=from;
	int count=(startnonactive-startactive);
	int leftheight=MainScreenheight-menuon;
	allheight=edittop=leftheight/count;
	if(fromtop==(count-1))
		allheight+=(leftheight%count);
	Screenwidth=MainScreenwidth;
	edittop=(fromtop*edittop)+menuon;
	dontdesturbe++;
	if(editscreen) {
		delwin(editscreen);
		}
	editscreen=newwin(allheight,Screenwidth,edittop,0); 
	dontdesturbe--;
	if(!editscreen) {
		message("newwin(%d,%d,%d,0) failt",allheight,Screenwidth,edittop);
		return -1;
		}
	leaveok(editscreen,1);
//	editerase();
	return reinit();
	}
int Editor::reinit(void) {
	Screenheight=allheight-(!nomessage);
	wsetscrreg(editscreen,0,Screenheight-1);
	memorize();
	if(buffer)
		free(buffer);
	distribute();
	size=max();
	buffer=(char *)malloc(size);
	splitpos(editpos+filepos);
	parts[mode]->select();
	fromfile();
	writebuf();
	shouldreinit=0;

	wrefresh(editscreen);
	}

void putmenus(void) {
	if(menuon) {
		touchwin(barwin);
		wrefresh(barwin);
		}
	}
int resized(void) {
	curses_init_curses.resized();
	if(MainScreenwidth>OldMainScreenwidth){
		wresize(barwin,1,MainScreenwidth);
		OldMainScreenwidth=MainScreenwidth;
		}
	resizeflag=0;
	redistribute=1;
	}


void Editor::cursorpos(void) {
	if((startactive+fromtop)==editfocus) 
		{
		for(int i=0;i<nrparts;i++)
			parts[i]->cursorpos(editpos);
		oldpos=editpos;
		}
	else {
		nocursor();
		oldpos=editpos;
		}
	};
	/*
int Editor::writebuf(void) {
	int y;
	for(y=0;y<rows();y++) {
		putline(y);
		}
	cursorpos();
	wrefresh(editscreen);
	updated=1;
	}
	*/

int Editor::writebuf(void) {
	editerase();
	number(); 
	for(int i=0;i<nrparts;i++) {
			parts[i]->sput(buffer,  size) ;
			}
	cursorpos();
	if(!nomessage)
		fileinfo();
	updated=1;
	}
void Editor::putline(int y) {
	if(maxnum)
		numline(y);
	for(int i=0;i<nrparts;i++)
		parts[i]->putline(y);
	}
	/*
inline void putnumber(long addr,int maxnum,int numbase) {
	for(int i=maxnum-1;i>=0;i--)
		addch(hexel((addr/(1<<(i*4)))%(16)));
	}
	*/

int Editor::askbase(void) {
	int ret=0;
	updated=0;
	switch(getkeyinput("Display offset in ((d)ec/(h)ex/(o)ct/(n)one)? ")) {
		case 'd': ret = putnumbase(10);break;
		case 'h': ret = putnumbase(16);break;
		case 'o': ret = putnumbase(8);break;
		case 'n': ret = putnumbase(0);break;
		case 'D': ret = putnumbase(10);break;
		case 'H': ret = putnumbase(16);break;
		case 'O': ret = putnumbase(8);break;
		case 'N': ret = putnumbase(0);break;
		};
	if(ret>0)
		shouldreinit=1;
	return ret;
	};
int Editor::putnumbase(int base) {
	char ch;
	switch(base) {
		case 16: ch='x';break;
		case 8: ch='o'; break;
		case 10: ch='u';break;
		case 0: maxnum=0; return 1;
		default: beep();return -1;
		};
	numbase=base;
	maxnum=(int)ceil(log(mem.size()+10000)/log(numbase));
	sprintf(numstr,"%s%d%c","%0",maxnum,ch);
	return numbase;
	}

#include <math.h>
void Editor::numline(int y) {
		NORMAAL;
		wmove(editscreen,y,startnum());
		wclrtoeol(editscreen);
		wprintw(editscreen,numstr,filepos+y*cols());
		}



void Editor::number(void) {
	if(maxnum) {
		NORMAAL;
		for(int y=0;y<Screenheight;y++) {
			wmove(editscreen,y,startnum());
			wprintw(editscreen,numstr,filepos+y*cols());
			}
			}
	}
int Editor::changestr(int pos,unsigned char *str,int size) {
	for(int i=0;i<size;i++)
		changechar(pos+i,str[i]);
	}
int Editor::saveinode(void) {
	place(0);
	message("Save dangling file, previously called %s? (Y/n)",mem.filename);
	switch(getch()) {
		case 'n':;
		case 'N':;break;
		case 'y':;
		case 'Y': ;
		default:
			while(saveas()<0) {
				beep();
				};
			break;
		}
	return 0;
	}
void Editor::filesup(void) {
	editup();
	}
int Editor::screensize(void) { return max();};
int Editor::fileok(void) {
	struct stat st;
	memorize();
	if(stat(mem.filename,&st)<0) {
		saveinode();	
		return -1;
		}
	if(st.st_ino!=mem.statdata.st_ino) {
		saveinode();	
		return 1;
		}
	if((st.st_mtime!=mem.statdata.st_mtime)||(st.st_size!=mem.statdata.st_size)) {
		if(!modified)
			return 20;
		int i;
		for(i=startactive;i<startnonactive;i++) 
			if(this==edits[i])
				break;
		if(i==startnonactive) {
			startactive=editfocus;
			startnonactive=startactive+1;
			resizeflag=0;
			redistribute=0;
			place(0);
			}
		wrefresh(editscreen);
		output("WARNING: file saved by other proces. Saving changes will probably destroy data.");
		}
	return 0;
	}
void omnihandler(int signum) {
	signal(signum,omnihandler);
	if(dontdesturbe) {
		return;
		}
	longjmp(screenjmp,signum);
	};
void resizehandler(int signum) {
	signal(SIGWINCH,resizehandler);
	if(waitinput)
		longjmp(resizejmp,signum);
	resizeflag=1;
	};
void stophandler(int signum) {
	signal(SIGSTOP,stophandler);
	endwin();
	}
void conthandler(int signum) {
	signal(signum,conthandler);
	refresh();
	curses_init_curses.reset();
	curses_init_curses.setscreen();
	if(MainScreenwidth>OldMainScreenwidth){
		wresize(barwin,1,MainScreenwidth);
		OldMainScreenwidth=MainScreenwidth;
		}
	rewriteall();
	}	
//	kill(pid,SIGWINCH);
void quithandler(int signum) {
	ungetch(28);
	signal(SIGQUIT,quithandler);
	};
int margc,miter=1;
char **margv;

Editor *newfile(const char *file ) {
	char absolu[MAXPATHLEN];
	expandfilename(absolu,file);
	for(int i=0;i<nredit;i++)
		if(!strcmp(edits[i]->mem.filename,absolu)) {
			editfocus=i;
			newscherm=1;
			edits[editfocus]->shouldreinit=1;
			if(editfocus<startactive||editfocus>=startnonactive) {
					redistribute=1;
					}
			return edits[i];
			}
	if(nredit>=(maxedit-1))  {
		maxedit*=2;
		edits=(Editor **)realloc(edits,maxedit*sizeof(Editor *));
		}
	edits[nredit]= new Editor(absolu);
	if(edits[nredit]->mem.error()||!edits[nredit]->mem.size()) {
		delete edits[nredit];
		return NULL;
		}
	editfocus=nredit;
	redistribute=1;
	nredit++;
	setactives();
	newscherm=1;
	return edits[editfocus];
	}

int addlast(void) {
	if(editfocus>startnonactive) {
		Editor *tmp=edits[editfocus];
		for(int i=editfocus;i>startnonactive;i--)
			edits[i]=edits[i-1];
		editfocus=startnonactive++;
		edits[editfocus]=tmp;
		return 0;
		}
	if(editfocus<startactive) {
			startactive--;
			if(editfocus==startactive) {
				return 0;
				}
			Editor *tmp=edits[editfocus];
			for(int i=editfocus;i<startactive;i++)
				edits[i]=edits[i+1];
			editfocus=startactive;
			edits[startactive]=tmp;
			return 0;
			}
	if(editfocus==startnonactive) {
			if(nredit>startnonactive)
				startnonactive++;
			else
				editfocus=nredit-1;
			return 0;
			}
	return -1;
	}

Editor *editfile(const char *file) {
	Editor *ed=newfile(file);
	if(!ed)
		return NULL;
	if(addlast()>-1) {
		ed->toscreen();
		return ed;
		}
	return ed;
	}
Editor *argfile(void) {
	Editor *ed;
	while(miter<margc) {
		if((ed=newfile(margv[miter++])))
			return ed;
		}
	return NULL;
	}


extern void dynlink(void);
#include <new.h>
int memoryexceeded=0;
void mynewhandler(void) {
	memoryexceeded=1;
	int j,i;
	if(takescr)
		delete takescr;
	for(i=0;i<nredit;i++) {
		if((!edits[i]->modified)&&(!edits[i]->changed)) {
			delete edits[i];
			edits[i]=NULL;
			}
		else {
			if(edits[i]->selbuf) {
				delete[] edits[i]->selbuf;
				}
			edits[i]->selbuf=NULL;
			edits[i]->delchunk();
			edits[i]->initundo();

			/*
			initchunk(5000);
			memset(undobuf,0,sizeof(undobuf));
			redos=beginundo=0;
			lastundo=-1;
			
			edits[i]->redos=edits[i]->beginundo=0;
			edits[i]->lastundo=-1;
			edits[i]->initchunk(10);
			memset(edits[i]->undobuf,0,sizeof(edits[i]->undobuf));
			*/
			}
		}
	for(i=0,j=1;i<nredit;i++) {
		if(!edits[i]) {
			j=max(j,i+1);
			for(;j<nredit&&!edits[j];j++) 
				;
			if(j<nredit)
				edits[i]=edits[j];
			else  
				break;
			}
		}
	nredit=i;
	char newer[]="Memory exceeded!!!";
	write(STDERR_FILENO,newer,sizeof(newer));
	raise(SIGSTOP);
	}

extern void doargs(void);
void main(int argc, char **argv) {
	margc=argc;
	margv=argv;
	pid=getpid();
	starttrace();
	startdebug();
	doargs();
	set_new_handler(mynewhandler);
	Editor::defaultkeys();
	int sig;
	edits= (Editor **)malloc(maxedit*sizeof(Editor *));
	curses_init_curses.curses_init();

	if(!argfile()) {
			const char *ask;
			const char *file="*";
			do {
				ask=file;
				if(!(file=takefile("Open file",ask))) {
					wclear(stdscr) ;
					curses_init_curses.restore();
					exit(0);
					}
				} while(file==ask||!newfile(file));
		}
	editfocus=0;
	startactive=0;
	startnonactive=nredit;
 
	edits[editfocus]->menus();
	switch((sig= setjmp ( screenjmp ) )) {
		case 28 : ;
			signal(28 ,resizehandler);
		case 2 : {
			redistribute=1;
			curses_init_curses.reset();
			break;
			};
		case 15 : {
			exitall();
			curses_init_curses.restore();
			break;
			}

		case 0:

	signal(1 ,SIG_IGN);
	signal(28 ,resizehandler);
	signal(19 ,stophandler);
	signal(18 ,conthandler);
	signal(3 ,quithandler);
	signal(2 ,omnihandler);
	signal(15 ,omnihandler);
			break;
		default:
			fprintf(stderr,"Unknown signal %d\n",sig);
		}

	wrefresh(stdscr );
	int action,ret;
	while(1) {
		if((ret=edits[editfocus]->fileok())!=0) {
			Editor *ed=edits[editfocus];
			endedit(ed);
			if(ret>0) 
				newfile(ed->mem.filename);
			delete ed;
			if(nredit<1&&!argfile())
				exit(0);
			}
		else {
			oldfocus=editfocus;
			dontdesturbe=0;
			action=edits[editfocus]->proceskey();
			dontdesturbe=1;
			}
		};
	}

int ggetch(WINDOW *w) {
	static int ch=0;
	int key;
	waitinput=1;
	if((__setjmp ( resizejmp ) )) {
		waitinput=0;
		return 12 ;
		};
	if(ch) {
		if(ch==27) {
			ch=0;
				halfdelay(1);
				if((key=wgetch(w))== (-1) )
					key= 254 ;
				nocbreak();
				noecho();
				cbreak();
				nonl();
				}
		else {
			key=ch;
			ch=0;
			}
		}
	else {
			if((key=wgetch(w))&0x80) {
				ch=key&0x7f;
				waitinput=0;
				return 27;
				}
			else
				if(key==27)
					ch=27;
		}
	waitinput=0;
	return key;
	}


