/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */


#include <string.h>
class keyinput {
	public:
	struct tree {
		int nr;
		unsigned char ch;
		union  {
			struct tree *children;
			int sym;
			};
		struct tree *next;
		};
	struct tree *keyhead;
	struct tree basetree;
	struct tree *treebase;
	int  keyseq(unsigned char input) ;
	int putseq(int sym,int nr, unsigned char *keys) ;
	inline int isstart(void) {return keyhead==treebase;};
	keyinput(void) { 
		keyhead=treebase=&basetree;
		memset((char*)treebase,'\0',sizeof(basetree));
		};
	keyinput( void (*fun)(class keyinput *inp))  { 
		keyhead=treebase=&basetree;
		memset((char*)treebase,'\0',sizeof(basetree));
		fun(this);
		};
	freetree(struct tree *t) {
		struct tree *old;
		for(t=t->children;t;old=t,t=t->next,delete(old)) 
			if(t->nr)
				freetree(t);
		}
	~keyinput() {freetree(&basetree);}
	};
#define listshow 252
#define menukey 253
#define secondescape 254
