/*     Bed a Binary EDitor for Linux and for Rxvt running under Linux.       */
/*     Copyright (C) 1998  Jaap Korthals Altes <jkaltes@cyberbrain.com>      */
/*                                                                           */
/*     Bed is free software; you can redistribute it and/or modify           */
/*     it under the terms of the GNU General Public License as published by  */
/*     the Free Software Foundation; either version 2 of the License, or     */
/*     (at your option) any later version.                                   */
/*                                                                           */
/*     Bed is distributed in the hope that it will be useful,                */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/*     GNU General Public License for more details.                          */
/*                                                                           */
/*     You should have received a copy of the GNU General Public License     */
/*     along with bed; if not, write to the Free Software                    */
/*     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                           */
/* Sun Dec  6 18:34:27 1998                                                  */


#include <stdio.h>
#include <string.h>
#include "memory.h"
#include <stdlib.h>
#include <linux/fs.h>
#include <sys/ioctl.h>
#include <limits.h>
#include <unistd.h>
#include "system.h"
#include <ctype.h>
inline int isup(int ch) { return (ch>='A'&&ch<='Z');}
inline int islow(int ch) { return (ch>='a'&&ch<='z');}
inline int tolow(int ch) {return ch+(-'A'+'a');}
inline int toup(int ch) {return ch+(-'a'+'A');}
inline int mklow(int ch) { return (isup(ch)?tolow(ch):ch);}
inline int mkup(int ch) { return (islow(ch)?toup(ch):ch);}


#include <regex.h>
const char *regexerrorstring=NULL;
void Memory::openfile(void) {
	file=0;
#ifdef PROCLOCKSBUG
	if(!strcmp(filename,"/proc/locks")) {
		errors=9;
		return;
		}
#endif
	if(stat(filename,&statdata)) {
		errors=8;	
		return;
		}
	if( S_ISFIFO(statdata.st_mode)  ) {
		errors=7;
		return;
		}
	if((file=open(filename,O_RDONLY))<0) {
		errors=1;
		}
	else {
		errors=0;
#ifdef WHATTHEYSAY
		if(S_ISREG(statdata.st_mode) )
			filesize=statdata.st_size;
		else if(S_ISBLK(statdata.st_mode)) {
			int blocksize;
			if(ioctl(file,BLKGETSIZE ,&filesize)<0) {
				DEBUG("BLKGETSIZE failt\n");
				goto catchall;
				}
			else
				filesize*=512;
			}
		else	
#endif
		if(S_ISDIR(statdata.st_mode)) {
				errors=5;
				return;
				}
		 else 
		 	{
			catchall:
			char ch;
			unsigned long end = UINT_MAX;
			unsigned long begin=0,half;
			do {
				half=(unsigned long)(((double)end+begin)/2);
				if((lseek(file,half,SEEK_SET)==half)&&(read(file,&ch,1)>=1))
					begin=half+1;
				else
					end=half;

				} while(end>begin);
			filesize=begin;
			if(filesize>INT_MAX) {
				errors=6;
				return;
				}
			}
	 	}
	}
void Memory::init(char *name) {
	searchpos=0;
	lastforward=3;
	searchexpr=NULL;
	searchregs=NULL;
	searchstr=NULL;
	table=tablebase-SCHAR_MIN;
	expandfilename(filename,name);
	openfile();
	}



Memory::Memory(char *name)  {
	init(name);
	}
int Memory::reinit(char *name) {
	close(file);
	empty();
	 init(name);
	}
int Memory::reinit(void) {
	return reinit(filename);
	}
int Memory::empty(void) {
	for(Treel *iter=tree.treecontrol->roottree;iter!=tree.NIL;iter=tree.next(iter))
		delete iter->data.buf;
	tree.empty();
	}

Memory::~Memory() {
	if(file) {
		for(Treel *iter=tree.treecontrol->roottree;iter!=tree.NIL;iter=tree.next(iter))
			delete iter->data.buf;
		close(file);
		}
	}


/* Bepaal of file veranderd is na opstarte of laatste keer saven             */
/* Ga alle nodes af en save die nodes.                                       */
/* Nodes delete                                                              */
/*                                                                           */
/* Saven van een node:                                                       */
/* 	- ga naar positie file;                                                  */
/* 	- schrijf gegevens in file                                               */
/* 	- delete gegevens                                                        */
/* Sat Oct  3 00:50:05 1998                                                  */

int Memory::savenode(Treel *node) {
	DEBUG("Save %d\n",node->data.blocknr);
	long diff=filesize-(node->data.blocknr*BLOCKSIZE);
	long size=(diff<BLOCKSIZE)?diff:BLOCKSIZE;
	if(node->data.size!=size)
		fprintf(stderr,"WARNING not enough in node %d %d!=%d\n",node->data.blocknr,size,node->data.size);
	writeat(node->data.buf,node->data.size,node->data.blocknr*BLOCKSIZE);
	}

int Memory::touched(void) {
	struct stat st;
	if(stat(filename,&st)<0)
		return -1;
	if(st.st_mtime!=statdata.st_mtime)
		return 2;
	if(st.st_size!=statdata.st_size)
		return 3;
	if(st.st_ino!=statdata.st_ino)
		return 4;
	return 0;
	}
int Memory::saveall(void) {
	close(file);
	if((::truncate(filename,filesize)<0)||(file=open(filename,O_RDWR))<0) {
		readonly=1;
		if(errno)
			errors=errno;
		else
			errors=7777;
		if((file=open(filename,O_RDONLY))<0) {
			if(errno)
				errors=errno;
			else
				errors=7777;
			}
		return errors;
		}
	for(Treel *iter=tree.treecontrol->roottree;iter!=tree.NIL;iter=tree.next(iter)) {
		savenode(iter);
		delete iter->data.buf;
		}
	close(file);
	tree.empty();
	if((file=open(filename,O_RDONLY))<0) {
		if(errno)
			errors=errno;
		else
			errors=7777;
		}
	fstat(file,&statdata);
	return errors;
	}
/*
	struct stat stats;
		fstat(handle,&stats);
		if(stats.st_ino==statdata.st_ino&&stats.st_dev==statdata.st_dev) {
			close(handle);
			return saveall();
		}
		*/


int Memory::saveto(int handle) {
		char buf[BLOCKSIZE];
		int nr,did,ret;
		for(nr=0;did=getblock(nr, buf);nr++) {
				ret=write(handle,buf,did);
				if(ret!=did) {
					return -1;
					}
				}
		if((max((nr-1)*BLOCKSIZE,0)+ret)!=filesize)
			return -1;
		return 0;
		}
long Memory::getblockpiece(unsigned long beg,unsigned long len,char *get) {
	int onder=beg/BLOCKSIZE,ret;
	int in=beg%BLOCKSIZE;
	Treel *el=tree.search(onder);
	if(el!=tree.NIL) {
		ret=min(el->data.size,len);
		memmove(get,el->data.buf+in,ret);
		}
	else {
		if(lseek(file,beg,SEEK_SET)!=beg)
			return 0;
		ret= read(file,get,len);
		}
	return ret;
	}

long Memory::getpart(unsigned long beg,unsigned long len,char *gegs) {
	int start,over,nog,bl;
	int end=min(beg+len,filesize);
	len=end-beg;
	if(len<0)
		return -1;
	over=(BLOCKSIZE-(beg%BLOCKSIZE));
	over=min(len,over);

	if(getblockpiece(beg,over,gegs)!=over)
		return -1;


	nog=len-over;
	if(nog>0) {
		char *ptr;
		start=(beg/BLOCKSIZE)+1;
		bl=nog/BLOCKSIZE+start;
		nog=nog%BLOCKSIZE;
		ptr=gegs+over;
		for(int ret,did,nr=start;nr<bl;nr++,ptr+=BLOCKSIZE) {
			if((BLOCKSIZE!=getblock(nr, ptr)))
				return -1;
			}
		if(getblockpiece(end-nog,nog,ptr)!=nog)
			return -1;
		}
	return len;
	}

long Memory::putpart(unsigned long beg,unsigned long len,char *gegs) {
	int start,over,nog,bl;
	int end=min(beg+len,filesize);
	len=end-beg;
	if(len<0)
		return -1;
	over=(BLOCKSIZE-(beg%BLOCKSIZE));
	over=min(len,over);
	if(over)
		if(putblockpiece(beg,over,gegs)!=over)
			return -1;


	nog=len-over;
	if(nog>0) {
		char *ptr;
		start=(beg/BLOCKSIZE)+1;
		bl=nog/BLOCKSIZE+start;
		nog=nog%BLOCKSIZE;
		ptr=gegs+over;
		for(int ret,did,nr=start;nr<bl;nr++,ptr+=BLOCKSIZE) {
			if((BLOCKSIZE!=putblock(nr, ptr)))
				return -1;
			}
		if(putblockpiece(end-nog,nog,ptr)!=nog)
			return -1;
		}
	return len;
	}
int Memory::saveto(int handle,int beg,int len) {
	int start,over,nog,bl;
	char buf[BLOCKSIZE];
	int end=beg+len;
	over=(BLOCKSIZE-(beg%BLOCKSIZE));
	over=min(len,over);

	if(getpart(beg,over,buf)!=over)
		return -1;
	if(write(handle,buf,over)!=over)
		return -1;


	nog=len-over;
	if(nog) {
		start=(beg/BLOCKSIZE)+1;
		bl=nog/BLOCKSIZE+start;
		nog=nog%BLOCKSIZE;
		for(int ret,did,nr=start;nr<bl;nr++) {
			if((BLOCKSIZE!=getblock(nr, buf)))
				return -1;
			ret=write(handle,buf,BLOCKSIZE);
			if(ret!=BLOCKSIZE) {
				return -1;
				}
			}
		if(getpart(end-nog,nog,buf)!=nog)
			return -1;
		if(write(handle,buf,nog)!=nog)
			return -1;
		}
	return 0;
	}
Treel *Memory::gettreel(long blockiter) {
		Treel *el=tree.search(blockiter);
		if(el==tree.NIL) {
			char *gegs=new char[BLOCKSIZE]; 
			tree.insert((Data){blockiter,gegs,0});
			el=tree.search(blockiter);
			}
		return el;
		}

int Memory::writeat(char *ptr,long size,long offset) {
	int ret=lseek(file,offset,SEEK_SET);
	if(ret!=offset) {
		fprintf(stderr,"writeat: lseek failt %d!=%d\n",ret,offset);
		return -1;
		}
	ret=write(file,ptr,size);
	if(ret!=size) {
		fprintf(stderr,"write failt %d!=%d\n",ret,size);
		return -2;
		}
	return ret;
	}
int Memory::readat(char *ptr,long size,long offset) {
	int ret=lseek(file,offset,SEEK_SET);
	if(ret!=offset) {
		fprintf(stderr,"lseek failt %d!=%d\n",ret,offset);
		return -1;
		}
	ret=read(file,ptr,size);
	if(ret!=size) {
		fprintf(stderr,"read failt %d!=%d\n",ret,size);
		return -2;
		}
	return ret;
	}

/* Bepaal de middel blokken stukken  en het eerste en laatst block;          */
/*                                                                           */
/* Ga alle midden stukken af en zoek ze op in het geheugen. Als ze niet bestaan stop */
/* je de gegevens erin. Als ze wel bestaan worden ze eerst verwijderd;       */
/*                                                                           */
/* Eerste block: neem eerste gedeelte van de schijf, neem de rest uit buf;   */
/*                                                                           */
/* Laatste block: Neem eerste gedeelte uit buf neem de rest van schijf.      */
/* Wed Sep 30 23:19:48 1998                                                  */
/*
long Memory::putpart(unsigned long begin, unsigned long len, char * buf) {
	long beginblock,blocks,endblock,firstmodified,offset,size,last,fromfile,bytesize,end,ret;
	long bdiff,ediff;
	char *ptr=buf;

	beginblock=begin/BLOCKSIZE;
	end=begin+len;
	if(filesize<begin) 
		return (filesize-begin);
	if(filesize<end) {
		end=filesize;
		len=end-begin;
		}
	if(len==0)
		return 0;
	endblock=(end-1)/BLOCKSIZE+1;
	last=endblock*BLOCKSIZE;
	offset=beginblock*BLOCKSIZE;
	bdiff=begin-offset;
	ediff=last-end;
	Treel *first=gettreel(beginblock);
	Treel *lastblock=gettreel(endblock-1);
	if(bdiff>0) {
		if(!first->data.size) {
			readat(first->data.buf,BLOCKSIZE,offset);
			first->data.size=BLOCKSIZE;
			}
		}
	if(ediff>0) {
		if(!lastblock->data.size) {
			long ver=filesize-end;
			if(ver>0)
				readat(lastblock->data.buf,BLOCKSIZE,last-BLOCKSIZE);
			}
		lastblock->data.size=BLOCKSIZE-ediff;
		}

	first->data.buf+=bdiff;
	first->data.size-=bdiff;
	for(long blockiter=beginblock;blockiter<endblock; blockiter++)	{
		Treel *el=gettreel(blockiter);
		el->data.size=el->data.size?el->data.size:BLOCKSIZE;
		memmove(el->data.buf,ptr,el->data.size);
		ptr+=el->data.size;
		el->data.size=BLOCKSIZE;
		}
	if(filesize<last)
		lastblock->data.size=BLOCKSIZE-(last-filesize);
	first->data.buf-=bdiff; //PASOP: bij delete wordt data some verplaatst. Verwijder eerste uit loop of ga over op pointers
	return len;
	}
*/
long Memory::getblock(long blocknr,char *buf) {
	int ret;
	int offset=(blocknr*BLOCKSIZE);
	if(offset>=filesize)
		return 0;
	Treel *el=tree.search(blocknr);
	if(el!=tree.NIL) {
		memmove(buf,el->data.buf,el->data.size);
		ret=el->data.size;
		}
	else {
		if(lseek(file,offset,SEEK_SET)!=offset)
			return 0;
		ret= read(file,buf,BLOCKSIZE);
		}
	return min(filesize-offset,ret);
	}

long Memory::putblock(long blocknr,char *buf) {
	int ret;
	int offset=(blocknr*BLOCKSIZE);
	if(offset>=filesize)
		return 0;
	int thissize=min(filesize-offset,BLOCKSIZE);
	Treel *el=gettreel(blocknr);
	memmove(el->data.buf,buf,thissize);
	el->data.size=thissize;
	return thissize;
	}

void	Memory::setborder(unsigned long pos) {
	int under=pos/BLOCKSIZE;
	Treel *el=tree.search(under);
	if(el==tree.NIL)
		return;
	int offset=under*BLOCKSIZE;
	el->data.size=min(filesize-offset,BLOCKSIZE);
	}
void Memory::extend(unsigned long newsize) {
	int oldsize=filesize;
	filesize=newsize;
	setborder(oldsize);
	}
void Memory::truncate(unsigned long pos) {
	Treel *el=tree.search(filesize);
	if(el!=tree.NIL) {			/**CAUTION old data is not removed. No problem: extending goes always with putpart **/
		el->data.size=BLOCKSIZE;
		}
	filesize=pos;
	setborder(pos);
	}
long Memory::putblockpiece(unsigned long beg,unsigned long len,char *get) {
	int onder=beg/BLOCKSIZE,ret;
	int bstart=onder*BLOCKSIZE;
	int in=beg%BLOCKSIZE;
	Treel *el=tree.search(onder);
	int thissize=min(filesize-bstart,BLOCKSIZE);
	if(el!=tree.NIL) {
		if(el->data.size<thissize) {
			fprintf(stderr,"putblockpiece %d!=%d (should)\n",el->data.size,thissize);
			if(lseek(file,bstart,SEEK_SET)!=bstart) {
				fprintf(stderr,"putblockpiece lseek wrong\n");
				return 0;
				}
			char *gegs=new char[BLOCKSIZE],*old; 
			ret= read(file,gegs,thissize);
			if(ret!=thissize) {
				fprintf(stderr,"putblockpiece %d(read)!=%d(should)\n",ret,thissize);
				}
			memmove(gegs,el->data.buf,ret);
			old=el->data.buf;
			el->data.buf=gegs;
			delete old;
			el->data.size=ret;
			}
		memmove(el->data.buf+in,get,len);
		}
	else {
		if(lseek(file,bstart,SEEK_SET)!=bstart){
				fprintf(stderr,"putblockpiece lseek wrong\n");
				return 0;
				}
		char *gegs=new char[BLOCKSIZE]; 
		ret= read(file,gegs,thissize);
		if(ret!=thissize) {
			fprintf(stderr,"2:putblockpiece %d(read)!=%d(should)\n",ret,thissize);
			}
		memmove(gegs+in,get,len);
		tree.insert((Data){onder,gegs,thissize});
		}
	return len;
	}
	/*
long Memory::getpart(unsigned long begin, unsigned long len, char * buf) {
	Treel *tt;
	char *ptr=buf;

	long beginblock,blocks,endblock,firstmodified,offset,size,last,fromfile,bytesize,end,ret;

	beginblock=begin/BLOCKSIZE;
	end=begin+len;
	if(filesize<begin) 
		return (filesize-begin);
	if(filesize<end) {
		end=filesize;
		len=end-begin;
		}
	if(len<=0)
		return 0;
	endblock=(end-1)/BLOCKSIZE+1;
	last=endblock*BLOCKSIZE;
	offset=beginblock*BLOCKSIZE;

	do {
		if((tt=tree.rightside(beginblock))!=tree.NIL) 
			firstmodified=tt->data.blocknr;
		else
			firstmodified=BIGEST;

		fromfile=min(firstmodified,endblock)-beginblock;

		if(fromfile>0) {
			bytesize=fromfile*BLOCKSIZE;
			offset=beginblock*BLOCKSIZE;
			if(begin>offset) {
				bytesize-=(begin-offset);
				offset=begin;
				}
			if(firstmodified>=endblock&&end<last) {
				bytesize-=(last-end);
				}
			readat(ptr,bytesize,offset);
			ptr+=bytesize;
			}
		if(firstmodified<endblock) {
			char *src;
			if(end<((firstmodified+1)*BLOCKSIZE))
				size=end-firstmodified*BLOCKSIZE;
			else
				size=tt->data.size;
			if(begin>(firstmodified*BLOCKSIZE)) {
				long wacht=begin-(firstmodified*BLOCKSIZE);
				src=tt->data.buf+ wacht;
				size-=wacht;
				}
			else
				src=tt->data.buf;
			memmove(ptr,src,size);
			beginblock=firstmodified+1;
			ptr+=size;
			}
		else 	
			break;
		} while(beginblock<endblock);
	return len;
	}

*/


unsigned long Memory::nextsearch(void) {
	if(!searchstr)
		return ULONG_MAX;
	switch(lastforward) {
		case 3: return nextforwardsearch();
		case 1: return nextforwardicasesearch();
		case 7:
		case 5: return nextforwardregexsearch();


		case 2: return nextbacksearch();
		case 0: return nextbackicasesearch();
		case 6:
		case 4: return nextbackregexsearch();
		};
	}

unsigned long Memory::backicaseregexsearch(unsigned long beg,char *str,int len) {
	unsigned char *ta;
	int i;
	if(!searchexpr){
		searchexpr=  (struct re_pattern_buffer*) malloc(sizeof(struct re_pattern_buffer)) ;
		searchregs= (struct re_registers*) malloc(sizeof(struct re_registers));
		}
	memset(searchexpr,'\0',sizeof(struct re_pattern_buffer));
	searchpos=beg;
       	if(searchstr)
       		free( searchstr);
       	searchstr = (char *)malloc(len+1);
	memmove(searchstr,str,len);
       	searchstr[len]='\0';
	searchlen=len;
	 searchexpr->fastmap=(char *)tablebase;
	 ta=((unsigned char*)tablebase)+256;
	 for(i=0;i<0400;i++)
	 	ta[i]=i;
	 for(i='a';i<='z';i++)
	 	ta[i]=i-040;	
	 searchexpr->translate=ta;
	if((regexerrorstring=re_compile_pattern(searchstr, searchlen, searchexpr))) {
		return ULONG_MAX;
	 	}
	return nextbackregexsearch(); 
	}
unsigned long Memory::backregexsearch(unsigned long beg,char *str,int len) {
	if(!searchexpr){
		searchexpr=  (struct re_pattern_buffer*) malloc(sizeof(struct re_pattern_buffer)) ;
		searchregs= (struct re_registers*) malloc(sizeof(struct re_registers));
		 searchexpr->allocated=0;
		 searchexpr->buffer=NULL;
		}
	memset(searchexpr,'\0',sizeof(struct re_pattern_buffer));
	searchpos=beg;
       	if(searchstr)
       		free( searchstr);
       	searchstr = (char *)malloc(len+1);
	memmove(searchstr,str,len);
       	searchstr[len]='\0';
	searchlen=len;
	searchexpr->translate=NULL;

	if((regexerrorstring=re_compile_pattern(searchstr, searchlen, searchexpr))) {
		return ULONG_MAX;
	 	}
	 searchexpr->fastmap=(char *)tablebase;
	return nextbackregexsearch(); 
	}
unsigned long Memory::nextbackregexsearch(void) {
        char buf[3][BLOCKSIZE];
	long count,count0;
	int bl,pos,begin,last;
	int endblock,endpos,end;

	end=(searchpos+(BLOCKSIZE/2));
	endblock=end/BLOCKSIZE;
	endpos=end%BLOCKSIZE;

        bl=endblock;

        count0=getblock(bl,buf[bl&1]);
	bl--;
        if(bl>=0) {
		count=getblock(bl,buf[bl&1]);
		last=searchpos-bl*BLOCKSIZE+1;
		}
	else {
		last=searchpos+1;
		count=0;
		}

	if((pos=re_search_2(searchexpr, buf[(bl)&1], count, buf[(bl+1)&1], count0,last-1,-last,searchregs,last))!=-1) {
			if(bl<0)	
				searchpos=pos;
			else
				searchpos=pos+((bl)*BLOCKSIZE);
			return searchpos--;
			}

        for(; bl>0;) {
		bl--;
		getblock(bl,buf[bl&1]);
		if((pos=re_search_2(searchexpr, buf[(bl)&1], BLOCKSIZE, buf[(bl+1)&1], BLOCKSIZE,BLOCKSIZE-1,-BLOCKSIZE,searchregs,BLOCKSIZE))!=-1) {
			searchpos=pos+((bl)*BLOCKSIZE);
			return searchpos--;
			}
		}
	return ULONG_MAX;
	}
unsigned long Memory::regexsearch(unsigned long beg,char *str,int len) {
	if(!searchexpr){
		searchexpr=  (struct re_pattern_buffer*) malloc(sizeof(struct re_pattern_buffer)) ;
		searchregs= (struct re_registers*) malloc(sizeof(struct re_registers));

		 searchexpr->allocated=0;
		 searchexpr->buffer=NULL;
		}
	memset(searchexpr,'\0',sizeof(struct re_pattern_buffer));
	searchpos=beg;
       	if(searchstr)
       		free( searchstr);
       	searchstr = (char *)malloc(len+1);
	memmove(searchstr,str,len);
       	searchstr[len]='\0';
	searchlen=len;
	searchexpr->translate=NULL;
	searchexpr->fastmap=(char *)tablebase;
	if((regexerrorstring=re_compile_pattern(searchstr, searchlen, searchexpr))) {
		return ULONG_MAX;
	 	}
	return nextforwardregexsearch(); 
	}


unsigned long Memory::icaseregexsearch(unsigned long beg,char *str,int len) {
	unsigned char *ta;
	int i;
	if(!searchexpr){
		searchexpr=  (struct re_pattern_buffer*) malloc(sizeof(struct re_pattern_buffer)) ;
		searchregs= (struct re_registers*) malloc(sizeof(struct re_registers));
		 searchexpr->allocated=0;
		 searchexpr->buffer=NULL;
		}
	memset(searchexpr,'\0',sizeof(struct re_pattern_buffer));
	searchpos=beg;
       	if(searchstr)
       		free( searchstr);
       	searchstr = (char *)malloc(len+1);
	memmove(searchstr,str,len);
       	searchstr[len]='\0';
	searchlen=len;
	 searchexpr->fastmap=(char *)tablebase;
	 ta=((unsigned char*)tablebase)+256;
	 for(i=0;i<0400;i++)
	 	ta[i]=i;
	 for(i='a';i<='z';i++)
	 	ta[i]=i-040;	
	 searchexpr->translate=ta;

	if((regexerrorstring=re_compile_pattern(searchstr, searchlen, searchexpr))) {
		return ULONG_MAX;
	 	}
	return nextforwardregexsearch(); 
	}











unsigned long Memory::nextforwardregexsearch(void) {
        char buf[3][BLOCKSIZE];
	long count,count0;
	int bl,pos,begin;

	begin=searchpos%BLOCKSIZE;
        for(bl=searchpos/BLOCKSIZE,count=getblock(bl,buf[bl&1]);	count>0;) {
		bl++;
		count0=count-begin;
		count=getblock(bl,buf[bl&1]);
		if((pos=re_search_2(searchexpr, buf[(bl-1)&1]+begin, count0, buf[bl&1], count, 0, count0,searchregs,count0))!=-1) {
			searchpos=pos+((bl-1)*BLOCKSIZE)+begin;
			return searchpos++;
			}
		begin=0;
		}
	return ULONG_MAX;
	}

unsigned long Memory::icasesearch(unsigned long beg,char *str,int len) {

	int i;
	memset(tablebase,0,sizeof(tablebase));
       	if(searchstr)
       		free( searchstr);
       	searchstr = (char *)malloc(len+1);
       	for(i=0;i<len;i++) {
       		char ch=str[i];
		table[ch]=i+1;
       		if(isup(ch)) {
       			ch=tolow(ch);
			searchstr[i]=ch;
			table[ch]=i+1;
			}
		else {
			searchstr[i]=ch;
			if(islow(ch))
				table[toup(ch)]=i+1;
			}
       		}
       	searchstr[len]='\0';
       	searchlen=len;
	searchpos=beg;
	return nextforwardicasesearch(); 
	}

unsigned long Memory::nextforwardicasesearch(void) {
        int DBUFSIZE=2*BLOCKSIZE;
        char buf[3][BLOCKSIZE];
        char *start,*endstart;
        int i,bl,bij=0;
	unsigned long endblock,ending;
	long count;


        DBUFSIZE=2*BLOCKSIZE;
	int endstr=searchlen-1;
        for(bl=searchpos/BLOCKSIZE,count=getblock(bl,buf[bl&1]),endblock=bl*BLOCKSIZE;	count>0;) {
                endblock+=count;
		bl++;

		count=getblock(bl,buf[bl&1]);
		endblock+=min(0,(count-endstr));

		ending=endblock-endstr;

                for(start=buf[0]+(searchpos%DBUFSIZE), endstart=start+(ending-searchpos) ;start<endstart;) {
                		if(table[start[endstr]]) {
                			if((bij=table[start[endstr]])==searchlen) {
						if(!strncasecmp(searchstr,start++,searchlen)) {
							searchpos=(ending-(endstart-start+1));
							return searchpos++;
							}
						}
					else
						start+=(searchlen-bij);

					}
				else
					start+=searchlen;
                                }

/*searchpos=(bl-1)*BLOCKSIZE+(start-buf[(bl-1)&1]); */
							
                for(searchpos=(ending-(endstart-start));searchpos<endblock;) {
                		if(table[buf[0][(searchpos+endstr)%(DBUFSIZE)]]) {
					if((bij=table[buf[0][(searchpos+endstr)%(DBUFSIZE)]])==searchlen) {
						for(i=0;searchstr[i]==mklow(buf[0][(searchpos+i)%(DBUFSIZE)]);i++) 
								if(i==endstr) {
									return searchpos++;
									}
						searchpos++;
						}
					else
						searchpos+=(searchlen-bij)	;
					}
				else
					searchpos+=searchlen;
				}
		}
	return ULONG_MAX;
	}

unsigned long Memory::casesearch(unsigned long beg,char *str,int len) {
	int i;
	memset(tablebase,0,sizeof(tablebase));
       	for(i=0;i<len;i++) 
       		table[str[i]]=i+1;
       	if(searchstr)
       		free( searchstr);
       	searchstr = (char *)malloc(len+1);
       	memmove(searchstr,str,len);
       	searchstr[len]='\0';
       	searchlen=len;
	searchpos=beg;
	return nextforwardsearch(); 
	}
/*
endblock: laatste begin positie in block -1
ending: laatste begin positie van search waarvan het eind in dit bloc zit
endstart: laastste start positie waarvn het eind in dit block zit

*/
unsigned long Memory::nextforwardsearch(void) {
        int DBUFSIZE=2*BLOCKSIZE;
        char buf[3][BLOCKSIZE];
        char *start,*endstart;
        int i,bl,bij=0;
	unsigned long endblock,ending;
	long count;


        DBUFSIZE=2*BLOCKSIZE;
	int endstr=searchlen-1;
        for(bl=searchpos/BLOCKSIZE,count=getblock(bl,buf[bl&1]),endblock=bl*BLOCKSIZE;	count>0;) {
                endblock+=count;
		bl++;

		count=getblock(bl,buf[bl&1]);
		endblock+=min(0,(count-endstr));

		ending=endblock-endstr;

                for(start=buf[0]+(searchpos%DBUFSIZE),endstart=start+(ending-searchpos);start<endstart;) {
                		if(table[start[endstr]]) {
                			if((bij=table[start[endstr]])==searchlen) {
						if(!memcmp(searchstr,start++,searchlen)) {
							searchpos=(ending-(endstart-start+1));
							return searchpos++;
							}
						}
					else
						start+=(searchlen-bij);

					}
				else
					start+=searchlen;
                                }

/*searchpos=(bl-1)*BLOCKSIZE+(start-buf[(bl-1)&1]); */
							
                for(searchpos=(ending-(endstart-start));searchpos<endblock;) {
                		if(table[buf[0][(searchpos+endstr)%(DBUFSIZE)]]) {
					if((bij=table[buf[0][(searchpos+endstr)%(DBUFSIZE)]])==searchlen) {
						for(i=0;searchstr[i]==buf[0][(searchpos+i)%(DBUFSIZE)];i++) 
								if(i==endstr) {
									return searchpos++;
									}
						searchpos++;
						}
					else
						searchpos+=(searchlen-bij)	;
					}
				else
					searchpos+=searchlen;
				}
		}
	return ULONG_MAX;
	}

unsigned long Memory::backsearch(unsigned long beg,char *str,int len) {
	int i;
	for(i=SCHAR_MIN;i<=SCHAR_MAX;i++)
		table[i]=-1;
       	for(i=len-1;i>=0;i--) 
       		table[str[i]]=i;
       	if(searchstr)
       		free( searchstr);
       	searchstr = (char *)malloc(len+1);
       	memmove(searchstr,str,len);
       	searchstr[len]='\0';
       	searchlen=len;
	searchpos=beg;
	return nextbacksearch(); 
	}

unsigned long Memory::nextbacksearch(void) {
        char buf[3][BLOCKSIZE];
        char *start,*vorig,*huidig;
        int bl,bij,hierin;
	long count=searchlen;
	int endstr=searchlen-1;

	bl=((searchpos+searchlen)/BLOCKSIZE);
	hierin=((searchpos+searchlen)%BLOCKSIZE);

	vorig=buf[bl&1];
	if(((count=getblock(bl,vorig))>0)&&(hierin>=searchlen)) {
			for(start=vorig+hierin-searchlen;start>=vorig;) {
					if(table[*start]<0)
						start-=searchlen;
					else  {
						if((bij=table[*start])) 
							start-=bij;
						else {
							if(!memcmp(searchstr,start--,searchlen)) {
								searchpos=bl*BLOCKSIZE+(start-vorig+1);
								return searchpos--;
								}
							}

						}
					}
		}
	hierin=max(1,searchlen-hierin);

        for(bl-- ;(bl>=0&&(huidig=buf[bl&1],((count=getblock(bl,huidig))>0)));bl--,vorig=huidig) {
		for(start=huidig+BLOCKSIZE;hierin<searchlen;) {
			if(table[*(start-hierin)]<0)
				hierin+=searchlen;
			else  {
				if((bij=table[*(start-hierin)])) 
					hierin+=bij;
				else {
					if(!(memcmp(searchstr+hierin,vorig,(searchlen-hierin))||memcmp(searchstr,start-hierin,hierin))) {
									searchpos=bl*BLOCKSIZE+BLOCKSIZE-hierin;
									return searchpos--;
									}
					hierin++;
					}
				}
			}
		start-=hierin;
		hierin=1;

                for(;start>=huidig;) {
					if(table[*start]<0)
						start-=searchlen;
					else  {
						if((bij=table[*start])) 
							start-=bij;
						else {
							if(!memcmp(searchstr,start--,searchlen)) {
								searchpos=bl*BLOCKSIZE+(start-huidig+1);
								return searchpos--;
								}
							}

						}

                                }

		}
	return ULONG_MAX;
	}


unsigned long Memory::backicasesearch(unsigned long beg,char *str,int len) {
	int i;
	for(i=SCHAR_MIN;i<=SCHAR_MAX;i++)
		table[i]=-1;
       	for(i=len-1;i>=0;i--)  {
       		table[mklow(str[i])]=i;
       		table[mkup(str[i])]=i;
       		}
       	if(searchstr)
       		free( searchstr);
       	searchstr = (char *)malloc(len+1);
       	for(i=0;i<len;i++)
       		searchstr[i]=mklow(str[i]);
       	searchstr[len]='\0';
       	searchlen=len;
	searchpos=beg;
	return nextbackicasesearch(); 
	}

unsigned long Memory::nextbackicasesearch(void) {
        char buf[3][BLOCKSIZE];
        char *start,*vorig,*huidig;
        int bl,bij,hierin;
	long count=searchlen;
	int endstr=searchlen-1;

	bl=((searchpos+searchlen)/BLOCKSIZE);
	hierin=((searchpos+searchlen)%BLOCKSIZE);

	vorig=buf[bl&1];
	if(((count=getblock(bl,vorig))>0)&&(hierin>=searchlen)) {
			for(start=vorig+hierin-searchlen;start>=vorig;) {
					if(table[*start]<0)
						start-=searchlen;
					else  {
						if((bij=table[*start])) 
							start-=bij;
						else {
							if(!strncasecmp(searchstr,start--,searchlen)) {
								searchpos=bl*BLOCKSIZE+(start-vorig+1);
								return searchpos--;
								}
							}

						}
					}
		}
	hierin=max(1,searchlen-hierin);

        for(bl-- ;(bl>=0&&(huidig=buf[bl&1],((count=getblock(bl,huidig))>0)));bl--,vorig=huidig) {
		for(start=huidig+BLOCKSIZE;hierin<searchlen;) {
			if(table[*(start-hierin)]<0)
				hierin+=searchlen;
			else  {
				if((bij=table[*(start-hierin)])) 
					hierin+=bij;
				else {
					if(!(strncasecmp(searchstr+hierin,vorig,(searchlen-hierin))||strncasecmp(searchstr,start-hierin,hierin))) {
									searchpos=bl*BLOCKSIZE+BLOCKSIZE-hierin;
									return searchpos--;
									}
					hierin++;
					}
				}
			}
		start-=hierin;
		hierin=1;

                for(;start>=huidig;) {
					if(table[*start]<0)
						start-=searchlen;
					else  {
						if((bij=table[*start])) 
							start-=bij;
						else {
							if(!strncasecmp(searchstr,start--,searchlen)) {
								searchpos=bl*BLOCKSIZE+(start-huidig+1);
								return searchpos--;
								}
							}

						}

                                }

		}
	return ULONG_MAX;
	}



#ifdef TEST
#include "basic.h"
int main(int argc, char **argv) {
#define MAXBUF 0xffff
	int pos,len;
	char buf[MAXBUF];
	char command[256]="cat   /tmp/memoryXXXXXX",*hierfile=command+6;
	if(argc!=2) {
		fprintf(stderr,"Gebruik: %s filename\n",argv[0]);
		exit(1);
		}
	Memory mem(argv[1]);

	if(mem.error())	{
		fprintf(stderr,"%s: error \n",argv[0]);
		exit(2);
		}
	printf("size=%d\n",mem.size());
	puts("Give filepostition and lenght (pos len)");
	while(gets(buf)) {
		if(buf[0]=='q')
			break;
		if((sscanf(buf,"%d %d",&pos,&len)<2)||len>MAXBUF)
			continue;
		int handle,newlen;
		newlen=mem.getpart(pos,len,buf);
		strcpy(hierfile+11,"XXXXXX");
		if(!(mktemp(hierfile)))
			fatal("tmpnam(/tmp/memory) fails\n");
		puts(hierfile);
		if((handle=creat(hierfile,0600))<0)
			fatal("creat(%s)\n",hierfile);
		write(handle,buf,newlen);
		close(handle);
		system(command);
		if((handle=open(hierfile,O_RDONLY))<0)
			fatal("Can't open %s for readonly\n",hierfile);
		read(handle,buf,newlen);
		close(handle);
		len=mem.putpart(pos,len,buf);
		puts("Give filepostition and lenght (pos len)");
		}
	mem.tree.showtree();
	puts("Save file (j/n)");
	gets(buf);
	if(buf[0]=='j') {
		mem.saveall();
		puts("Saved");
		}
	mem.tree.showtree();
	return 0;
	}
#endif
