
#include <stdlib.h>
#include <curses.h>
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>

#include <signal.h>

void reset_screen(void) {
	   nocbreak();
	echo();
	endwin();
    }
void initscreen(void) {
	initscr();
	atexit(reset_screen);
//	clearok(stdscr,FALSE);
//	clearok(curscr,FALSE);
	raw();
	meta(stdscr,TRUE);
	cbreak();
	nonl();
	noecho();
	scrollok(stdscr,1);
	refresh();
	}
int ggetch(WINDOW *w) {
	static int ch=0;
	int key;
	if(ch) {
		if(ch==27) {
			ch=0;
				if((key=wgetch(w))== (-1) )
					key= 254 ;
			}
		else {
			key=ch;
			ch=0;
			}
		}
	else {
			if((key=wgetch(w))&0x80) {
				if(key==ERR) {
					return key;
					}
				ch=key&0x7f;
				return 27;
				}
			else
				if(key==27)
					ch=27;
		}
	return key;
	}
#define ggetch() ggetch(stdscr)
int getkeys(int *keys) {
	int i;
	nocbreak();
	cbreak();
	keys[0]=ggetch();
	halfdelay(2);
	for(i=1;;i++) {
		if((keys[i]=ggetch())==ERR) {
			return i;
			}
		}
	}

struct keydef {
	char *name;
	char *proc;
	};
#define elk(x,y,z) ((struct keydef) {y,#z})
#define sym(x) (struct keydef) {x,x}
struct keydef to[]={
	sym("home"), sym("end"), sym("up"), sym("down"), sym("left"), sym("right"), sym("pgup"), sym("pgdn"), sym("stab"), sym("delete"), sym("backspace"), sym("esc") ,
	elk("~Save","F2",dosave),
	elk( "~Nextsearch","F3",nextsearch), 
	elk("~Prev","F5",prevfile),  
	elk("~Next","F6",nextfile), 
	elk("A~dd Prev","S-F5",addprev), 
	elk("~Add Next","S-F6",addnext),
	elk("~Prev","F7",prevmode), 
	elk("~Next","F8",nextmode), 
	elk("Beg~in Pg","F9",beginpage),
	elk("~Begin file", "S-F9",beginfile),
	elk("En~d Pg","F10",endpage),
	elk("~End file", "S-F10",endfile),
	elk("~Select","F12",setselect), 
//	elk( "Ne~xt Mark","Tab",nextmark), 
	elk("P~revious Mark","M-Tab",prevmark)
	};
int total=sizeof(to)/sizeof(struct keydef);
void main(int argc,char **argv) {
	int keys[40];
	int nr,j,i;
	FILE *fp;
	initscreen();
	if(argc>1&& (fp=fopen(argv[1],"a"))) {
	printw("We are going to find out what keycodes you keys have to put it in ~/.bedrc\n");
		for(i=0;i<total;i++)	{
			printw("Press %s\n",to[i].name);
			nr=getkeys(keys);
			fprintf(fp,"keys ");
			for(j=0;j<nr;j++)
				fprintf(fp," %d",keys[j]);
			fprintf(fp," = %s\n",to[i].proc);
		}
		fclose(fp);
		move(LINES-3,0);
		printw("Keys appended to %s",argv[1]);
		}
	else
		{
	printw("We are going to find out what keycodes you keys have to put it in ~/.bedrc\n");
		for(i=0;i<total;i++)	{
			printw("Press %s\n",to[i].name);
			nr=getkeys(keys);
			printw("keys ");
			for(j=0;j<nr;j++)
				printw(" %d",keys[j]);
			printw(" = %s\n",to[i].proc);
			refresh();
		}
		move(LINES-3,0);
		};
	}
