#include <stdlib.h>
#include <curses.h>
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>

#include <signal.h>

void reset_screen(void) {
	   nocbreak();
	echo();
	endwin();
    }
void initscreen(void) {
	close(STDOUT_FILENO);
	initscr();
	atexit(reset_screen);
	clearok(stdscr,FALSE);
	clearok(curscr,FALSE);
	raw();
	meta(stdscr,TRUE);
	cbreak();
	nonl();
	noecho();
	scrollok(stdscr,1);
	refresh();
	}

int ggetch(WINDOW *w) {
	static int ch=0;
	int key;
	if(ch) {
		if(ch==27) {
			ch=0;
				if((key=wgetch(w))== (-1) )
					key= 254 ;
			}
		else {
			key=ch;
			ch=0;
			}
		}
	else {
			if((key=wgetch(w))&0x80) {
				if(key==ERR)
					return key;
				ch=key&0x7f;
				return 27;
				}
			else
				if(key==27)
					ch=27;
		}
	return key;
	}

#define ggetch() ggetch(stdscr)
int getkeys(int *keys) {
	int i;
	keys[0]=ggetch();
	halfdelay(2);
	for(i=1;;i++) {
		if((keys[i]=ggetch())==ERR)
			return i;
		}
	}
void main(int argc,char **argv) {
	int keys[40];
	int nr,j;
	FILE *fp;
	if(argc<2) {
		printf("Use: %s bedprocedure [file]\n",argv[0]);
		printf("It makes a key to bind a key to bedprocedure to put in ~/.bedrc\n");
		printf("You should type the key you want to bind to the procedure and the definition to put in ~/.bedrc\n");
		printf("is written to stderr or the file specified\n");
		exit(1);
		};
	initscreen();
	nr=getkeys(keys);
	reset_screen();
	if(argc>2&& (fp=fopen(argv[2],"a")))
		;
	else
		{
		fp=stderr;
		}
	fprintf(fp,"keys ");
	for(j=0;j<nr;j++)
		fprintf(fp," %d",keys[j]);
	fprintf(fp," = %s\n",argv[1]);
	}
