/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Arglists management
 */

#define EXPORTING
#include <config.h>
#include <nessuslib.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>


#define bzero(x,y) memset(x,0,y)



DllExport void 
arg_add_value(arglst, name, type, length, value)
  struct arglist * arglst;
  char * name;
  int type;
  long length;
  void * value;
{
	
	if(!arglst)return;
	
	/* Go to the end of our list... */
	while(arglst->next)arglst = arglst->next;

	arglst->name = emalloc(strlen(name)+1);
	
	strncpy(arglst->name, name, strlen(name));
	arglst->value = value;
	
	arglst->length = length;
	arglst->type = type;
	arglst->next = emalloc(sizeof(struct arglist));
	bzero(arglst->next, sizeof(struct arglist));
	arglst = arglst->next;
	arglst->next = NULL;
}

DllExport int 
arg_set_value(arglst, name, length, value)
 struct arglist * arglst;
 char * name;
 long length;
 void *value;
{
  /* We look for the asked name */
  while(arglst->next && strcmp(arglst->name, name))
    arglst = arglst->next;
  
  if(arglst->next)
    {
      arglst->value = value;
      return(0);
    }
  else return(-1); 
}

DllExport int 
arg_set_type(arglst, name, type)
 struct arglist * arglst;
 char * name;
 int type;
{
  while(arglst->next && strcmp(name, arglst->name))arglst=arglst->next;
  if(!(arglst->next))return(-1);
  else arglst->type = type;
  return 0;
}
  
DllExport void * 
arg_get_value(args, name)
 struct arglist * args;
 char * name;
{
 int flag=0;
 if(!args)return(NULL); 
  while(args && args->next && !flag)
  	{
        if(args->name && !strcmp(name, args->name))flag=1;
  	else args=args->next;
  	}
  if(flag && args && args->next)return(args->value);
  else return(NULL);
}


DllExport int 
arg_get_type(args,name)
 struct arglist * args;
 char * name;
{
  while(args->next && strcmp(name, args->name))args=args->next;
  if(args->next)
    return(args->type);
  else return(-1);
}


DllExport void 
arg_dump(file, args, level)
 FILE * file;
 struct arglist * args;
 int level;
{
	char * spaces = "--------------------";
	if(!args)
	{
		printf("Error ! args == NULL\n");
		return;
	}
	

	if(!file)return;
	while(args && args->next)
	{
		switch(args->type)
		{
			case ARG_STRING :
			
			fprintf(file, "%sargs->%s : %s\n",spaces+(20-level),
			args->name,
			(char *)args->value);
			break;
			case ARG_ARGLIST :
			
			fprintf(file, "%sargs->%s :\n", spaces+(20-level),
			args->name);
			arg_dump(file, args->value, level+1);
			break;
			case ARG_INT :
			fprintf(file, "%sargs->%s : %d\n",spaces+(20-level),
			args->name,
			(int)args->value);
			break;
			default :
			fprintf(file, "%sargs->%s : %d\n",spaces+(20-level),
			args->name,
			(int)args->value);
			break;
		}
		args = args->next;
	}
}
			
