/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Network Functions
 */ 

#define EXPORTING

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>

#include <winsock2.h>

#define bzero(x,y) memset(x,0,y)

#ifdef HAVE_SSL
#include <ssl.h>
#endif

#include <nessuslib.h>
#include "network.h"

#define TIMEOUT 10
#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

struct in_addr nn_resolve (char *); 
 
DllExport int 
open_sock_opt_hn(hostname, port, type, protocol)
 char * hostname; 
 unsigned int port; 
 int type;
 int protocol;
{
 struct sockaddr_in addr;
 int soc;
  
  bzero((void*)&addr, sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_port=htons((u_short)port);
  addr.sin_addr = nn_resolve(hostname);
  if (addr.sin_addr.s_addr == INADDR_NONE || addr.sin_addr.s_addr == 0)
    return(-1);
    
  if ((soc = socket(AF_INET, type, protocol)) < 0)
    return -1;
    
  
  if (connect(soc, (struct sockaddr*)&addr, sizeof(addr)) < 0)
    {
      shutdown(soc, 2);
	  closesocket(soc);
     
      return  -1;
    }
  
  return soc;
}


DllExport int 
open_sock_tcp_hn(hostname, port)
 char * hostname;
 unsigned int port;
{
  return(open_sock_opt_hn(hostname, port, SOCK_STREAM, IPPROTO_TCP));
}



DllExport int 
open_sock_tcp(args, port)
 struct arglist * args; 
 unsigned int port;
{
	return(open_sock_option(args, port, SOCK_STREAM,IPPROTO_TCP));
}

DllExport int open_sock_udp(args, port)
 struct arglist * args;
 unsigned int port;
{
	return(open_sock_option(args, port, SOCK_DGRAM, IPPROTO_UDP));
}

DllExport int open_sock_option(args, port, type, protocol)
 struct arglist * args;
 unsigned int port;
 int type;
 int protocol;
{
  struct sockaddr_in addr;
  struct in_addr * t=NULL;
  int soc;
  
  bzero((void*)&addr, sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_port=htons((u_short)port);
  t = plug_get_host_ip(args);
  if(!t)
  {
   fprintf(stderr, "ERROR ! NO ADDRESS ASSOCIATED WITH NAME\n");
   arg_dump(NULL, args, 0);
   return(-1);
  }
  addr.sin_addr = *t;
  if (addr.sin_addr.s_addr == INADDR_NONE)
    return(-1);
    
  if ((soc = socket(AF_INET, type, protocol)) < 0)
    return -1;
    
  if (connect(soc, (struct sockaddr*)&addr, sizeof(addr)) < 0)
    {
      closesocket(soc);

      return  -1;
    }

  return soc;
}



DllExport short 
is_cgi_installed(data, cgi_name)
 struct arglist * data;
 char * cgi_name;
{
  char * command = emalloc(200);
  short soc=-1;
  short i=0;
  char * buff = emalloc(256);
  
  sprintf(command, "GET /cgi-bin/%s HTTP/1.0\nhostname: %s\n\n",
	  cgi_name,  plug_get_hostname(data));
	  
  soc = open_sock_tcp(data, 80);
  if(soc <0)return(0); /* couldn't open a connection */
  send(soc, command, strlen(command), 0);
  recv(soc, buff, 255,0);
  efree(&command);
  closesocket(soc);
 
  if(strstr(buff, "HTTP/1.0 200 ") || strstr(buff, "HTTP/1.1 200 "))i=1; /* No error */
  else i=0; /* Error */
  
  efree(&buff);
  return(i);
}


DllExport void 
recv_line(soc, buf, maxlen)
 int soc;
 char * buf;
 int maxlen;
{
 int i = 0;
 char c;
 int ok = 0;
 
 bzero(buf, maxlen);
 while(!ok)
 {
  recv(soc, &c, 1, 0);
  buf[i++] = c;
  if(!c || (c=='\n') || (i>=maxlen))ok=1;
 }
} 




