/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Plugutils -- plugin-specific stuff
 */

#define EXPORTING

#include "config.h"
#include "nessuslib.h"
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <winsock2.h>




		
DllExport void 
plug_set_family(desc, family)
 struct arglist * desc; 
 char * family;
{
  char * s = emalloc(strlen(family)+1);
  strncpy(s, family, strlen(family));
  arg_add_value(desc, "FAMILY", ARG_STRING, strlen(family), family);
}

DllExport char * 
plug_get_family(desc)
 struct arglist * desc;
{
 return(arg_get_value(desc, "FAMILY"));
}
		
DllExport void 
plug_set_launch(desc, launch)
 struct arglist * desc;
 int launch;
{
  if(arg_set_value(desc, "ENABLED", sizeof(int), (void *)launch))
  {
   arg_add_value(desc, "ENABLED", ARG_INT, sizeof(int), (void *)launch);
  }
}

DllExport int 
plug_get_launch(desc)
 struct arglist * desc;
{
 return((int)arg_get_value(desc, "ENABLED"));
}	
	
DllExport void 
plug_set_name(desc, name)
 struct arglist * desc; 
 char * name; 
{	
  char * pname;
  if(!name)return;
  pname = emalloc(strlen(name)+1);
  strncpy(pname, name, strlen(name));
  arg_add_value(desc, "NAME", ARG_STRING, strlen(name), pname);
}

DllExport void 
plug_set_summary(desc, summary)
 struct arglist * desc;
 char * summary;
{
  char * psummary;
  
  if(!summary)return;
  psummary = emalloc(strlen(summary)+1);
  strncpy(psummary, summary, strlen(summary));
  arg_add_value(desc, "SUMMARY", ARG_STRING, strlen(summary), psummary);
}


DllExport void 
plug_set_description(desc, description)
 struct arglist * desc;
 char * description;
{
  char * pdescription;
  if(!description)return;
  pdescription = emalloc(strlen(description)+1);
  strncpy(pdescription, description, strlen(description));
  arg_add_value(desc, "DESCRIPTION", ARG_STRING, strlen(pdescription), pdescription);
}

DllExport void 
plug_set_copyright(desc, copyright)
 struct arglist * desc;
 char * copyright;
{
	char * pcopyright;
	if(!copyright)return;
	pcopyright = emalloc(strlen(copyright)+1);
	strncpy(pcopyright, copyright, strlen(copyright));
	arg_add_value(desc, "COPYRIGHT", ARG_STRING, strlen(pcopyright), pcopyright);
}

DllExport void 
plug_set_category(desc, category)
 struct arglist * desc;
 int category;
{
       arg_add_value(desc, "CATEGORY", ARG_INT, sizeof(int), (void *)category);
}


DllExport void 
plug_set_attacklevel(desc, attacklevel)
 struct arglist * desc;
 int attacklevel;
{
	arg_add_value(desc, "ATTACKLEVEL", ARG_INT, sizeof(int), (void *)attacklevel);
}



DllExport void 
plug_add_host(desc, hostname)
 struct arglist * desc;
 struct arglist * hostname;
{
	struct arglist * h;
	
	h = arg_get_value(desc, "HOSTNAME");
	if(!h)arg_add_value(desc, "HOSTNAME", ARG_ARGLIST, sizeof(hostname), hostname);
	else arg_set_value(desc, "HOSTNAME", sizeof(hostname), hostname);
}



DllExport void 
host_add_port(hostdata, portnum, state, banner)
 struct arglist * hostdata;
 int portnum;
 int state;
 char * banner;
{
 struct arglist * port ;
 struct arglist * portlist;
 char * port_s = emalloc(8);
 char * l_banner = emalloc(banner ? strlen(banner)+1:0);
 sprintf(port_s, "%d", portnum);
 
 if(banner)strncpy(l_banner, banner, strlen(banner));
 port = emalloc(sizeof(struct arglist));
 if(hostdata)
 	 portlist = arg_get_value(hostdata, "PORTS");
 else return;
 if(!portlist)
 {
#ifdef DEBUGMORE
  printf("!portlist\n");
  printf("allocating a new one...");
#endif
  portlist = emalloc(sizeof(struct arglist));
  arg_add_value(hostdata, "PORTS", ARG_ARGLIST, sizeof(portlist), portlist);
#ifdef DEBUGMORE
  printf("Done!\n");
#endif
 }

 arg_add_value(port, "STATE", ARG_INT, sizeof(int), (void *)state);
 arg_add_value(port, "BANNER", ARG_STRING, banner ? strlen(l_banner):0, l_banner);
 arg_add_value(portlist, port_s, ARG_ARGLIST, sizeof(port), port);
#ifdef DEBUGMORE
 printf("Port added for %s\n", (char *)arg_get_value(hostdata, "FQDN"));
#endif
}

DllExport int 
host_get_port_state(plugdata, portnum)
 struct arglist * plugdata;
 int portnum;
{ 
 struct arglist * hostdata = arg_get_value(plugdata, "HOSTNAME");
 struct arglist * ports;
 struct arglist * port;
 char * port_s;
 int * range;
 int i,flag;
 
 /* Check that we actually scanned the port */
 if(!arg_get_value(hostdata, "scanned"))return(1);
 range = arg_get_value(hostdata, "SCAN_RANGE");
 if(!range)return(1);
 for(i=0,flag=0;((range[i])&&(!flag));i++)
 	if(range[i]==portnum)flag=1;
 if(!flag)return(1);
 
 /* Ok, we scanned it. What is its state ? */
 port_s = emalloc(8);
 
 sprintf(port_s, "%d", portnum);
 if(!hostdata)return(0);
 ports = arg_get_value(hostdata, "PORTS");
 if(!ports)return(0);
 port = arg_get_value(ports, port_s);
 if(!port)return(0);
 return((int)arg_get_value(port, "STATE"));
}


DllExport char * 
host_get_port_banner(plugdata, portnum)
 struct arglist * plugdata;
 int portnum;
{
  struct arglist * hostdata = arg_get_value(plugdata, "HOSTNAME");
  struct arglist * ports;
  struct arglist * port;
  char * port_s = emalloc(8);
  
  sprintf(port_s, "%d", portnum);
  if(!hostdata)return(NULL);
  ports = arg_get_value(hostdata, "PORTS");
  if(!ports)return(NULL);
  port = arg_get_value(ports, port_s);
  if(!port)return(NULL);
  return((char *)arg_get_value(port, "BANNER"));
}


DllExport char * 
plug_get_hostname(desc)
 struct arglist * desc;
{
 struct arglist * hinfos = arg_get_value(desc, "HOSTNAME");
 if(hinfos)return((char*)arg_get_value(hinfos, "FQDN"));
 else return(NULL);
}

DllExport struct in_addr * 
plug_get_host_ip(desc)
 struct arglist * desc;
{
 struct arglist * hinfos = arg_get_value(desc, "HOSTNAME");
 if(hinfos)return((struct in_addr*)arg_get_value(hinfos, "IP"));
 else return(NULL);
}


DllExport void 
post_hole(desc, port, action)
 struct arglist * desc;
 int port;
 char * action;
{

 char * naction;
 char *t;
 char * buffer;
 int socket;
 struct arglist * hostdata;
 
 hostdata = arg_get_value(desc, "HOSTNAME");
 if(!action)return;
 naction = emalloc(strlen(action)+1);
 strncpy(naction, action, strlen(action));
 while((t=strchr(naction, '\n')))t[0]=';';
 buffer=emalloc(255+strlen(naction));
 sprintf(buffer, "SERVER <|> HOLE <|> %s <|> %d:%s <|> SERVER\n", 
 	(char *)arg_get_value(hostdata, "FQDN"), port, naction);
 socket = (int)arg_get_value(desc, "SOCKET");
 send(socket, buffer, strlen(buffer), 0);
 efree(&buffer);
 fflush(stdout);
 efree(&naction);
 return;
} 


DllExport void 
post_info(desc, port, action)
 struct arglist * desc;
 int port;
 char * action;
{
 char * naction,*t;
 struct arglist * hostdata;
 int socket;
 char * buffer;
 
 hostdata = arg_get_value(desc, "HOSTNAME");
 if(!action)return;
 
 naction = emalloc(strlen(action)+1);
 strncpy(naction, action, strlen(action));
 while((t=strchr(naction, '\n')))t[0]=';';
 buffer = emalloc(255+strlen(naction));
 sprintf(buffer,"SERVER <|> INFO <|> %s <|> %d:%s <|> SERVER\n", 
 	(char *)arg_get_value(hostdata, "FQDN"), port, naction);
 socket = (int)arg_get_value(desc, "SOCKET");
 send(socket, buffer, strlen(buffer),0);
 efree(&buffer);
 fflush(stdout);
 efree(&naction);
 return;
} 

DllExport void 
l_post_hole(desc, port, action)
 struct arglist * desc;
 int port;
 char * action;
{
 struct arglist * ports;
 struct arglist * pport;
 struct arglist * report;
 char * sport = emalloc(20);
 char * comm;
 char * name = "General";
 
 if(!action)return;
 comm = emalloc(strlen(action)+1);
 strncpy(comm, action, strlen(action));
 
 ports = arg_get_value(desc, "PORTS");
 if(!ports)
 {
  ports = emalloc(sizeof(struct arglist));
  arg_add_value(desc, "PORTS", ARG_ARGLIST, -1, ports);
 }
 if(port !=-1)
 {
 sprintf(sport, "%d", port);
 pport = arg_get_value(ports, sport);
 }
 else pport = arg_get_value(ports, name);

 if(!pport){
 	pport = emalloc(sizeof(struct arglist));
	if(port == -1)
 	arg_add_value(ports, name, ARG_ARGLIST, -1, pport);
	else arg_add_value(ports, sport, ARG_ARGLIST, -1, pport);
 	arg_add_value(pport, "STATE", ARG_INT, sizeof(int),(void *)1);
 	}
 efree(&sport);
 report = arg_get_value(pport, "REPORT");
 if(!report)
 {
  report = emalloc(sizeof(struct arglist));
  arg_add_value(pport, "REPORT", ARG_ARGLIST, -1, report);
 }
 while(report && report->next)report = report->next;
 arg_add_value(report, "HOLE", ARG_STRING, strlen(comm), comm);
 
 return;
} 




DllExport void 
l_post_info(desc, port, action)
 struct arglist * desc;
 int port;
 char * action;
{
 struct arglist * ports;
 struct arglist * pport;
 struct arglist * report;
 char * sport = emalloc(20);
 char * comm;
 char * name = "General";
 
 if(!action)return;
 comm = emalloc(strlen(action)+1);
 strncpy(comm, action, strlen(action));
 
 ports = arg_get_value(desc, "PORTS");
 if(!ports)
 {
  ports = emalloc(sizeof(struct arglist));
  arg_add_value(desc, "PORTS", ARG_ARGLIST, -1, ports);
 }
 if(port !=-1)
 {
 sprintf(sport, "%d", port);
 pport = arg_get_value(ports, sport);
 }
 else pport = arg_get_value(ports, name);
 if(!pport){
 	pport = emalloc(sizeof(struct arglist));
	if(port == -1)
 	arg_add_value(ports, name, ARG_ARGLIST, -1, pport);
	else arg_add_value(ports, sport, ARG_ARGLIST, -1, pport);
 	arg_add_value(pport, "STATE", ARG_INT, sizeof(int),(void *)1);
 	}
 efree(&sport);
 report = arg_get_value(pport, "INFO");
 if(!report)
 {
  report = emalloc(sizeof(struct arglist));
  arg_add_value(pport, "INFO", ARG_ARGLIST, -1, report);
 }
 while(report && report->next)report = report->next;
 arg_add_value(report, "INFO", ARG_STRING, strlen(comm), comm);
 
 return;
} 
 
DllExport char * 
get_preference(desc, name)
 struct arglist *desc;
 char * name;
{
 struct arglist * prefs = arg_get_value(desc, "preferences");
 if(!prefs)return(NULL);
 return((char *)arg_get_value(prefs, name));
}


DllExport void 
plugin_error(desc, err)
 struct arglist * desc;
 char * err;
{
 printf("SERVER <|> PLUGIN_ERROR <|> %s : %s <|> SERVER\n", 
 	(char*)arg_get_value(desc,"NAME"),err);
}
