/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Hostname resolver.
 */

#define EXPORTING

#include "config.h"
#include "nessuslib.h"
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <sys/types.h>
#include "resolve.h"

#include <stdio.h>
#include <string.h>

#define bzero(x,y) memset(x,0,y)
#ifndef __u32
#define __u32 unsigned long
#endif

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

struct _nn_resolve_cache_t
{
  __u32 address;
  char *hostname;
  struct _nn_resolve_cache_t * next;
};

struct _nn_resolve_cache_t * _nn_cache = NULL;

DllExport struct in_addr nn_resolve (char * hostname)
{
  struct in_addr in;
  struct hostent *ent;
  unsigned long ip;
  struct _nn_resolve_cache_t * l_cache;
  unsigned int i;
 
  in.s_addr = 0;
  
  if(_nn_cache)
    {
      l_cache = _nn_cache;
      while(l_cache)
	{
		  for(i=0;i<strlen(l_cache->hostname);i++)
			  l_cache->hostname[i] = tolower(l_cache->hostname[i]);

		  
      	  if(l_cache->hostname &&
	     (!strcmp(hostname,l_cache->hostname)))
	    {
	      in.s_addr = l_cache->address;
	      return(in);
	    }
	  else l_cache = l_cache->next;
	}
    }
  
  if(!in.s_addr)
    {
      if ((ip = inet_addr(hostname)) != INADDR_NONE)
	{
	  in.s_addr = ip;
	  _nn_resolve_add_cache(hostname, in);
	}
      else
	{
	  ent = gethostbyname(hostname);
	  if (ent)
	    { 
	      in = *(struct in_addr *)ent->h_addr;
	      if(in.s_addr != 0)_nn_resolve_add_cache(hostname, in);
	    }
	  else in.s_addr = 0;
	}
    }
  return in;
}

DllExport int _nn_resolve_add_cache (char *human, struct in_addr in)
{
 struct _nn_resolve_cache_t * l_cache = _nn_cache;
 if(!_nn_cache)
   {
     _nn_cache = malloc(sizeof(struct _nn_resolve_cache_t));
     if(!_nn_cache)return(-1);
     bzero(_nn_cache, sizeof(struct _nn_resolve_cache_t));
     
     _nn_cache->hostname = malloc(strlen(human)+1);
     bzero(_nn_cache->hostname, strlen(human)+1);
     if(!_nn_cache->hostname)return(-1);
     strncpy(_nn_cache->hostname, human, strlen(human));
     _nn_cache->address = in.s_addr;
     _nn_cache->next = NULL;
   }
 else
   {
     while(l_cache->next)l_cache = l_cache->next;
     l_cache->next = malloc(sizeof(struct _nn_resolve_cache_t));
     if(!l_cache->next)return(-1);
     bzero(l_cache->next, sizeof(struct _nn_resolve_cache_t));
     
     l_cache = l_cache->next;
     l_cache->hostname = malloc(strlen(human)+1);
     if(!l_cache->hostname)return(-1);
     bzero(l_cache->hostname, strlen(human)+1);
     
     strncpy(l_cache->hostname, human, strlen(human));
     l_cache->address = in.s_addr;
     l_cache->next = NULL;
   }
 return 0;
}
