/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Attack.c : 
 *  launch the plugins, and manages the multithreading 
 *
 */
 
#include <windows.h>
#include <process.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>

#include "config.h"
#include "nessuslib.h"
#include "attack.h"
#include "log.h"
#include "hostloop.h"
#include "sighand.h"
#include "rules.h"
#include "auth.h"
#include "threads.h"
#include "comm.h" 
#include "wstuff.h"

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

extern int scanner_main(struct arglist *, char *);
extern struct arglist * plugins;
extern struct arglist * preferences;
extern struct nessusd_threads *nessusd_threads; 
extern HWND main_window;
int attack_num_daemons;
DWORD current_plugin;
extern DWORD TLSSockets;
extern FILE * logfile;

struct attack_host_data {
	struct arglist * hostinfos;
	struct arglist * plugins;
	char * hostname;
	SOCKET * socket;
	char * port_range;
};

void plugin_thread(struct arglist *);



/*
 * Setup an arglist from a given hostname
 */
struct arglist * 
attack_init_hostinfos(hostname)
     char * hostname;
{
  struct arglist * hostinfos;
  struct arglist * ports;
  struct in_addr *p_addr;
  
  p_addr = emalloc(sizeof(struct in_addr));
  *p_addr = nn_resolve(hostname);
  if((p_addr->s_addr == INADDR_NONE) || (p_addr->s_addr == INADDR_ANY))
    {
      efree(&p_addr);
      return(NULL);
    }
  hostinfos = emalloc(sizeof(struct arglist));
  arg_add_value(hostinfos, "FQDN", ARG_STRING, strlen(hostname), hostname);
  arg_add_value(hostinfos, "IP", ARG_PTR, sizeof(struct in_addr), p_addr);
  ports = emalloc(sizeof(struct arglist));
  arg_add_value(hostinfos, "PORTS", ARG_ARGLIST, sizeof(struct arglist), ports);
  return(hostinfos);
}


/*
 * Add the informations about a host in a plugin arglist
 */
int 
attack_add_hostinfos(plugin, hostinfos)
     struct arglist *  plugin;
     struct arglist *  hostinfos;
{
  struct arglist * args;
  struct arglist * t;
  
  args = arg_get_value(plugin->value, "plugin_args");
  if(!args)
    {
#ifdef DEBUG
      log_write("error : a plugin has no \"plugin_args\" value !\n");
      log_write("dumping arglist\n");
      arg_dump(logfile, plugin->value, 0);
#endif
      return(-1);
    }
  
  t = arg_get_value(args, "HOSTNAME");
  if(t)arg_set_value(args, "HOSTNAME", sizeof(struct arglist), hostinfos);
  else arg_add_value(args, "HOSTNAME", ARG_ARGLIST, sizeof(struct arglist), hostinfos);
  return(0);
}


void
plugin_thread(pluginfos)
	struct arglist * pluginfos;
{
  plugin_run_t f_run;
  struct arglist * args;
  DWORD socket;
  HMODULE ptr = NULL;

  args = arg_get_value(pluginfos, "plugin_args");
  ptr = LoadLibrary(arg_get_value(pluginfos, "full_name"));
  if(!ptr)print_error("Could not load %s", (char *)arg_get_value(pluginfos, "full_name"));
  else {
    f_run = (plugin_run_t)GetProcAddress(ptr, "plugin_run");
    socket = (SOCKET) arg_get_value(args, "SOCKET");
    TlsSetValue(TLSSockets, &socket);
    (*f_run)(args);
	FreeLibrary(ptr);
  }
 ExitThread(0);
}




/*
 * This function attacks *one* host
 */
void 
attack_host_thread(args)
     struct attack_host_data * args;
{ 
  int num_plugs = 0;
  int cur_plug = 1;
  struct arglist * t;
  
  if(!args)return;
  TlsSetValue(TLSSockets, args->socket);
  t = args->plugins;
  while(t && t->next)
  { 
  if(plug_get_launch(t->value))num_plugs++;
   t = t->next;
  }
  t = args->plugins;
  scanner_main(args->hostinfos, args->port_range);
  while(t && t->next)
    {
	  HANDLE thread;
#ifdef LOGMORE
	  struct in_addr * ip;
#endif
      if(plug_get_launch(t->value))
       {
        if(attack_add_hostinfos(t, args->hostinfos))
			continue;
#ifdef DEBUG
      print_error("Launching %s\n", plugins->name);
#endif


#ifdef LOGMORE
	  ip = (struct in_addr *)arg_get_value(args->hostinfos, "IP");
      log_write("launching %s against %s (%s)\n", t->name,
      	args->hostname, inet_ntoa(*ip));
#endif
      comm_send_status(args->hostname, cur_plug, num_plugs);
      cur_plug++;
      thread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)plugin_thread, 
		  (void *)t->value,
		  0, &current_plugin);

	  if((WaitForSingleObject(thread, PLUGIN_TIMEOUT*1000))==WAIT_TIMEOUT)
	  {
		  log_write("Current plugin is slow to finish -- killing it");
		TerminateThread(thread, 0);
	  }
      }
      t = t->next;
    }
  ExitThread(0);
}


/*
 * This is the main function for attacking
 * a network
 */
int 
attack_host(hostname, port_range,max_hosts)
     char * hostname;
     char * port_range;
     int max_hosts;
{
  struct arglist * hostinfos;
  int max_threads;
  struct arglist * lplugs = plugins;
  struct arglist * plugs;
  struct arglist * tplugs;
  int i;
  int num_tested = 0;
  struct nessusd_threads * t;
  int flag;
  int on = 1;
  SOCKET *socket = (SOCKET*)TlsGetValue(TLSSockets);
   

  tplugs = plugs = emalloc(sizeof(struct arglist));
  
  /*
   * Make our socket async
   * The dumb Win32 API sends an async message to
   * a WINDOW ! This is total nonsense ! (anyway,
   * we got to deal with this).
   */
   WSAAsyncSelect(*socket, main_window, ASYNC_MESSAGE, FD_READ);


  /*
   * Put the plugins in the right order 
   */
  for(i=ACT_GATHER_INFO;i<=ACT_DENIAL;i++)
  {
  while(lplugs && lplugs->next)
  {
   struct arglist * args;
   
   args = arg_get_value(lplugs->value, "plugin_args");
   if(args && ((int)arg_get_value(args, "CATEGORY")==i))
   {
   tplugs->value = lplugs->value;
   tplugs->name = lplugs->name;
   tplugs->type = lplugs->type;
   tplugs->length = lplugs->length;
   tplugs->next = emalloc(sizeof(struct arglist));
   tplugs = tplugs->next;
   }
   lplugs = lplugs->next;
  }
  lplugs = plugins;
 } 
 
 log_write("new attack against %s\n", hostname);
 
 if(arg_get_value(preferences, "max_threads"))
    {
      max_threads = atoi(arg_get_value(preferences, "max_threads"));
      if(max_threads<=0)
	{
	  log_write("Error ! max_threads = %d -- check "NESSUSD_CONF"\n", 
		    max_threads);
	  max_threads = 1;
	}
    }
  else max_threads = 5;
  
  attack_num_daemons = 0;
  /*
   * Initialize the hostloop system (which is not as powerful under NT as it is
   * under Unix-like systems)
   */

  hls_new_session(hostname);
  while(hostname && num_tested != max_hosts)
    {
      flag = 0 ;
      if(pTEST(get_hostname_attributes(hostname)))
      {
       if(attack_num_daemons < max_threads)
	{
	      hostinfos = attack_init_hostinfos(hostname);
	      if(!hostinfos)
	        auth_printf("SERVER <|> ERROR <|> %s : host unknown <|> SERVER\n", 
	       		hostname);
	      else
		  {
			struct attack_host_data *args;
			HANDLE thread;
			DWORD id;

		    args = emalloc(sizeof(struct attack_host_data));
			args->hostinfos = hostinfos;
			args->plugins = plugs;
			args->hostname = hostname;
			args->port_range = port_range;
			args->socket = TlsGetValue(TLSSockets);
	       thread = CreateThread(NULL, 0, 
				(LPTHREAD_START_ROUTINE)attack_host_thread,
				args, 0, &id);
	        nessusd_thread_register(hostname, id, thread);
	  	    attack_num_daemons++;
	  	    log_write("testing %s\n", hostname);
		  } 
	}
      else 
      	{
      	flag = 1;
	while(attack_num_daemons >= max_threads)
	 {
	 struct nessusd_threads * t = nessusd_threads;
	 while(t && t->next)
	  {
	   if(t->up)
	   {
		   if((WaitForSingleObject(t->hThread, 250))!=WAIT_TIMEOUT)
		   {
			   nessusd_thread_unregister(t->pid);
			   attack_num_daemons--;
		   }
	   } 
	   t = t->next;
	 }
        }
       }
    }
      if(!flag){
        num_tested ++;
       	hostname = hls_get_next_host();
       	}
   }
  
   flag = 1;
   while(flag)
   {
    flag = 0;
    t = nessusd_threads;
    while(t && t->next)
    {
     if(t->up)
     {
      int status = 0;
	   
      flag = 1;
	  if((WaitForSingleObject(t->hThread, 250))!=WAIT_TIMEOUT)
		   {
			   t->up = 0;
			   attack_num_daemons--;
		   }
      }
      t = t->next;
    }
   }
   
  /*
   * Clean up some stuff in memory 
   */
  tplugs = plugs;
  while(tplugs)
  {
   tplugs = plugs->next;
   efree(&plugs);
   plugs = tplugs;
  }
  WSAAsyncSelect(*socket, main_window, 0, 0);
  return(0);
}
   
   
   
 
