/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Nessus Communication Manager -- it manages the NTP Protocol, version 1.0
 *
 */ 
 
#include "config.h"
#include "nessuslib.h"
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <string.h>
#include "auth.h"
#include "comm.h" 
#include "threads.h"
#include "sighand.h"
#ifdef HAVE_SSL
#include <ssl.h>
#endif

extern struct arglist * plugins;
#ifdef HAVE_SSL
extern SSL * con;
extern int using_nsp;
#endif
/*
 * Once we have a socket, we must initiate the
 * connection and setup the program
 */
void 
comm_init(soc)
     SOCKET soc;
{  

  char * buf = emalloc(20);
    
  recv_line(soc, buf, 20);
  if(strncmp(buf, "< NTP/1.0 >", 11))
  {
      shutdown(soc, 2);
      ExitThread(0);
   }
  
  if(!strncmp(buf, "< NTP/1.0 >", 11))
   {
    send(soc, "< NTP/1.0 >\n",12,0);
   }
  efree(&buf);
}


/*
 * This function must be called at the end
 * of a session
 */
void 
comm_terminate()
{
  char * buf = emalloc(200);
  auth_printf("SERVER <|> BYE <|> BYE <|> SERVER\n");
  auth_gets(buf, 199);
  efree(&buf);
}


/*
 * Sends the list of plugins that the server
 * could load to the client, using the 
 * NTP format
 */
void 
comm_send_pluginlist()
{
  struct arglist * l_plug = plugins;
  int i=1,j;
  char * categories[] = {"infos","attack","denial","unknown"};
  
  auth_printf("SERVER <|> PLUGIN_LIST <|>\n");
  while(l_plug && l_plug->next)
    {
      struct arglist * args;
      char * t;
      
      
      args = arg_get_value(l_plug->value, "plugin_args");
      t = arg_get_value(args, "DESCRIPTION");
      while((t=strchr(t,'\n')))t[0]=';';
      j = (int)arg_get_value(args, "CATEGORY");
      if((j>ACT_DENIAL) || (j<ACT_GATHER_INFO))j=4;
      auth_printf("%d <|> %s <|> %s <|> %s <|> %s <|> %s <|> %s\n", i, 
		  arg_get_value(args, "NAME"),
		  categories[j-1],
		  arg_get_value(args, "COPYRIGHT"),
		  arg_get_value(args, "DESCRIPTION"),
		  arg_get_value(args, "SUMMARY"),
		  plug_get_family(args));
      i++;
      l_plug = l_plug->next;
    }
  auth_printf("<|> SERVER\n");
}


/*
 * This function waits for the attack order
 * of the client
 */
char * 
comm_wait_order(max_hosts, port_range)
	int *max_hosts;
	char **port_range;
{
  char * str = emalloc(512);
  char * strs[8];
  int good=0;
  int i;
  char * hostname;
  while(!good)
    {
      auth_gets(str, 511);
      if(!strlen(str))continue;
#ifdef DEBUGMORE
      printf("Received : %s\n", str);
#endif
      for(i=0;i<8;i++)strs[i]=emalloc(strlen(str)+1);
      sscanf(str, "%s <|> %s <|> %s <|> %s <|> %s <|> %s <|> %s <|> %s",
	     strs[0],strs[1],strs[2],strs[3],strs[4],strs[5],strs[6],strs[7]);
      
#ifdef DEBUGMORE
      for(i=0;i<8;i++)
	{
	  printf("strs[%d] : %s\n", i, strs[i]);
	}
#endif
      if(!strncmp(strs[1], "QUIT", 4)){
    	shutdown(0,2);
    	ExitThread(0);
      }
      if(!strncmp(strs[0], "CLIENT", 6) && !strncmp(strs[1],"NEW_ATTACK",10) &&
	 !strncmp(strs[7], "CLIENT", 6))good = 1;

	  if(!good)for(i=0;i<8;i++)efree(&strs[i]);
    }
  *max_hosts = atoi(strs[3]);
  comm_setup_plugins(strs[2]);
  *port_range = emalloc(strlen(strs[5])+1);
  strncpy(*port_range, strs[5], strlen(strs[5]));
  
  hostname = emalloc(strlen(strs[6])+1);
  strncpy(hostname, strs[6], strlen(strs[6]));
  
  for(i=0;i<8;i++)efree(&strs[i]);
  efree(&str);
  return(hostname);
}


/* 
 * Marks the plugins that will be
 * launched, according to the list
 * provided by the client
 */
void 
comm_setup_plugins(id_list)
     char * id_list;
{
  char * list = id_list;
  char * buf;
  int id;
  int i = 0;
  int num_plugins=0;
  struct arglist * l_plugin;
  /* list = a string like '16;5;3' */
  
  l_plugin = plugins;
  while(l_plugin && l_plugin->next){
    num_plugins++;
    l_plugin = l_plugin->next;
  }
  buf = emalloc(strlen(id_list)+1);
  while(sscanf(list, "%d;%s", &id, buf) && strlen(list))
    {
      if(id==0)break;
      l_plugin = plugins;
      if(id<0)
 	{
	  struct arglist * lp = plugins;
	  while(lp && lp->next)
	    {
	      plug_set_launch(lp->value, 1);
	      lp = lp->next;
	    }
	  break;
 	}
      if(id>num_plugins)
	{
	  auth_printf("SERVER <|> ERROR <|> There's no plugin of id %d <|> SERVER\n", id);
	  l_plugin = NULL;
	}
      else for(i=1;i!=id;i++)
	{
	  l_plugin = l_plugin->next;
	}
      if(l_plugin)plug_set_launch(l_plugin->value, 1);
      sprintf(list, "%s", buf);
      bzero(buf, strlen(id_list)+1);
    }
}



void 
comm_send_status(hostname, current,max)
  char * hostname;
  int current, max;
{
 auth_printf("SERVER <|> STAT <|> %s <|> %d/%d <|> SERVER\n",
      		hostname, current, max);
}
