/* Hostloop -- the Hostloop Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This library is a messy copy of the Unix Hostloop library which is
 * far more powerful.
 *
 * Everything here is (c) 1998 Renaud Deraison <deraison@worldnet.fr>, except :
 *
 *
 */
 
 
 
/* Includes */
#include <config.h>
#include <nessuslib.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>

#include "hosts_loop.h"



struct hls_globals_t { 
 struct host_in_loop *hil;
 struct host_in_loop *c_hil;
 short num_hil;
 short cur_hil;
 struct domainlist_t * dml;
 };
 
struct hls_globals_t hls_globals;
	


/* Local function */
static short is_host_present(char *, struct host_in_loop * , short);
short is_host_tested(char * hostname, struct host_in_loop * hil, short num_hil);
static short is_host_present(char *hostname, struct host_in_loop * hil, short num_hil);
short is_domain_tested(char * domain, struct domainlist_t * dml);
static short is_ip_tested(char * hostname, struct host_in_loop * hil, 
             short num_hil);
/* void init_parses(void); */
int get_hostname_attributes(char * hostname);
void add_single_host(char * hostname, struct host_in_loop * hil, short *num_hil);



void add_single_host(char * hostname, struct host_in_loop * hil, short *num_hil)
{
	if(!is_host_present(hostname, hil, *num_hil))
	{
		struct in_addr addr;
		int i = *num_hil;
		while(hil->next)hil=hil->next;
		hil->next = malloc(sizeof(struct host_in_loop));
		bzero(hil->next, sizeof(struct host_in_loop));
		hil = hil->next;
		hil->hostname = emalloc(strlen(hostname)+1); 
		strncpy(hil->hostname, hostname, strlen(hostname));
	    addr = nn_resolve(hostname);

		hil->hostip = emalloc(strlen(inet_ntoa(addr))+1);
		bzero(hil->hostip, strlen(inet_ntoa(addr)+1));
		strncpy(hil->hostip, inet_ntoa(addr), strlen(inet_ntoa(addr)));
		hil->addr = addr;
		hil->id = (i);
		(*num_hil) = i+1;           
    }
}


void hls_new_session(char * hostname)
{
	char * p;

	hls_globals.hil = malloc(sizeof(struct host_in_loop));
	bzero(hls_globals.hil, sizeof(struct host_in_loop));
	hls_globals.c_hil = NULL;
	hls_globals.dml = NULL;
	p = strchr(hostname, ',');
	if(p)
	{
		p[0]=0;
		p+=sizeof(char);
	}


	hls_globals.hil->hostname = malloc(strlen(hostname)+1);
	bzero(hls_globals.hil->hostname, strlen(hostname)+1);
	sprintf(hls_globals.hil->hostname, "%s", hostname);
	hls_globals.hil->id = 0;
	hls_globals.hil->trusted_by = -1;
	hls_globals.hil->tested = 0;
	hls_globals.hil->next = NULL;
	hls_globals.hil->addr = nn_resolve(hostname);
	hls_globals.num_hil = 1;
	hls_globals.cur_hil = 0;
	hls_globals.dml = NULL;  
	hls_globals.c_hil = hls_globals.hil;
	if(p)
	{
		char * t;

		while(t = strchr(p, ','))
		{
			t[0] = 0;
			add_single_host(p, hls_globals.hil, &hls_globals.num_hil);
			p = t+sizeof(char);
		}
		if(p && strlen(p))add_single_host(p, hls_globals.hil, &hls_globals.num_hil);
	}
}




char * hls_get_next_host()
{

	struct domainlist_t *ldml = hls_globals.dml;
	hls_globals.c_hil = hls_globals.hil;
skip:
	hls_globals.cur_hil++;
	if(hls_globals.cur_hil <= hls_globals.num_hil)
	{
	while(hls_globals.c_hil && hls_globals.c_hil->id != hls_globals.cur_hil)
		hls_globals.c_hil = hls_globals.c_hil->next;
	}
	else hls_globals.c_hil = NULL;
	if(hls_globals.c_hil && 
	   is_host_tested(hls_globals.c_hil->hostname, 
	   hls_globals.hil, hls_globals.num_hil))
		goto skip;
	if(hls_globals.c_hil && 
		is_ip_tested(hls_globals.c_hil->hostname, 
		hls_globals.hil, hls_globals.num_hil))goto skip;
	if(hls_globals.c_hil)
		{
		hls_globals.c_hil->tested = 1;
		}
	return(hls_globals.c_hil ? hls_globals.c_hil->hostname:NULL);
}



/*   is_host_tested()

     Parameters :
     char * hostname : name of the host
     hil, num_hil : struct and number of items in struct

     Returns :
     1 if this host was tested
     0 if it was not
   
     This function determines wether a given host was already
     tested or not
*/

short is_host_tested(char * hostname, struct host_in_loop * hil, short num_hil)
{
  while(num_hil--)
    {
      if(!strcmp(hostname, hil->hostname) && hil->tested)return(1);
      else hil = hil->next;
    }
  
  return(0);
}
		
		
/* is_host_present()

   Same as is_host_tested but, returns :
   1 if the host is present in the hil structure or
   0 if it's not
*/

static short is_host_present(char *hostname, struct host_in_loop * hil, 
             short num_hil)
{	
  struct in_addr addr;
  
  addr = nn_resolve(hostname);
  
  while(num_hil--)
    {
      if(!strcmp(hostname, hil->hostname) ||
      	(addr.s_addr == hil->addr.s_addr))return(1);
      else hil = hil->next;
    }
  return(0);
	
}



/* is_ip_tested()

   Same as is_host_tested but, returns :
   1 if the host ip is present in the hil structure or
   0 if it's not
*/



static short is_ip_tested(char * hostname, struct host_in_loop * hil, 
             short num_hil)
{
	struct in_addr addr = nn_resolve(hostname);
	while(num_hil--)
	{
	 if((addr.s_addr == hil->addr.s_addr)&&hil->tested)
	  return(1);
	 hil=hil->next;
	}
 return(0);
}


