/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * Log.c -- manages the logfile of Nessus
 *
 */
 


#include "config.h"
#include "nessuslib.h"
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include <windows.h>
#include "log.h"
#include "wstuff.h"

extern struct arglist * preferences;
FILE * logfile;


/* 
 * initialization of the log file
 */
void 
log_init(char * filename)
{
 if((!filename)||(!strncmp(filename, "stderr", 6)))logfile = stderr;
 else
 {
  logfile = fopen(filename, "a");
  if(!logfile)
  {
   
   print_error("Could not open the logfile, using stderr\n");
   logfile = stderr;
  }
 }
 log_write("starting up...\n");
}


/*
 * write into the logfile
 */
void 
log_write(char * str, ...)
{
  va_list param;
  char * disp = emalloc(1024);
  char * timestr;
  char * tmp;
  time_t t;
  
  va_start(param, str);
  vsprintf(disp, str, param);
  while((tmp=strchr(disp, '\n')))tmp[0]=' ';
  
  t = time(NULL);
  tmp = ctime(&t);
  timestr = emalloc(strlen(tmp)+1);
  strncpy(timestr, tmp, strlen(tmp));
  timestr[strlen(timestr)-1]=0;
  if(disp[strlen(disp)-1]=='\n')disp[strlen(disp)-1]=0;
  fprintf(logfile, "[%s] %s\n", timestr, disp);
  fflush(logfile);
  efree(&timestr);
  efree(&disp);
}

  
