/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include "nessuslib.h"
#include <windows.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <fcntl.h>
  

#include "pluginload.h"
#include "preferences.h"
#include "auth.h"
#include "comm.h"
#include "attack.h"
#include "sighand.h"
#include "log.h"
#include "rules.h"
#include "threads.h"
#include "users.h"
#include "wstuff.h"

/*
 * Global variables
 * (The less, the better)
 */

struct thread_args 
{
	struct sockaddr_in address;
	SOCKET socket;
};

DWORD TLSSockets;
struct arglist * plugins;
struct arglist * preferences;
SOCKET serv_socket;
SOCKET serv_port;
char * config_file;
struct users * users;

/*
 * Functions prototypes
 */
 
void main_loop();
int init_nessusd();
int init_plugins(char *);
int init_network(int);
void server_thread(struct thread_args *);


void 
main_loop()
{
  while(1)
    {
      DWORD soc;
	  struct thread_args * args;
	  DWORD id = 0;
      unsigned int lg_address = sizeof(struct sockaddr_in);
      struct sockaddr_in address;
      
      soc = accept(serv_socket, (struct sockaddr *)(&address), &lg_address);
      if(soc == INVALID_SOCKET){
    	if(errno == EINTR)continue;
  		else {
			print_error("accept() : error %d", WSAGetLastError());
			exit(2);
			}
      }
      log_write("connection from %s\n", (char *)inet_ntoa(address.sin_addr));
	  args = emalloc(sizeof(struct thread_args));
	  args->socket = soc;
	  args->address = address;
     CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)server_thread, args, 0, &id);
    }
}



void
server_thread(args)
 struct thread_args * args;
{
 char * perms;
 

 SOCKET * soc = LocalAlloc(LPTR, sizeof(SOCKET));
 struct sockaddr_in  address = args->address;
 *soc = args->socket;
 efree(&args);
 TlsSetValue(TLSSockets, (void *)soc);
 comm_init(*soc);
 if(!(perms = auth_check_user(users, (char *)inet_ntoa(address.sin_addr))))
 {
   auth_printf("Bad login attempt !\n"); 
   log_write("bad login attempt from %s\n", 
	    (char *)inet_ntoa(address.sin_addr));
 }
 else {
	char * host = NULL;
	char * port_range = NULL;
	int max;
	    
	 plugins_set_socket(*soc);
	 rules_add(perms);
	 comm_send_pluginlist();
	 host = comm_wait_order(&max, &port_range);
	 attack_host(host,port_range, max);
	 comm_terminate();
	}
 shutdown(*soc, 2);
 closesocket(*soc);
 ExitThread(0);
}
/*
 * Initialization of the network : 
 * we setup the socket that will listen for
 * incoming connections on port <port>
 */ 
int 
init_network(port)
     int port;
{
	WORD wVersionRequested;
	WSADATA wsaData;
    int err;
	struct sockaddr_in address;

	wVersionRequested = MAKEWORD( 2, 0 );
 
	err = WSAStartup( wVersionRequested, &wsaData );
	if(err)
	{
		print_error("Could not initialize WinSock !");
		return(0);
	}
#ifdef USE_AF_INET

  
  serv_socket = socket(AF_INET, SOCK_STREAM,0);

  if(serv_socket==INVALID_SOCKET)
    {
	  int err = WSAGetLastError();
      print_error("socket() failed -- error %d", WSAGetLastError());
      exit(1);
    }
  address.sin_family = AF_INET;
  address.sin_addr.s_addr = htonl(INADDR_ANY);
  address.sin_port = htons((u_short)port);
#else
  struct sockaddr_un address;
  char * name = AF_UNIX_PATH;
   if((serv_socket = socket(AF_UNIX, SOCK_STREAM,0))==-1)
   {
     print_error("socket() failed -- error %d", WSAGetLastError());
     exit(1);
   }
   bzero(&address, sizeof(struct sockaddr_un));
   address.sun_family = AF_UNIX;
   bcopy(name, address.sun_path, strlen(name));
#endif
 if(bind(serv_socket, (struct sockaddr *)(&address), sizeof(address))==-1)
    {
      print_error("bind() failed -- error %d", WSAGetLastError());
      exit(1);
    }
  if(listen(serv_socket, 10)==-1)
    {
      print_error("listen() failed -- error %d", WSAGetLastError());
      exit(1);
    }
  return(0);
}

/*
 * Initialize everything
 */
int 
init_nessusd()
{
  preferences_init(&preferences);
  rules_init();
  users_init(&users);
  nessusd_threads_init();
  log_init(arg_get_value(preferences, "logfile"));
  plugins_init(arg_get_value(preferences, "plugins_folder"));
  init_network(serv_port);
#ifndef NESSUS_NT
  signal(SIGCHLD, sighand_chld);
  signal(SIGTERM, sighand_term);
  signal(SIGINT, sighand_int);
  signal(SIGKILL, sighand_kill);
  signal(SIGSEGV, sighand_segv);
#endif
  return(0);
}



#ifdef NESSUS_NT
int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst,
				 LPSTR lpszArgs, int nWinMode)
#else
int main(int argc, char ** argv)
#endif
{ 
  DWORD id;
  serv_port = -1;
  config_file = NULL;

  if(serv_port == -1)serv_port = DEFAULT_PORT;
  if(!config_file)
  {
  	config_file = emalloc(strlen(NESSUSD_CONF)+1);
  	strncpy(config_file, NESSUSD_CONF, strlen(NESSUSD_CONF));
  }

  init_nessusd();
  if((TLSSockets = TlsAlloc()) == 0xFFFFFFFF)
  {
	  print_error("Could not allocate the TLS of the sockets");
	  exit(1);
  }
  /*
   * Main thread : deals only with the GUI
   * New  thread : deals with the network
   */
  CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)main_loop, NULL, 0, &id);
  init_main_window(hThisInst, nWinMode);
  return(0);
}
 
 
