#ifndef NMAP_H
#define NMAP_H

/************************INCLUDES**********************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <fcntl.h>
#include <signal.h> 
#include <winsock2.h>

/************************DEFINES************************************/

/* #define to zero if you don't want to	ignore hosts of the form 
   xxx.xxx.xxx.{0,255} (usually network and broadcast addresses) */
#define IGNORE_ZERO_AND_255_HOSTS 1


/* Default number of ports in paralell.  Doesn't always involve actual 
   sockets.  Can also adjust with the -M command line option.  */
#define MAX_SOCKETS 36
#define MAX_SOCKETS_ALLOWED MAX_SOCKETS
/*How many seconds before we give up on a host being alive? */
#define PING_TIMEOUT 10

#define fatal(x) { fprintf(stderr, "%s\n", x); exit(-1); }
#define error(x) fprintf(stderr, "%s\n", x);

/***********************STRUCTURES**********************************/

typedef struct port {
  unsigned short portno;
  unsigned char proto;
  char *owner;
  struct port *next;
} port;

typedef port *portlist;

/***********************PROTOTYPES**********************************/


/* our scanning functions */
portlist tcp_scan(struct in_addr *, unsigned short *, 
		  portlist *, struct arglist *);

unsigned short *getpts(char *); /* someone stole the name getports()! */


/* socket manipulation functions */
void init_socket(int );
int unblock_socket(SOCKET );
int block_socket(SOCKET );

/*
int isup(struct in_addr);
*/
#endif /* NMAP_H */































