/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Plugins Loader
 *
 */
 
#include "config.h"
#include "nessuslib.h"
#include <stdio.h>
#include <windows.h>
#include "pluginload.h"
#include "log.h"
#include "wstuff.h"


extern struct arglist * plugins;
extern struct arligst * preferences;

/*
 * main function for loading all the
 * plugins that are in folder <folder>
 */
int 
plugins_init(folder)
	char * folder;
{ 
  WIN32_FIND_DATA FileData;
  HANDLE hSearch;
  char * str;
  int finished = 0;

  if(!folder)
  {
#ifdef DEBUG
   log_write("%s:%d : folder == NULL\n", __FILE__, __LINE__);
#endif
   print_error("could not determine the value of <plugins_folder>. Check "NESSUSD_CONF"\n");
   exit(0);
  }
  str = emalloc(strlen(folder)+8);
  sprintf(str, "*.nes");
  if(!plugins)
  {
   plugins = emalloc(sizeof(struct arglist));
  }
  SetCurrentDirectory(folder);
  hSearch = FindFirstFile("*.nes",&FileData);
  if(hSearch == INVALID_HANDLE_VALUE)return(1);

  while(!finished)
  {
      plugin_add(folder, FileData.cFileName);
	  if(!FindNextFile(hSearch, &FileData))finished = 1;
  }
#ifdef DEBUG
  print_error("Plugins initialized\n");
#endif  
  FindClose(hSearch);
  return(0);
}

/*
 * add *one* plugin to the server list
 */
void 
plugin_add(folder, name)
	char * folder;
	char * name;
{
  HMODULE ptr = NULL;
 
  
#ifdef DEBUGMORE
  print_error("Attempting to load %s (%s)\n", name, folder);
#endif
  if((ptr = LoadLibrary(name))==NULL){
    log_write("Couldn't load %s\n", name);
    log_write("Error : %d\n", WSAGetLastError());
  }
  else {
    struct arglist * plugin;
    plugin_init_t  f_init;
    struct arglist * p_args;
	struct arglist * args, *t;
	char * str;
    plugin = emalloc(sizeof(struct arglist));
    
    if((f_init = (plugin_init_t)GetProcAddress(ptr, "plugin_init")) ||
    	(f_init = (plugin_init_t)GetProcAddress(ptr, "_plugin_init")))
      {
      	p_args = emalloc(sizeof(struct arglist));
      	arg_add_value(p_args, "preferences", ARG_ARGLIST, -1, (void*)preferences);
#ifdef DEBUGMORE
	print_error("Calling plugin_init() (%d) \n", (int)f_init);
#endif
      	(*f_init)(p_args);
#ifdef DEBUG 
	print_error("Adding \"%s\" in the plugins list\n", name);
#endif
    args = emalloc(sizeof(struct arglist));
	t = args;
	while(p_args && p_args->next)
	{
		t->name = emalloc(strlen(p_args->name)+1);
		strncpy(t->name, p_args->name, strlen(p_args->name));
		t->type = p_args->type;
		if(t->type == ARG_STRING)
		{
			t->value = emalloc(strlen(p_args->value)+1);
			strncpy(t->value, p_args->value, strlen(p_args->value));
		}
		else t->value = p_args->value;
	    t->length = p_args->length;
		p_args = p_args->next;
		t->next = emalloc(sizeof(struct arglist));
		t = t->next;
	}
 	arg_add_value(plugin, "plugin_args", ARG_ARGLIST, -1, (void *)args);
	str = emalloc(strlen(name)+1);
	strncpy(str, name, strlen(name));
	arg_add_value(plugin, "full_name", ARG_STRING, strlen(str), str);
 	plug_set_launch(args, 0);
 	arg_add_value(plugins, name, ARG_ARGLIST, -1, (void *)plugin);
      }
    else log_write("Couldn't find the entry point in %s \n", name);
	FreeLibrary(ptr);
  }
}
 
void 
plugins_set_socket(int soc)
{
 struct arglist * t, *v,*w = NULL;
 
 t = plugins;
 while(t && t->next)
 {
  v = arg_get_value(t->value, "plugin_args");
  if(v)
  {
	  w = arg_get_value(v, "SOCKET");
	  if(!w)arg_add_value(v, "SOCKET", ARG_INT, sizeof(int), (void *)soc);
	  else arg_set_value(v, "SOCKET", sizeof(int), (void *)soc);
  }
  t = t->next;
 }
}
