/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Preferences  -- maps the content of the nessusd.conf file to memory
 *
 */
 
#include "config.h"
#include "nessuslib.h"
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>


#include "wstuff.h"
#include "preferences.h"
#include "log.h"


extern char * config_file;

int preferences_init(prefs)
	struct arglist ** prefs;
{
  char * filename;
  int result;
  *prefs = emalloc(sizeof(struct arglist));
  
  filename = preferences_get_filename();
  result = preferences_process(filename, *prefs);
  efree(&filename);
  return(result);
}

char * preferences_get_filename()
{
  return(config_file);
}
 
int preferences_new()
{
  FILE * fd;
  char * buf;

  if(!(fd = fopen(preferences_get_filename(), "w"))){
    print_error("Could not open %s", preferences_get_filename());
    return(-1);
  }
 
  buf = emalloc(500);
  sprintf(buf,
"# Nessus's Default Setup\n#\n\
# Every line begining with a '#' is a comment\n#\n\
plugins_folder = .%cplugins\n\
email = root@localhost\n\
max_threads = 15\n\
logfile = nessusd.messages\n\
rules = %s\n\
# Users database (read doc/sample.users for details)\n\
users = %s\n\
# Remote file that the plugins will try to read :\n\
test_file = /etc/passwd\n\
\n\
# end.", 
#ifdef NESSUS_NT
 '\\',
#else
  '/',
#endif
  NESSUSD_RULES, NESSUSD_USERS);
  fprintf(fd, buf);
  efree(&buf);
  fclose(fd);
  return(0);
}

int preferences_process(filename,prefs)
     char * filename;
     struct arglist * prefs;
{
  FILE * fd;
  char * buffer;
  char * opt, *value;
    if(filename)
      {
	if(!(fd = fopen(filename, "r"))) {
	 if(errno == EACCES)
	 {
	  print_error(
	  	"The Nessus daemon doesn't have the right to read %s\n", filename);
	  exit(1);
	 }
#ifdef DEBUG
	  printf("Couldn't find any prefs file... Creating a new one...\n");
#endif 
	  if(preferences_new()){
	    print_error("Error creating %s\n", preferences_get_filename());
	    arg_add_value(prefs, "plugins_folder", ARG_STRING,
			  strlen("./plugins"), "./plugins");
	    return(1);
	  }
	  else
	    if(!(fd = fopen(filename, "r")))
	      {
	        perror("open ");
		printf("Could not open %s -- now quitting\n", filename);
		exit(2);
	      }
	}
	buffer = emalloc(255);
	while(!feof(fd) && fgets(buffer, 254,fd))
	  {
	   char * t;
	  if(buffer[strlen(buffer)-1]=='\n')buffer[strlen(buffer)-1]=0;
	    if(buffer[0]=='#')continue;
	    opt = buffer;
	    t = strchr(buffer, '=');
	    if(!t)continue;
	    else {
	      t[0]=0;
	      t+=sizeof(char);
	      while(t[0]==' ')t+=sizeof(char);
	      while(opt[strlen(opt)-1]==' ')opt[strlen(opt)-1]=0;
	      value=emalloc(strlen(t)+1);
	      strncpy(value, t, strlen(t));
	      arg_add_value(prefs, opt, ARG_STRING, strlen(value), value);
#ifdef DEBUGMORE
	      printf("%s = %s\n", opt, value);
#endif
	    }
     	 }
    return(0);
    }
   else return(1);
}
 
 
 
 


