/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */           
 
#include "config.h"
#include "nessuslib.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>

#include <ctype.h>
#include <fcntl.h>
#undef HAVE_FNMATCH

#include "rules.h"

extern struct arglist * preferences;
struct nessus_rules * rules;


char * rules_get_fname()
{
  char * t;
  if((t=arg_get_value(preferences, "rules")))return(t);
  else return(NESSUSD_RULES);
}


void rules_init()
{
#ifdef HAVE_FNMATCH
  FILE * fd;
  char * fn = rules_get_fname();
  struct nessus_rules * p ;
  
  
  p = rules = emalloc(sizeof(struct nessus_rules));
  fd = fopen(fn, "r"); 
  if(!fd)
    {
      char * buf = emalloc(200);
      int f = open(fn, O_CREAT | O_RDWR,  0660);
      
      chown(fn, getuid(), getgid());
      close(f);
      f = open(fn, O_RDWR);
      sprintf(buf, 
     "#Nessusd rules\n#read doc/sample.rules for details\nN:localhost.*\n");
      write(f, buf, strlen(buf));
      efree(&buf);
      close(f);
      p->name = emalloc(12);
      sprintf(p->name, "localhost.*");
      p->category = p_DONT_TEST;
      p->next = NULL;
    }
  else
    {
      char * buf = emalloc(255);
      
      bzero(buf, 255);
      while(fgets(buf, 255, fd) && !feof(fd))
	{
	  if(buf[0]!='#' && strlen(buf)>2)
	    {
	      switch(buf[0])
		{
		case 'n':
		  p->category = p_DONT_TEST;
		  break;
		case 'y':
		  p->category = p_DO_TEST;
		  break;
		case 'N' :
		  p->category = p_DO_NOT_TEST;
		  break;
		default : 
		  p->category = -1;
		  fprintf(stderr, "Parse error in %s : \"%s\"\n",fn,  buf);
		}
	      if(p->category != -1)
		{
		  buf+=2;
		  if(buf[strlen(buf)-1]=='\n')buf[strlen(buf)-1]=0;
		  p->name = emalloc(strlen(buf) + 1);
		  p->server = 1;
		  strncpy(p->name, buf, strlen(buf));
		  p->next = emalloc(sizeof(struct nessus_rules));
		  bzero(p->next, sizeof(struct nessus_rules));
		  p = p->next;
		  buf-=2;
		}
	    }
	   bzero(buf, 255);
	}
      efree(&buf);
      fclose(fd);
    }
#endif
}


void rules_add(char * rules_str)
{
#ifdef HAVE_FNMATCH
 int flag = 0;
 struct nessus_rules * p = rules;
 while(p && p->next)p=p->next;
 
 
 while(!flag)
 {
  char * t = strchr(rules_str, '\n');
  if(t)t[0]=0;
  if(rules_str[0]!='#' && strlen(rules_str)>2)
   {
    switch(rules_str[0])
    {
     case 'n':
	p->category = p_DONT_TEST;
	break;
     case 'y':
	p->category = p_DO_TEST;
	break;
    case 'N' :
	p->category = p_DO_NOT_TEST;
	break;
	
    default : 
	p->category = -1;
	 fprintf(stderr, "Parse error in the users database : \"%s\"\n",  rules_str);
     }
    if(p->category != -1)
	{
	 rules_str+=2;
	 p->name = emalloc(strlen(rules_str) + 1);
	 p->server = 0;
	 p->extra_flag = 0;
	 sprintf(p->name, "%s", rules_str);
	 p->next = emalloc(sizeof(struct nessus_rules));
	 p = p->next;
	 rules_str-=2;	  
	}
    }
   if(!t)flag = 1;
   else rules_str = t+1;
   }
 #endif
}

struct nessus_rules * rules_parse(name, r, server)
   char * name;
   struct nessus_rules * r;
   int server;
{
#ifdef HAVE_FNMATCH
  char good = 1;
  int i;
  char * lname = emalloc(strlen(name)+1);
  strncpy(lname, name, strlen(name));
  for(i=0;i<strlen(lname);i++)lname[i]=tolower(lname[i]);
  
  while(r && r->name && good)
    {
      if(server)
       {
       if(r->server && !fnmatch(r->name, lname, 0))good = 0;
       }
      else if(!fnmatch(r->name, lname, 0))good = 0;
      if(good) r = r->next;
    }
  efree(&lname);
  return(good ? NULL:r);
#else
  return(NULL);
#endif
}


short get_hostname_attributes(name)
  char * name;
{
#ifdef HAVE_FNMATCH
  struct nessus_rules * p = rules;
  short a=0;
  
  while(p && p->name)
  {
   if(p->server)
    {
    p = rules_parse(name, p, 1);
    if(p)
     {
     a += (a & p->category)?0:p->category;
     if(p)p = p->next;
     }
    }
   else p = p->next;
  }
  
  if(!(pTEST(a)))return(a);
  
  p = rules;
  while(p && p->name)
   {
    if(!p->server)
    {
     p = rules_parse(name, p,0);
     if(p)
     {
     a += (a & p->category)?0:p->category;
     if(p)p = p->next;
     }
    }
    else p=p->next;
   }
  return(a);
#else
  return(p_DO_TEST);
#endif
} 

	
		
	
	  
