

#include <config.h>
#include <nessuslib.h>
#include "nmap.h"
#include "log.h"
#include "auth.h"
#include "comm.h"
#include <errno.h>



extern DWORD TLSSockets;

/* global options */
int number_of_ports  = 0; /* How many ports do we scan per machine? */

void scan_thread(struct scan_thread_data * data);

int scanner_main(hostinfos, port_range)
     struct arglist * hostinfos;
     char * port_range;
{
  short *ports;
  portlist openports = NULL;
  struct in_addr *p_addr;
  
  if(!strcmp("-1", port_range))return(0);
  else arg_add_value(hostinfos, "scanned", ARG_INT, sizeof(int), (void *)1);
  ports = getpts(port_range);
  arg_add_value(hostinfos, "SCAN_RANGE", ARG_PTR, sizeof(ports), ports);
  p_addr = arg_get_value(hostinfos, "IP");
  if(!p_addr)return(-1);
#if 0
  if(getuid()==0)
    {
      if(isup(*p_addr))
	tcp_scan(*p_addr, ports, &openports, 
		 arg_get_value(hostinfos, "PORTS"));
      else log_write("%s appears to be down -- no scan\n", 
		     (char *)arg_get_value(hostinfos, "FQDN"));
    }
  else 
#endif
    tcp_scan(p_addr, ports, &openports, hostinfos);
  return 0;
}

/* Convert a string like "-100,200-1024,3000-4000,60000-" into an array 
   of port numbers

   This part of the code is (c) Fyodor <fyodor@dhp.com> */
unsigned short *getpts(char *origexpr) {
int exlen = strlen(origexpr);
char *p,*q;
unsigned short *ports;
int i=0, j=0,start,end;
char *expr = strdup(origexpr);
char *mem = expr;

ports = emalloc(65536 * sizeof(short));
for(;j < exlen; j++) 
  if (expr[j] != ' ') expr[i++] = expr[j]; 
expr[i] = '\0';
exlen = i;
i=0;
while((p = strchr(expr,','))) {
  *p = '\0';
  if (*expr == '-') {start = 1; end = atoi(expr+ 1);}
  else {
    start = end = atoi(expr);
    if ((q = strchr(expr,'-')) && *(q+1) ) end = atoi(q + 1);
    else if (q && !*(q+1)) end = 65535;
  }
  if (start < 1 || start > end) fatal("Your port specifications are illegal!");
  for(j=start; j <= end; j++) 
    ports[i++] = j;
  expr = p + 1;
}
if (*expr == '-') {
  start = 1;
  end = atoi(expr+ 1);
}
else {
  start = end = atoi(expr);
  if ((q =  strchr(expr,'-')) && *(q+1) ) end = atoi(q+1);
  else if (q && !*(q+1)) end = 65535;
}
if (start < 1 || start > end) fatal("Your port specifications are illegal!");
for(j=start; j <= end; j++) 
  ports[i++] = j;
ports[i++] = 0;
  return ports;
}

struct scan_thread_data {
	 struct in_addr *target;
	 char * name;
	 int port;
	 struct arglist * hostdata;
	 SOCKET socket;
};

portlist tcp_scan(target,portarray, ports,hostdata) 
     struct in_addr *target;
     unsigned short *portarray;
     portlist *ports;
     struct arglist * hostdata;	
{
 int max = 0;
 int current = 0;
 int i,j=0;
 char * name = arg_get_value(hostdata, "FQDN");
 struct scan_thread_data *scan_thread_data;
 DWORD id;


 for(i=0;portarray[i];i++)max++;
 comm_send_status(name, 
			current, max);
 for(i=0;i<max;i++)
  {
   SOCKET *soc = TlsGetValue(TLSSockets);
   
   if(j==100)
	 {
		 j = 0;
		 comm_send_status(name, 
			current, max);
	 }
    
     j++;current++;
     scan_thread_data = emalloc(sizeof(struct scan_thread_data));
	 scan_thread_data->target = target;
	 scan_thread_data->port = portarray[i];
	 scan_thread_data->name = name;
	 scan_thread_data->socket = *soc;
	 scan_thread_data->hostdata = hostdata;
	 CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)scan_thread, scan_thread_data, 0, &id);
 }
 return NULL;
}



void scan_thread(struct scan_thread_data * data)
{
	SOCKET soc;
    struct sockaddr_in addr;
 
	TlsSetValue(TLSSockets, &data->socket);
	soc = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    
	addr.sin_family=AF_INET;
    addr.sin_port=htons((u_short)data->port);
    addr.sin_addr = *data->target;
	 if(!connect(soc, (struct sockaddr *)&addr, sizeof(struct sockaddr)))
	 {
		auth_printf("SERVER <|> PORT <|> %s <|> %d <|> SERVER\n",
			  data->name,data->port);
		host_add_port(data->hostdata, data->port, 1, NULL);
		shutdown(soc, 2);
	 }
	 closesocket(soc);
	 efree(&data);
	 ExitThread(0);
}


