/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Signals handler
 */

#include "config.h"
#include "nessuslib.h"
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <windows.h>
#include "log.h"
#include "auth.h"
#include "threads.h"

extern DWORD TLSSockets;
void sighand_pipe()
{
  SOCKET *socket = (SOCKET*)TlsGetValue(TLSSockets);
  log_write("connection closed by the client (SIGPIPE caught)\n");
  shutdown(*socket,2);
  closesocket(*socket);
  _exit(1);   
}

void sighand_chld()
{
}


void sighand_alarm()
{
  SOCKET *socket = (SOCKET*)TlsGetValue(TLSSockets);
  log_write("connection timed out\n");
  shutdown(*socket,2);
  closesocket(*socket);
  _exit(1);
}           

void sighand_alarm_plugin()
{
 extern DWORD current_plugin;
 log_write("current plugin is slow to finish -- sending SIGKILL\n");
 /* kill(current_plugin, SIGKILL); */
}


void sighand_term()
{
  log_write("received the TERM signal\n");
#ifndef USE_AF_INET
  unlink(AF_UNIX_PATH);
#endif
  exit(0);
}
 
void sighand_int()
{
 log_write("received the INT signal\n");
#ifndef USE_AF_INET
 unlink(AF_UNIX_PATH);
#endif
 exit(0);
}

void sighand_segv()
{
 signal(SIGSEGV, exit);
 log_write("SIGSEGV occured !\n");
#ifndef USE_AF_INET
 unlink(AF_UNIX_PATH);
#endif
 exit(0);
}

void sighand_kill()
{
 log_write("received the KILL signal\n");
#ifndef USE_AF_INET
  unlink(AF_UNIX_PATH);
#endif
  exit(0);
}

void sighand_io()
{
 char * buf;
 char * t;
 buf = emalloc(4096);
 auth_gets(buf, 4095);
 if((t = strstr(buf, "STOP_ATTACK")))
  {  
   char * t2;
   t2 = strstr(t, "<|> ");
   if(!t2)return;
   t2+=strlen("<|> ");
   t = strstr(t2, " <|>");
   if(!t)return;
   t[0] = 0;
   nessusd_thread_kill_by_name(t2);
   t[0] = ' ';
  }
 efree(&buf);
}

