/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Nessus Threads Manager
 *
 */ 
 
#include "config.h"
#include "nessuslib.h"
#include <stdlib.h>
#include <stdio.h>
#include <windows.h>
#include <process.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include "auth.h"
#include "threads.h"

	
struct nessusd_threads *nessusd_threads;
extern int attack_num_daemons;
void nessusd_threads_init()
{
 nessusd_threads = emalloc(sizeof(struct nessusd_threads));
}

void nessusd_thread_register(char * hostname, DWORD pid, HANDLE hThread)
{  
 struct nessusd_threads * t = nessusd_threads;
 struct nessusd_threads * old;
 
 while(t && t->next)t = t->next;
 if(!t)return;
 t->hostname = emalloc(strlen(hostname)+1);
 strncpy(t->hostname, hostname, strlen(hostname));
 t->pid = pid;
 t->hThread = hThread;
 t->up = 1;
 t->next = emalloc(sizeof(struct nessusd_threads));
 old = t;
 t = t->next;
 t->previous = old;
}

void nessusd_thread_unregister(DWORD pid)
{
 struct nessusd_threads * t = nessusd_threads;
 while(t && t->next && t->pid !=pid)t = t->next;
 if(t)t->up = 0;
}

void nessusd_thread_kill_by_name(char * hostname)
{
 struct nessusd_threads * t = nessusd_threads;

 while(t && t->next && t->hostname && strcmp(hostname, t->hostname))t = t->next;
 if(t){
	 TerminateThread(t->hThread, 0);
	 t->up = 0;
 }
}


