/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Users manager
 *
 */
 
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <windows.h>
#include "nessuslib.h"
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include "log.h"
#include "users.h"
#include "wstuff.h"

extern struct arglist * preferences;
 
int users_init(struct users ** users)
{
 FILE * fd;
 char * fname;
 char * str;
 struct users * l_users;
 *users = emalloc(sizeof(struct users));
 l_users = *users;
 fname = arg_get_value(preferences, "users");
 if(!fname)
 {
   print_error("\"users\" not set in "NESSUSD_CONF"\n");
   exit(1);
 }
 fd = fopen(fname, "r");
 if(!fd)
 {
   if(errno != ENOENT)
    {
     print_error("%s could not be opened -- now exiting\n", fname);
     exit(1);
    }
   else
   { 
   FILE * f;
   if(!(f = fopen(fname, "w")))
    {
    print_error("could not create the file %s -- now exiting\n", fname);
    exit(1);
    }
   fprintf(f, "# user password rules;\nfoo pass y:*;\n");
   fclose(f);
   print_error("\
A new user database (%s) has been created\n\
You must edit it and then relaunch nessusd\n", fname);
   exit(0);
   }
 }
 
 str = emalloc(1024);
 while(fgets(str, 1023, fd) && !feof(fd))
 {
  char * user;
  char * password;
  char * perms_str;
  char * t;
  
  if(str[0]!='#')
  {
  user = emalloc(strlen(str)+1);
  password = emalloc(strlen(str)+1);
  perms_str = emalloc(strlen(str)+1);
  sscanf(str, "%s %s %s", user, password, perms_str);
  l_users->name = emalloc(strlen(user)+1);
  strncpy(l_users->name, user, strlen(user));
  l_users->password = emalloc(strlen(password)+1);
  strncpy(l_users->password, password, strlen(password));
  t = perms_str;
  while((t=strchr(t, ';')))t[0]='\n';
  l_users->perms = emalloc(strlen(perms_str)+1);
  strncpy(l_users->perms, perms_str, strlen(perms_str));
  l_users->next = emalloc(sizeof(struct users));
  l_users = l_users->next;
  }
  else bzero(str, 1024);
  }
  fclose(fd);
  return(0);
}

char * 
check_user(struct users * users, char * user, char * password)
{
 while(users && users->next)
 {
  if(!strcmp(user, users->name))break;
  users = users->next;
 }
 
 if(!users || !users->next)return(NULL);
 if(strcmp(users->password, password))return(NULL);
 return(users->perms);
}
 
 
 
