/* Hostloop -- the Hostloop Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */   

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <nessuslib.h>
#include <windows.h>

#ifndef INT16SZ
#define INT16SZ 2
#endif

#ifndef INT32SZ
#define INT32SZ 4
#endif

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif



/*   complete_hostname()

     Parameters :
        src : a complete hostname (eg : www.server.com)
	dst : the name of a machine (eg : joe) which belongs
	      to the same network as <src>

     Returns :
       char * : the complete hostname of the machine
                (eg : joe.server.com) or
                NULL if a problem occured

     This function is mainly used to convert showmount outputs which
     don't always show the complete name of the machines... It does
     *NOT* check the validity of the formed address.
*/

char * complete_hostname(char * dst, char *src)
{
  unsigned int i=-1;
  char * ret;
  
  while(src[++i]!='.' && i < strlen(src));
  if(src[i]!='.')return(NULL);
  src += (i*(sizeof(char)));
  ret = malloc(strlen(dst) + strlen(src) + 1);
  sprintf(ret, "%s%s", dst, src);
  return(ret);
}

/*    name_to_ip()
      
      Parameters :
      char * hostname : the name of a server

      Returns : 
      char * the IP of this server

      eg : www.server.com --> 194.3.190.20

*/
char * name_to_ip(char * hostname)
{
  return(inet_ntoa(nn_resolve(hostname)));
}

/*   name_to_domainname()

     Parameters :
        char * hostname : the name of a server
     Returns :
        char * : the domain of this server or
	NULL   : if the domain couldn't be guessed

     This function guesses the domain name of an hostname
     eg : sun.lab.univ.edu --> lab.univ.edu
          server.com --> NULL (and not 'com')
          localhost --> NULL
	  
*/
char * name_to_domainname(char * hostname)
{
  unsigned int i = -1, j;
 
  if(inet_addr(hostname)!=INADDR_NONE)return(NULL);
  while(hostname[++i]!='.' && i<strlen(hostname));
  if(hostname[i]!='.')return(NULL);
  j=i;
  /*	if the hostname is server.com, we must _not_ 
	answer "belongs to .com", so we check there's
	at least another domain after...
  */
  while(hostname[++j]!='.' && j<strlen(hostname));
  if(hostname[j]!='.')return(NULL);
  else return(hostname+i+1);
}


