/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */           
 
#include "config.h"
#include "nessuslib.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <stdarg.h>
#include "wstuff.h"
#include "threads.h"
#include "Resources/resource.h"

HWND main_window;
HWND dialog;

LRESULT CALLBACK window_handler(HWND wnd, UINT message, 
								WPARAM wParam, LPARAM lParam);

void
print_error(char * data, ...)
{
  va_list param;
  char * buffer;
  buffer = emalloc(4096);
  va_start(param, data);
  vsprintf(buffer, data, param);
  MessageBox(NULL, buffer,"Nessusd error", MB_OK | MB_ICONSTOP);
  efree(&buffer);
}        


BOOL CALLBACK DialogFunc(HWND hdwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	if((message == WM_COMMAND) && (LOWORD(wParam)==IDOK))exit(0);
	else
		if(message == WM_DESTROY)exit(0);
	return(0);
}

void
init_main_window(hThisInst, nWinMode)
 HINSTANCE hThisInst;
 int nWinMode;
{
	 MSG msg;
	 WNDCLASSEX wcl;

	 wcl.cbSize = sizeof(WNDCLASSEX);
	 wcl.lpszClassName = "myWin";
	 wcl.lpfnWndProc = window_handler;
	 wcl.style = 0;

	 wcl.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	 wcl.hIconSm = LoadIcon(NULL, IDI_WINLOGO);
	 wcl.hCursor = LoadCursor(NULL, IDC_ARROW);

	 wcl.lpszMenuName = NULL;
	 wcl.cbClsExtra = 0;
	 wcl.cbWndExtra = 0;
	 wcl.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	 if(!RegisterClassEx(&wcl))exit(0);

	 main_window = CreateWindow(
			"MyWin",
			"Nessusd NT",
			WS_OVERLAPPEDWINDOW,
			CW_USEDEFAULT,
			CW_USEDEFAULT,
			1,
			1,
			HWND_DESKTOP,
			NULL,
			hThisInst,
			NULL);

	 dialog = CreateDialog(hThisInst, "MyDialog", NULL, (DLGPROC)DialogFunc);
	 if(!dialog)print_error("Could not init main dialog");
	 ShowWindow(dialog, nWinMode);
	 UpdateWindow(dialog);
	 while(GetMessage(&msg, NULL,0,0))
	 {
		 if(!IsDialogMessage(dialog, &msg))
		 {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		 }	 
	 }
	 ExitThread(0);
}



LRESULT CALLBACK window_handler(HWND wnd, UINT message, WPARAM wParam, 
								LPARAM lParam)
{
	switch(message)
	{ 
	case ASYNC_MESSAGE :
		{
			int i = 0;
			ioctlsocket(wParam, FIONREAD, &i);
			if(i)
			{
				char * data  = emalloc(1024);
				char *t;
				recv_line(wParam, data, 1024);
				if((t = strstr(data, "STOP_ATTACK")))
				{  
				 char * t2;
				 t2 = strstr(t, "<|> ");
			     if(!t2)return(0);
				 t2+=strlen("<|> ");
				 t = strstr(t2, " <|>");
				 if(!t)return(0);
				 t[0] = 0;
				 nessusd_thread_kill_by_name(t2);
				 t[0] = ' ';
				}
				efree(&data);
			}
		}
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		exit(0);
		break;
	default:
		return(DefWindowProc(wnd, message, wParam, lParam));
		break;
	}
	
	return(0);
}


