#include <config.h>
#include <nessuslib.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>


#define NAME "finger features"
#define DESC "This plugin determines whether there's a hole in the fingerd\n\
daemon of a remote host, allowing a remote user to gain the list of the users\\n\
who have never logged in the remote system -- this is of some interest to a\n\
darkside hacker who may know which accounts are never used and try to force\n\
them, since they are not monitored\n\n\
Risk factor : medium/high"
#define COPYRIGHT "no copyright"
#define SUMM "determines if fingerd sends the list of the unused accounts of the remote system"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "finger abuses");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	
	int soc;
	char * buffer;
	
	if(host_get_port_state(args, 79)<=0)return(0);  
	soc = open_sock_tcp(args, 79);
	if(soc < 0)return(0);
	buffer = emalloc(1024);
	sprintf(buffer, ".\n");
	send(soc, buffer, strlen(buffer),0);
	bzero(buffer,1024);
	recv(soc, buffer, 1023,0);
	closesocket(soc);
	if(strlen(buffer) && !strstr(buffer, "such user")&&!strstr(buffer, "???")&&
		!strstr(buffer, "doesn't exist")) 
	{ 
	 char * report = emalloc(300+strlen(buffer));
	 sprintf(report,
"The finger daemon of the remote host is \n\
subject to the .@host fingerd bug.\n\
Here is the output of this command :\n\
%s\nSolution : upgrade your finger daemon or erase the line \n\
'finger' in /etc/inetd.conf if you don't use this service", buffer);
	 post_hole(args, 79, report);
	} 
	else
	{
	soc = open_sock_tcp(args, 79);
	if(soc < 0 )return(0);
	sprintf(buffer, "0\n");
	send(soc, buffer, strlen(buffer),0);
	bzero(buffer,1024);
	recv(soc, buffer, 1023,0);
	closesocket(soc);
	if(strlen(buffer) && !strstr(buffer, "such user")&&!strstr(buffer, "???")&&
	!strstr(buffer, "doesn't exist"))
	{ 
	 char * report = emalloc(300+strlen(buffer));
	 sprintf(report,
"The finger daemon of the remote host is \n\
subject to the 0@host fingerd bug.\n\
Here is the output of this command :\n\
%s\nSolution : upgrade your finger daemon or erase the line \n\
'finger' in /etc/inetd.conf if you don't use this service", buffer);
	 post_hole(args, 79, report);
	} 
	}
	efree(&buffer);
	return(0);
	
}

