#include <config.h>
#include <nessuslib.h>
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifndef NESSUS_NT
#include <sys/types.h>
#include <sys/socket.h>   
#else
#include <windows.h>
#endif 

#define NAME "ftp writeable root"
#define DESC "\
It is sometime possible to write on the root dir of a remote ftp \n\
server, which is a real problem since any hacker can \n\
upload a '.forward' or '.rhosts' file and then get a shell \n\
easily\n\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "attempts to write on the root of a remote ftp server"





PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "FTP");
	return(0);
}
	
void getline(int soc, char * buf)
{
 int i = 0;
 char c;
 int flag = 0;
 
 bzero(buf, 2048);
 while(!flag)
 {
  recv(soc, &c, 1,0);
  buf[i++] = c;
  if(c==0 || c=='\n' || i>2046)flag = 1;
 }
}

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int soc;
	char * buf;
	int writeable = 0;
	
	if(host_get_port_state(args, 21)<=0)return(0);
	soc = open_sock_tcp(args, 21);
	if(soc<0)return(-1);
	buf = emalloc(2048);
	getline(soc, buf);
	bzero(buf, 2048);
	
	sprintf(buf, "USER ftp\n");
	send(soc, buf, strlen(buf),0);
	
	bzero(buf,2048);
	getline(soc, buf);
	
	sprintf(buf, "PASS joe@\n");
	send(soc, buf, strlen(buf), 0);
	getline(soc, buf);
	
	if(strstr(buf, "230 "))
	{
	
	 bzero(buf, 2048);
	 sprintf(buf, "CWD /\n");
	 send(soc, buf, strlen(buf),0);
	 bzero(buf, 2048);
	 getline(soc, buf);
	 
	 bzero(buf, 2048);
	 sprintf(buf, "STOR .tmp\n");
	 send(soc, buf, strlen(buf), 0);
	 bzero(buf, 2048);
	 getline(soc, buf);
	
	 /* If the daemon accepts to write a file
	    it will try to establish a connection, which
	    won't be done, thus it will reply an error 425 */
	 if(!strncmp(buf, "425", 3))
	 {
	  writeable = 1;
	  bzero(buf, 2048);
	  sprintf(buf, "DELE .tmp\n");
	  send(soc, buf, strlen(buf), 0);
	 }
	 sprintf(buf, "QUIT\n");
	 send(soc, buf, strlen(buf),0);
       }
        efree(&buf);
        closesocket(soc);
	
	if(writeable)
	{
	 post_hole(args, 21, "\
The remote FTP root appears to be writable\n\
This means that any intruder could upload a file\n\
called '.rhost' or '.forward' and may gain easily\n\
a shell on your computer...\n\n\
Solution : change the ownership of the ftp directory\n\
and set appropriately the mode...\n");
	}
	return(0);
}

