#include <config.h>
#include <nessuslib.h>
#include <stdio.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#ifndef NESSUS_NT
#include <sys/types.h>
#include <sys/socket.h>  
#else
#include <windows.h>
#endif


#define NAME "icat"
#define DESC "This plugin determines the presence of the 'icat' cgi\n\
Some versions of this cgi allows a remote user to view any file\n\
on a WindowsNT system\n\n\
Risk factor : medium/high"
#define COPYRIGHT "no copyright"
#define SUMM "determines the presence of the 'icat' cgi"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "CGI abuses");
	return(0);
}



PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	if(host_get_port_state(args, 80)<=0)return(0);
	
	if(is_cgi_installed(args, "icat"))
	  post_hole(args, 80, "The 'icat' cgi is installed\nAny file may be viewed\n\
Solution : contact the vendor for a patch");
	return(0);
}

