#include <config.h>
#include <nessuslib.h>

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifndef NESSUS_NT
#include <sys/types.h>
#include <sys/socket.h>  
#else 
#include <windows.h>
#endif

#define NAME "inn buffer overflow"
#define DESC "\
This plugin determines whether inn is vulnerable\n\
Some old version on inn may be exploited using a remote buffer\n\
overflow\n\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "determines if inn is vulnerable"



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{

	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Gain root remotely");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int soc;
	char * buffer;
	char * ptr;
	
	if(host_get_port_state(args, 119)<=0)return(0);
	
	
	soc = open_sock_tcp(args, 119);
	if(soc<0)return(0);
	
	buffer = emalloc(512);
	recv(soc, buffer, 512,0);
	if((ptr = strstr("INN", buffer)))
	{
		int ver;
		int subver;
		ptr+=4;
		ptr[1] = 0;
		ver = atoi(ptr);
		ptr += 2;
		ptr[1] = 0;
		subver = atoi(ptr);
		
		if((ver == 1) && (subver < 6))
		{
			post_hole(args, 119, 
"INN version is < 1.6\nIt may exploited by a buffer overflow\n");
		}
	}
	efree(&buffer);
	closesocket(soc);
	return(0);
}

