/*
 * Motorola Cable Modem 'feature'
 * You can telnet to a motorola cable modem on port 1024 
 * and attempt to reconfigure it...
 *
 */
#include <config.h>
#include <nessuslib.h>
#include <stdio.h>
#include <stdlib.h>
#ifndef NESSUS_NT
#include <unistd.h>
#include <string.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#else
#include <windows.h>
#endif

#define NAME "Motorola Cable router vulnerability"
#define DESC "\
It is sometimes possible to reconfigure a Motorola Cable\n\
router by connecting to it on port 1024 and using the\n\
good login/password (which is by default : 'cablecom/router')\n\
This plugin will attempt to connect to the remote host\n\
on port 1024 and will check if ever this vulnerability\n\
is present"

#define COPYRIGHT "discovered by January <january@spy.net>"
#define SUMM "Checks for a vulnerability in Motorola Cable modems"

PlugExport int plugin_init(struct arglist *desc); 
PlugExport int plugin_init(struct arglist *desc)
{
        plug_set_name(desc, NAME);
        plug_set_description(desc, DESC);
        plug_set_summary(desc, SUMM);
        plug_set_copyright(desc, COPYRIGHT);
        plug_set_category(desc, ACT_GATHER_INFO);
        plug_set_family(desc, "Misc.");
        return(0);
}

PlugExport int plugin_run(struct arglist *);

PlugExport int plugin_run(args)
 struct arglist * args;
{
 int sock;
 
 if(host_get_port_state(args, 1024)>0)
 {
  char * buf = emalloc(255);
  int vulnerable = 0;
  int standard_pass = 0;
  if((sock = open_sock_tcp(args, 1024))<0)return(0);
  send(sock, "\n", 1, 0);
  recv_line(sock, buf, 255);
  
  if(!strncmp(buf, "Login:", strlen("Login:")))
  {
    char * data;
    /*  The remote host accepts us, so we can access it.
        it could be possible to attempt a brute force
        attack against this account, so we mark this
        feature as being a vulnerability
     */
    vulnerable = 1;
   
    /* Now, does the remote host accepts the standard login/pass
      (cablecom/router) ?
     */
    data = emalloc(255);
    sprintf(data, "cablecom\n");
    send(sock, data, strlen(data),0);
    recv_line(sock, buf, 255);
    sprintf(data, "router\n");
    recv_line(sock, buf, 255);
   /*
    * Gotta change this to '!strncmp(buffer, <normal welcome message>)'
    * when I meet one of this modem
    */
    if(strncmp(buf, "Invalid name.", strlen("Invalide name.")))standard_pass = 1;
    efree(&data);
   }
  closesocket(sock);
   efree(&buf);
 
 /* We now have to report the result to nessusd */
 
 if(standard_pass)
 {
  post_hole(args, 1024,
"The remote cable modem can be reconfigured from\n\
_anywhere_ provided that the remote user connects\n\
to it on port 1024 and uses the login/pass : 'cablecom/router'\n\
\nSolution : contact your local cable company or Motorola and ask\n\
for a patch");
 }
else if(vulnerable)
 { 
  /* Finding a login/pass combination is very unlikely, but
   * who knows ? That's why we only report it as an 'info'
   */
   post_hole(args, 1024,
"The remote cable modem can be reconfigured\n\
from anywhere provided that the remote user \n\
finds the good login/password combination\n\
Solution : contact your cable company or Motorola and\n\
ask for a patch");
 }
 
 
 if(vulnerable)
{
 /* It's possible to crash a cable modem by telnetting a lot
  * to it, since there is a memory leak in it.
  * So we have to warn the user about this one.
  * We won't actually perform the DoS, because I don't
  * know what does it take to restore a crashed cable router...
  */
  
   post_info(args, 1024,
"It _may_ be possible to crash the remote cable modem\n\
by connecting a lot to port 1024 : Motorola admitted that\n\
there was a memory leak in it, and that it could run\n\
out of memory and crash\n\n\
If you are vulnerable to this attack, contact your cable\n\
company or Motorola, and ask for a patch");
 }
}
return(0);
}
