#include <config.h>
#include <nessuslib.h>
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifndef NESSUS_NT
#include <sys/types.h>
#include <sys/socket.h>   
#else
#include <windows.h>
#endif

#define NAME "Windows NT ftp 'guest' account"
#define DESC "This plugin determines whether the 'guest' account\n\
of a remote WindowsNT box has been disabled"
#define COPYRIGHT "no copyright"
#define SUMM "checks if there's a 'guest' account on the remote WindowsNT ftp server"





PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "FTP");
	return(0);
}
	

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int soc;
	char * buf;
	
	
	if(host_get_port_state(args, 21)<=0)return(0);
	soc = open_sock_tcp(args, 21);
	if(soc<0)return(-1);
	buf = emalloc(4096);
	
        recv_line(soc, buf, 4095);    
        
	sprintf(buf, "USER guest\n");
	send(soc, buf, strlen(buf),0);
        recv_line(soc, buf, 4095);   
        
        sprintf(buf, "PASS guest\n");
        send(soc, buf, strlen(buf),0);
	recv(soc, buf, 4,0);
	if(!strncmp(buf, "230", 3))
	{
	 post_hole(args, 21, 
"The remote host has a 'guest' account set up for ftp, and it's\n\
usually not a good thing...");	
       }
        efree(&buf);
        closesocket(soc);
	return(0);
}

