#include <config.h>
#include <nessuslib.h>
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifndef NESSUS_NT
#include <sys/types.h>
#include <sys/socket.h>   
#include <signal.h>
#else
#include <windows.h>
#endif

#define NAME "qpopper buffer overflow"
#define DESC "\
There's a bug on some versions of qpopper which allow a remote user\n\
to become root using a buffer overflow\n\
This plugin determines if the remote qpopper is subject to this\n\
attack\n\n\
Risk factor : high"
#define COPYRIGHT "no copyright"
#define SUMM "qpopper buffer overflow"



PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Gain root remotely");
	return(0);
}




PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	if((host_get_port_state(args, 110))>0)
	{
	 int soc = open_sock_tcp(args, 110);
	 if(soc<0)return(0);
	 else
	 {
	  char * buf = emalloc(4096);
	  char * command;
          recv_line(soc, buf, 4095);
	  memset(buf, 'A', 4095);
	  command = emalloc(6000);
	  sprintf(command, "%s\r\nQUIT\n", buf);
	  efree(&buf);
	  send(soc, command, strlen(command),0);
	  recv_line(soc, command, 6000); /* ERROR.... */
#ifndef NESSUS_NT
          signal(SIGPIPE, SIG_IGN);
#endif
          recv_line(soc, command, 6000); /* +OK... */
          if(!strlen(command))
               {
           post_hole(args, 110, 
"The remote qpopper is subject to a buffer overrun attack\n\
which may allow any remote user to become root easily\n\
Solution : upgrade");
		}
          efree(&command);
	  closesocket(soc);
	 }
	}
	return(0);
}
