#include <config.h>
#include <nessuslib.h>
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#ifndef NESSUS_NT
#include <sys/types.h>
#include <sys/socket.h>   
#else
#include <windows.h>
#endif

#include "sendmail.h"

/*
 * This plugin must disappear ! -- it's being replaced by the
 * sendmail_* family...
 */
 
#define NAME "Sendmail standard vulnerabilities tester"
#define DESC "A lot of security holes have been found in sendmail"
#define COPYRIGHT "no copyright"
#define SUMM "gets infos about sendmail"




char *get_sendmail_version(int soc);
short is_sendmail_exploitable(char *version);



struct sendmailhacks_t smh[] =
  		{
  			{"SunOS-sendmailV5.1", '=', 1, "SunOS -qf"},
  			{"SunOS-sendmailV5.22", '=', 1, "SunOS -oR"},
  			{"5.55", '=', 0, "'| program'"},
  			{"5.61", '=', 1, ".forward"},
  			{"5.65", '=', 1, "tail"},
  			{"4.1", '=', 0, ""},
  			{"8.6.4", '<', 1, "-d387654321"},
  			{"8.6.7", '=', 1, "-oE/filename bounce"},
  			{"8.6.9", '=', 1, "ident/newlines"},
  			{"8.6.10",'=', 1, "ident/newlines"},
  			{"8.7.5", '<', 1, "gecos"},
  			{"8.8.0",'=', 1, "mime7to8"},
  			{"8.8.2",'=', 1, "smtpd"},
  			{"8.8.6", '=', 1, "-Cfilename"}
  			};
#define NUM_EXPLOITS 13

char *get_sendmail_version(int soc);


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Sendmail");
	return(0);
}
	

PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
	int soc;
	char * version;
	int index;
	
	
	if(host_get_port_state(args, 25)<=0)return(0);
	soc = open_sock_tcp(args, 25);
	if(soc<0)return(-1);
	version = (char*)get_sendmail_version(soc);
	
	if(version && (index = is_sendmail_exploitable(version)))
	{
	 char * report = emalloc(255);
	 sprintf(report, "Sendmail may be exploitable (%s: %s)\n", version, smh[index].hack_desc);
	 post_hole(args, 25, report);
	}
	closesocket(soc);
	return(0);
}


char *get_sendmail_version(int soc)
{
 char *buff = emalloc(512), *lit=emalloc(128), *dummy;
 short read1=0;

 recv(soc, (void*)buff, 512, 0);
 dummy = strstr(buff, "Sendmail");
 /* free(buff); */
 if ((dummy) && (read1 = sscanf(dummy, "Sendmail %s/", lit)) &&
  (lit) && (dummy=strchr(lit, '/')))
 {
  dummy[0]=0;
  return(lit);
 }
 else return NULL;
}

/* 
   is_sendmail_exploitable()

   Parameters :
      char * version : version of sendmail
      <obsolete stuff here>
   Returns :
    
      0 if it's not exploitable or
      the index of the exploit in the struct sendmailhacks_t

      This function checks wether sendmail is exploitable or not, 
      by comparing the version number to the ones presents in the
      smh structure.
*/

		
short is_sendmail_exploitable(char *version)
{
 
 	int i;
  	
 	for(i=0;i<NUM_EXPLOITS;i++)
 		{
 		if(smh[i].less == '=')
 			if(!strncmp(version, smh[i].version, strlen(version)))
 				return i;
 		if(smh[i].less == '<')
 			if(strncmp(version, smh[i].version, strlen(version))<0)
 				return(i);
 		}
	return(0);
}
	


