#include <config.h>
#include <nessuslib.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef NESSUS_NT
#include <unistd.h>
#include <string.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#else
#include <windows.h>
#endif


#define NAME "SSH Insertion attack"
#define DESC "Older versions of the SSH protocol\n\
are vulnerable to an 'insertion attack'\n\
This means that an attacker with access to the\n\
encrypted SSH stream may insert encrypted blocks in the\n\
stream that will decrypt to arbitrary commands to be executed\n\
on the SSH server.\n\n\
Risk factor: High"
#define COPYRIGHT "Discovered by CORE SDI S.A <http://www.core-sdi.com>"
#define SUMM "checks for the version SSH protocol used on a remote machine"




PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
  plug_set_name(desc, NAME);
  plug_set_description(desc, DESC);
  plug_set_summary(desc, SUMM);
  plug_set_copyright(desc, COPYRIGHT);
  plug_set_category(desc, ACT_GATHER_INFO);
  plug_set_family(desc, "Misc.");
  return(0);
}


PlugExport int plugin_run(struct arglist * env);
PlugExport int plugin_run(struct arglist * env)
{
  int soc;
  char * data;
  char * t;
  if(!host_get_port_state(env, 22))return(0);
  
  soc = open_sock_tcp(env, 22);
  if(soc<=0)return(0);
  data = emalloc(255);
  recv_line(soc, data, 255);
  t = strchr(data, '-');
  if(t)
    {
      char * t2;
      t+=sizeof(char);
      t2 = strchr(t, '-');
      if(t2)
	{
	  int proto_version = 0;
	  int proto_revision = 0;
	  t2[0]=0;
	  t2 = strchr(t, '.');
	  t2[0] = 0;
	  t2+=sizeof(char);
	  proto_version = atoi(t);
	  proto_revision = atoi(t2);
	  if((proto_version < 2)&&(proto_version >0))
	    {
	      post_hole(env, 22, 
			"The remote host is vulnerable to the ssh insertion\n\
attack. This means that an attacker with access to the\n\
encrypted SSH stream may insert encrypted blocks in the\n\
stream that will decrypt to arbitrary commands to be executed\n\
on the SSH server.\n\
Solution : upgrade to the protocol version 2.0");
	    }
	}
    }
  closesocket(soc);
  efree(&data);
  return(0);
}
