#include <config.h>
#include <nessuslib.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */

#ifndef NESSUS_NT
#include <unistd.h>
#include <netinet/in.h>
#include <nessuslib.h>
#include <sys/socket.h>  
#else
#include <windows.h>
#endif

#define NAME "Standard System holes"
#define DESC "Underlines little holes of a newly installed system \
Most newly installed system have some 'standard' ports opens, that are \
no use to anyone except the intruders"
#define COPYRIGHT "no copyright"
#define SUMM "underlines little holes of a newly installed system"


PlugExport int plugin_init(struct arglist *desc);
PlugExport int plugin_init(struct arglist *desc)
{
	plug_set_name(desc, NAME);
	plug_set_description(desc, DESC);
	plug_set_summary(desc, SUMM);
	plug_set_copyright(desc, COPYRIGHT);
	plug_set_category(desc, ACT_GATHER_INFO);
	plug_set_family(desc, "Misc.");
	return(0);
}



PlugExport int plugin_run(struct arglist * args);	
PlugExport int plugin_run(struct arglist * args)
{
 int soc;
  if(host_get_port_state(args, 7)>0)
  	{
	if((soc = open_sock_tcp(args, 7))>0)
	{
  	 post_info(args, 7, 
  	 "The 'echo' port is open :\nThis may lead to denial of services");
	 closesocket(soc);
	 }
  	}
  if(host_get_port_state(args, 11)>0)
  	{
	if((soc = open_sock_tcp(args, 11))>0)
	{
  	post_info(args, 11, 
  	"The 'systat' port is open :\nThis can give away some informations to an intruder");
	closesocket(soc);
	}
	}
  if(host_get_port_state(args, 15)>0)
  	{
	if((soc = open_sock_tcp(args, 15))>0)
	{
  	post_info(args, 15,
  	"The 'netstat' port is open :\nThis can give away some informations to an intruder");
	closesocket(soc);
	}
	}
  if(host_get_port_state(args, 79)>0)
  	{
	if((soc = open_sock_tcp(args, 7))>0)
	{
  	post_info(args, 79,
  	"The 'finger' port is open :\nThis can give away valuable informations to an intruder");
	closesocket(soc);
	}
	}
  return(0);
}

